/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.editable;

import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.GrabPoint;
import com.bbn.openmap.omGraphics.editable.EOMGCursors;
import com.bbn.openmap.omGraphics.editable.EOMGSelectedState;
import com.bbn.openmap.omGraphics.event.EOMGEvent;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.stateMachine.State;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class GraphicSelectedState
extends State
implements EOMGSelectedState {
    protected EditableOMGraphic graphic;

    public GraphicSelectedState(EditableOMGraphic eomg) {
        this.graphic = eomg;
    }

    public boolean mousePressed(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.isMouseEventTouching(e)) {
                if (this.graphic.getCanGrabGraphic()) {
                    Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - graphic held");
                    this.graphic.getStateMachine().setEdit();
                    this.graphic.fireEvent(EOMGCursors.MOVE, "", 3);
                    this.graphic.move(e);
                } else {
                    Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - graphic can't be held");
                }
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", -1);
            } else {
                Debug.message("eomg", "GraphicStateMachine|selected state|mousePressed - click off graphic");
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", -1);
            }
        } else {
            this.graphic.getStateMachine().setEdit();
            this.graphic.fireEvent(EOMGCursors.EDIT, "", 3);
        }
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseReleased(MouseEvent e) {
        Debug.message("eomg", "GraphicStateMachine|selected state|mouseReleased");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.isMouseEventTouching(e) || SwingUtilities.isRightMouseButton(e)) {
                if (this.graphic.getCanGrabGraphic()) {
                    this.graphic.fireEvent(EOMGCursors.EDIT, "", e, -1);
                    this.graphic.redraw(e, true);
                } else {
                    this.graphic.fireEvent(EOMGCursors.DEFAULT, "", e, -1);
                }
            } else if (this.graphic.isPopupIsUp()) {
                this.graphic.setPopupIsUp(false);
            } else {
                Debug.message("eomg", " deactivating with fired event");
                this.graphic.fireEvent(new EOMGEvent());
            }
        } else {
            this.graphic.fireEvent(EOMGCursors.EDIT, "", e, -1);
            this.graphic.redraw(e, true);
        }
        this.graphic.setMovingPoint(null);
        return this.getMapMouseListenerResponse();
    }

    public boolean mouseMoved(MouseEvent e) {
        Debug.message("eomgdetail", "GraphicStateMachine|selected state|mouseMoved");
        GrabPoint mp = this.graphic.getMovingPoint(e);
        if (mp == null) {
            if (this.graphic.isMouseEventTouching(e)) {
                this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(GraphicSelectedState.class, "Click_and_Drag_to_move_the_graphic.", "Click and Drag to move the graphic."), -1);
            } else {
                this.graphic.fireEvent(EOMGCursors.DEFAULT, "", -1);
            }
        } else {
            this.graphic.fireEvent(EOMGCursors.EDIT, this.i18n.get(GraphicSelectedState.class, "Click_and_Drag_to_change_the_graphic.", "Click and Drag to change the graphic."), -1);
        }
        return false;
    }
}

