/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.graphicLoader;

import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.graphicLoader.GraphicLoader;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.plugin.graphicLoader.GraphicLoaderPlugIn;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class GraphicLoaderConnector
extends OMComponent {
    protected LayerHandler layerHandler = null;
    protected int newLayerIndex = 0;
    protected boolean newLayerVisible = true;
    protected List orphanGraphicLoaderPlugIns = null;
    public static final String NewLayerIndexProperty = "newLayerIndex";
    public static final String NewLayerVisibleProperty = "newLayerVisible";

    public void setNewLayerIndex(int i) {
        this.newLayerIndex = i;
    }

    public int getNewLayerIndex() {
        return this.newLayerIndex;
    }

    public void setNewLayerVisible(boolean set) {
        this.newLayerVisible = set;
    }

    public boolean setNewLayerVisible() {
        return this.newLayerVisible;
    }

    public void setLayerHandler(LayerHandler lh) {
        this.layerHandler = lh;
        if (this.orphanGraphicLoaderPlugIns != null) {
            if (Debug.debugging("glc")) {
                Debug.output("GraphicLoaderConnector: have LayerHandler, adding PlugInLayers from orphaned GraphicLoaders");
            }
            Iterator it = this.orphanGraphicLoaderPlugIns.iterator();
            while (it.hasNext()) {
                this.layerHandler.addLayer((PlugInLayer)it.next(), this.newLayerIndex);
            }
            this.orphanGraphicLoaderPlugIns = null;
        }
    }

    public LayerHandler getLayerHandler() {
        return this.layerHandler;
    }

    public void checkGraphicLoader(GraphicLoader gl) {
        if (gl.getReceiver() == null) {
            this.hookUpGraphicLoaderWithLayer(gl);
        }
    }

    public void hookUpGraphicLoaderWithLayer(GraphicLoader gl) {
        if (gl != null) {
            GraphicLoaderPlugIn glpi = new GraphicLoaderPlugIn();
            gl.setReceiver(glpi);
            glpi.setGraphicLoader(gl);
            LayerHandler lh = this.getLayerHandler();
            PlugInLayer pl = new PlugInLayer();
            pl.setPlugIn(glpi);
            pl.setName(gl.getName());
            pl.setVisible(this.newLayerVisible);
            if (lh != null) {
                lh.addLayer(pl, this.newLayerIndex);
            } else {
                if (this.orphanGraphicLoaderPlugIns == null) {
                    this.orphanGraphicLoaderPlugIns = new LinkedList();
                }
                this.orphanGraphicLoaderPlugIns.add(pl);
            }
        }
    }

    public void findAndInit(Object obj) {
        if (obj instanceof GraphicLoader) {
            this.checkGraphicLoader((GraphicLoader)obj);
        }
        if (obj instanceof LayerHandler) {
            Debug.message("graphicLoader", "GraphicLoaderConnector found a LayerHandler.");
            this.setLayerHandler((LayerHandler)obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof LayerHandler) {
            Debug.message("graphicLoader", "GraphicLoaderConnector removing a LayerHandler.");
            LayerHandler lh = this.getLayerHandler();
            if (lh != null && lh == (LayerHandler)obj) {
                this.setLayerHandler(null);
            }
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.newLayerIndex = PropUtils.intFromProperties(props, prefix + NewLayerIndexProperty, this.newLayerIndex);
        this.newLayerVisible = PropUtils.booleanFromProperties(props, prefix + NewLayerVisibleProperty, this.newLayerVisible);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + NewLayerIndexProperty, Integer.toString(this.newLayerIndex));
        props.put(prefix + NewLayerVisibleProperty, new Boolean(this.newLayerVisible).toString());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put(NewLayerIndexProperty, "The new layer index, where it should be added to the map. (0 on top)");
        list.put(NewLayerVisibleProperty, "Whether a new layer should initially be visible");
        list.put("newLayerVisible.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }
}

