/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.MoreMath;
import com.bbn.openmap.proj.ProjMath;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawUtil {
    private DrawUtil() {
    }

    public static final int[] lineSegments(int x1, int y1, int x2, int y2, int n, boolean include_last, int[] ret_val) {
        float inc;
        if (n <= 0) {
            ret_val = new int[]{x1, y1};
            return ret_val;
        }
        float dx = x2 - x1;
        float dy = y2 - y1;
        int end = include_last ? n + 1 : n;
        end <<= 1;
        float t = inc = 1.0f / (float)n;
        ret_val[0] = x1;
        ret_val[1] = y1;
        int i = 2;
        while (i < end) {
            ret_val[i] = x1 + (int)(dx * t);
            ret_val[i + 1] = y1 + (int)(dy * t);
            i += 2;
            t += inc;
        }
        return ret_val;
    }

    public static final Point[] lineSegments(Point pt1, Point pt2, int n, boolean include_last) {
        float inc;
        Point v = new Point(pt2.x - pt1.x, pt2.y - pt1.y);
        int end = include_last ? n + 1 : n;
        Point[] ret_val = new Point[end];
        float t = inc = 1.0f / (float)n;
        ret_val[0] = pt1;
        int i = 1;
        while (i < end) {
            ret_val[i] = new Point(pt1.x + (int)((float)v.x * t), pt1.y + (int)((float)v.y * t));
            ++i;
            t += inc;
        }
        return ret_val;
    }

    public static final Point[] bresenham_line(Point pt1, Point pt2) {
        return DrawUtil.bresenham_line(pt1.x, pt1.y, pt2.x, pt2.y);
    }

    public static final Point[] bresenham_line(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int ax = Math.abs(dx) << 1;
        int sx = MoreMath.sign(dx);
        int dy = y2 - y1;
        int ay = Math.abs(dy) << 1;
        int sy = MoreMath.sign(dy);
        int t = Math.max(Math.abs(dx), Math.abs(dy)) + 1;
        Point[] ret_val = new Point[t];
        int x = x1;
        int y = y1;
        if (ax > ay) {
            int d = ay - (ax >> 1);
            int i = 0;
            while (true) {
                ret_val[i++] = new Point(x, y);
                if (x == x2) {
                    return ret_val;
                }
                if (d >= 0) {
                    y += sy;
                    d -= ax;
                }
                x += sx;
                d += ay;
            }
        }
        int d = ax - (ay >> 1);
        int i = 0;
        while (true) {
            ret_val[i++] = new Point(x, y);
            if (y == y2) {
                return ret_val;
            }
            if (d >= 0) {
                x += sx;
                d -= ay;
            }
            y += sy;
            d += ax;
        }
    }

    public static final boolean inside_polygon(float[] xpts, float[] ypts, double ptx, double pty) {
        double d;
        boolean inside_flag = false;
        int numverts = xpts.length;
        if (numverts <= 2) {
            return false;
        }
        Point2D.Float vtx0 = new Point2D.Float();
        Point2D.Float vtx1 = new Point2D.Float();
        int crossings = 0;
        boolean xflag0 = false;
        boolean yflag0 = false;
        boolean yflag1 = false;
        ((Point2D)vtx0).setLocation(xpts[numverts - 1], ypts[numverts - 1]);
        double dv0 = ((Point2D)vtx0).getY() - pty;
        yflag0 = d >= 0.0;
        for (int j = 0; j < numverts; ++j) {
            if ((j & 1) != 0) {
                double d2;
                ((Point2D)vtx0).setLocation(xpts[j], ypts[j]);
                dv0 = ((Point2D)vtx0).getY() - pty;
                yflag0 = d2 >= 0.0;
            } else {
                ((Point2D)vtx1).setLocation(xpts[j], ypts[j]);
                boolean bl = yflag1 = ((Point2D)vtx1).getY() >= pty;
            }
            if (yflag0 != yflag1) {
                xflag0 = ((Point2D)vtx0).getX() >= ptx;
                if (xflag0 == ((Point2D)vtx1).getX() >= ptx) {
                    if (xflag0) {
                        ++crossings;
                    }
                } else {
                    crossings += ((Point2D)vtx0).getX() - dv0 * (((Point2D)vtx1).getX() - ((Point2D)vtx0).getX()) / (((Point2D)vtx1).getY() - ((Point2D)vtx0).getY()) >= ptx ? 1 : 0;
                }
            }
            inside_flag = crossings & true;
        }
        return inside_flag;
    }

    public static final float closestPolyDistance(float[] xpts, float[] ypts, double ptx, double pty, boolean connected) {
        float temp;
        if (xpts.length == 0) {
            return Float.POSITIVE_INFINITY;
        }
        if (xpts.length == 1) {
            return (float)DrawUtil.distance((double)xpts[0], (double)ypts[0], ptx, pty);
        }
        float distance = Float.POSITIVE_INFINITY;
        int i = 0;
        for (int j = 1; j < xpts.length; ++j) {
            temp = (float)DrawUtil.distance_to_line(xpts[i], ypts[i], xpts[j], ypts[j], ptx, pty);
            if (temp < distance) {
                distance = temp;
            }
            ++i;
        }
        if (connected && (temp = (float)DrawUtil.distance_to_line(xpts[i], ypts[i], xpts[0], ypts[0], ptx, pty)) < distance) {
            distance = temp;
        }
        return distance;
    }

    public static final float distance(float x1, float y1, float x2, float y2) {
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        return (float)Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }

    public static final float distance(int x1, int y1, int x2, int y2) {
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        return (float)Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }

    public static final double distance(double x1, double y1, double x2, double y2) {
        double xdiff = x2 - x1;
        double ydiff = y2 - y1;
        return Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }

    public static final int pixel_distance(int x1, int y1, int x2, int y2) {
        int dy;
        int dx = Math.abs(x1 - x2);
        return dx > (dy = Math.abs(y1 - y2)) ? dx : dy;
    }

    public static final float distance_to_endpoint(int x1, int y1, int x2, int y2, int x, int y) {
        return Math.min(DrawUtil.distance(x1, y1, x, y), DrawUtil.distance(x2, y2, x, y));
    }

    public static final float OLD_distance_to_line(int x1, int y1, int x2, int y2, int x, int y) {
        if (x2 == x1) {
            if (y1 <= y && y <= y2 || y2 <= y && y <= y1) {
                return Math.abs(x - x1);
            }
            return DrawUtil.distance_to_endpoint(x1, y1, x2, y2, x, y);
        }
        if (y2 == y1) {
            if (x1 <= x && x <= x2 || x2 <= x && x <= x1) {
                return Math.abs(y - y1);
            }
            return DrawUtil.distance_to_endpoint(x1, y1, x2, y2, x, y);
        }
        float m = (float)(y2 - y1) / (float)(x2 - x1);
        float c = -1.0f / m;
        float d = (float)y - c * (float)x;
        float b = (float)y1 - m * (float)x1;
        int xi = (int)ProjMath.qint((d - b) / (m - c));
        int yi = (int)ProjMath.qint(c * (float)xi + d);
        if ((x1 <= xi && xi <= x2 || x2 <= xi && xi <= x1) && (y1 <= yi && yi <= y2 || y2 <= yi && yi <= y1)) {
            return DrawUtil.distance(xi, yi, x, y);
        }
        return DrawUtil.distance_to_endpoint(x1, y1, x2, y2, x, y);
    }

    public static final float perpendicular_distance_to_line(int x1, int y1, int x2, int y2, int x3, int y3) {
        int x12 = x2 - x1;
        int y12 = y2 - y1;
        int x13 = x3 - x1;
        int y13 = y3 - y1;
        float D12 = DrawUtil.distance(x1, y1, x2, y2);
        return Math.abs((float)(x12 * y13 - x13 * y12) / D12);
    }

    public static final double distance_to_line(double x1, double y1, double x2, double y2, double x3, double y3) {
        double x12 = x2 - x1;
        double x13 = x3 - x1;
        double y12 = y2 - y1;
        double y13 = y3 - y1;
        double D12 = Math.sqrt(x12 * x12 + y12 * y12);
        double pp = (x12 * x13 + y12 * y13) / D12;
        if (pp < 0.0) {
            return (float)Math.sqrt(x13 * x13 + y13 * y13);
        }
        if (pp > D12) {
            double x23 = x3 - x2;
            double y23 = y3 - y2;
            return Math.sqrt(x23 * x23 + y23 * y23);
        }
        return Math.abs((x12 * y13 - y12 * x13) / D12);
    }

    public static List<int[]> generateWideLine(int lw, int x1, int y1, int x2, int y2) {
        int off2;
        ArrayList<int[]> ret_val = new ArrayList<int[]>(2);
        int[] x = new int[4];
        int[] y = new int[4];
        int off1 = lw / 2;
        int n = off2 = lw % 2 != 0 ? lw / 2 + 1 : lw / 2;
        if (Math.abs((float)(y2 - y1) / (float)(x2 - x1)) <= 1.0f) {
            x[0] = x[3] = x1;
            x[1] = x[2] = x2;
            y[0] = y1 + off1;
            y[1] = y2 + off1;
            y[2] = y2 - off2;
            y[3] = y1 - off2;
            ret_val.add(x);
            ret_val.add(y);
        } else {
            x[0] = x1 + off1;
            x[1] = x2 + off1;
            x[2] = x2 - off2;
            x[3] = x1 - off2;
            y[0] = y[3] = y1;
            y[1] = y[2] = y2;
            ret_val.add(x);
            ret_val.add(y);
        }
        return ret_val;
    }

    public static final List<int[]> generateWidePoly(int lw, int[] xpts, int[] ypts, int[] altx, boolean connect) {
        return DrawUtil.generateWidePoly(lw, xpts.length, xpts, ypts, altx, connect);
    }

    public static final List<int[]> generateWidePoly(int lw, int len, int[] xpts, int[] ypts, int[] altx, boolean connect) {
        int end;
        ArrayList<int[]> ret_val = new ArrayList<int[]>(len * 4);
        int off1 = 0;
        int off2 = 0;
        int[] x = null;
        int[] y = null;
        int[] a_x = null;
        int n = end = connect ? len : len - 1;
        if (len <= 1) {
            return new ArrayList<int[]>();
        }
        off1 = lw / 2;
        off2 = (int)Math.ceil((float)lw / 2.0f);
        int i = 0;
        int j = (i + 1) % len;
        while (i < end) {
            x = new int[4];
            y = new int[4];
            float slope = xpts[i] == xpts[j] ? Float.POSITIVE_INFINITY : Math.abs((float)(ypts[j] - ypts[i]) / (float)(xpts[j] - xpts[i]));
            if (slope <= 1.0f) {
                x[0] = x[3] = xpts[i];
                x[1] = x[2] = xpts[j];
                y[0] = ypts[i] + off1;
                y[1] = ypts[j] + off1;
                y[2] = ypts[j] - off2;
                y[3] = ypts[i] - off2;
                ret_val.add(x);
                ret_val.add(y);
                if (altx != null) {
                    a_x = new int[4];
                    a_x[0] = a_x[3] = altx[i];
                    a_x[1] = a_x[2] = altx[j];
                    ret_val.add(a_x);
                    ret_val.add(y);
                }
            } else {
                x[0] = xpts[i] + off1;
                x[1] = xpts[j] + off1;
                x[2] = xpts[j] - off2;
                x[3] = xpts[i] - off2;
                y[0] = y[3] = ypts[i];
                y[1] = y[2] = ypts[j];
                ret_val.add(x);
                ret_val.add(y);
                if (altx != null) {
                    a_x = new int[]{altx[i] + off1, altx[j] + off1, altx[j] - off2, altx[i] - off2};
                    ret_val.add(a_x);
                    ret_val.add(y);
                }
            }
            j = (++i + 1) % len;
        }
        return ret_val;
    }
}

