/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.time;

import com.bbn.openmap.util.HashCodeUtil;
import java.io.Serializable;

public class TimeBounds
implements Serializable {
    protected long startTime;
    protected long endTime;

    public TimeBounds() {
        this.setTimes(Long.MAX_VALUE, Long.MIN_VALUE);
    }

    public TimeBounds(long start, long end) {
        this.setTimes(start, end);
    }

    public void setTimes(long start, long end) {
        this.startTime = start;
        this.endTime = end;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void reset() {
        this.startTime = Long.MAX_VALUE;
        this.endTime = Long.MIN_VALUE;
    }

    public void addTimeToBounds(long timeStamp) {
        if (timeStamp < this.startTime) {
            this.startTime = timeStamp;
        }
        if (timeStamp > this.endTime) {
            this.endTime = timeStamp;
        }
    }

    public String toString() {
        return "TimeBounds[start=" + this.startTime + ", end=" + this.endTime + "]";
    }

    public void addTimeToBounds(TimeBounds timeBounds) {
        this.addTimeToBounds(timeBounds.getStartTime());
        this.addTimeToBounds(timeBounds.getEndTime());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeBounds timeBounds = (TimeBounds)obj;
        return this.startTime == timeBounds.getStartTime() && this.endTime == timeBounds.getEndTime();
    }

    public boolean isUnset() {
        return this.startTime == Long.MAX_VALUE && this.endTime == Long.MIN_VALUE;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtil.hash(result, this.startTime);
        result = HashCodeUtil.hash(result, this.endTime);
        return result;
    }
}

