/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.dnd;

import com.bbn.openmap.MapBean;
import com.bbn.openmap.SoloMapComponent;
import com.bbn.openmap.tools.dnd.DefaultDnDCatcher;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextMembershipEvent;
import java.beans.beancontext.BeanContextMembershipListener;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;

public class DropListenerSupport
implements PropertyChangeListener,
Serializable,
BeanContextChild,
BeanContextMembershipListener,
SoloMapComponent,
MouseListener,
MouseMotionListener {
    protected transient Vector dndCatchers = new Vector(2);
    protected transient MapBean map;
    protected PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);
    protected BeanContextChildSupport beanContextChildSupport = new BeanContextChildSupport();

    public DropListenerSupport() {
        this(null);
    }

    public DropListenerSupport(MapBean map) {
        this.setMap(map);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.addPropertyChangeListener(propertyName, in_pcl);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.addVetoableChangeListener(propertyName, in_vcl);
    }

    public void childrenAdded(BeanContextMembershipEvent bcme) {
        this.findAndInit(bcme.iterator());
    }

    public void childrenRemoved(BeanContextMembershipEvent bcme) {
        Iterator it = bcme.iterator();
        while (it.hasNext()) {
            this.findAndUndo(it.next());
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("droplistenersupport", "DropListenerSupport found a map.");
            this.setMap((MapBean)someObj);
        }
        if (someObj instanceof DefaultDnDCatcher) {
            this.getBeanContext().addBeanContextMembershipListener((DefaultDnDCatcher)someObj);
            Debug.message("DropListener", "DropListener found a DefaultDnDCatcher.");
            this.dndCatchers.addElement(someObj);
        }
    }

    public void findAndInit(Iterator it) {
        while (it.hasNext()) {
            this.findAndInit(it.next());
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean && this.getMap() == (MapBean)someObj) {
            Debug.message("droplistenersupport", "DropListenerSupport: removing the map.");
            this.setMap(null);
        }
    }

    public void firePropertyChange(String property, Object oldObj, Object newObj) {
        this.pcSupport.firePropertyChange(property, oldObj, newObj);
    }

    public void fireVetoableChange(String name, Object oldValue, Object newValue) throws PropertyVetoException {
        this.beanContextChildSupport.fireVetoableChange(name, oldValue, newValue);
    }

    public BeanContext getBeanContext() {
        return this.beanContextChildSupport.getBeanContext();
    }

    public MapBean getMap() {
        return this.map;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        for (int i = 0; i < this.dndCatchers.size() && !((DefaultDnDCatcher)this.dndCatchers.get(i)).consume(e); ++i) {
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        for (int i = 0; i < this.dndCatchers.size() && !((DefaultDnDCatcher)this.dndCatchers.get(i)).consume(e); ++i) {
        }
    }

    public void mouseReleased(MouseEvent e) {
        for (int i = 0; i < this.dndCatchers.size() && !((DefaultDnDCatcher)this.dndCatchers.get(i)).consume(e); ++i) {
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener in_pcl) {
        this.pcSupport.removePropertyChangeListener(propertyName, in_pcl);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener in_vcl) {
        this.beanContextChildSupport.removeVetoableChangeListener(propertyName, in_vcl);
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        if (in_bc != null) {
            in_bc.addBeanContextMembershipListener(this);
            this.beanContextChildSupport.setBeanContext(in_bc);
            this.findAndInit(in_bc.iterator());
        }
    }

    public void setMap(MapBean mapbean) {
        if (this.map != null) {
            this.map.removePropertyChangeListener(this);
            this.map.removeMouseListener(this);
            this.map.removeMouseMotionListener(this);
        }
        this.map = mapbean;
        if (this.map != null) {
            this.map.addPropertyChangeListener(this);
            this.map.addMouseListener(this);
            this.map.addMouseMotionListener(this);
        }
    }
}

