/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib;

import com.ranfa.lib.Album;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlbumTypeEstimate {
    public static final String ALBUM_DATA_URI = "https://imascg-slstage-wiki.gamerch.com/%E6%A5%BD%E6%9B%B2%E8%A9%B3%E7%B4%B0%E4%B8%80%E8%A6%A7%EF%BC%88%E9%9B%A3%E6%98%93%E5%BA%A6%E5%88%A5%EF%BC%89";
    private static Logger logger = LoggerFactory.getLogger(AlbumTypeEstimate.class);

    public static ArrayList<ArrayList<Album>> getAlbumType() {
        long time = System.currentTimeMillis();
        ArrayList<ArrayList<Album>> res = new ArrayList<ArrayList<Album>>();
        try {
            Document document = Jsoup.connect((String)ALBUM_DATA_URI).userAgent("Java/DelesteRandomSelector  More Information is available at https://github.com/hizumiaoba/DeresteRandomSelector/").maxBodySize(0).timeout(0).get();
            Elements elements = document.getElementsByTag("tbody");
            Elements newMasterPlus = ((Element)elements.get(4)).select("tr");
            Elements legacyMasterPlus = ((Element)elements.get(5)).select("tr");
            CompletableFuture<ArrayList> fetchNew = CompletableFuture.supplyAsync(() -> AlbumTypeEstimate.fetch(newMasterPlus));
            CompletableFuture<ArrayList> fetchLegacy = CompletableFuture.supplyAsync(() -> AlbumTypeEstimate.fetch(legacyMasterPlus));
            res.add(fetchNew.get());
            res.add(fetchLegacy.get());
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            logger.warn("Exception was thrown while fetching Album type.", (Throwable)e);
        }
        logger.info("Album type fetched in {} ms", (Object)(System.currentTimeMillis() - time));
        return res;
    }

    private static ArrayList<Album> fetch(Elements elements) {
        ArrayList<Album> res = new ArrayList<Album>();
        elements.stream().forEach(element -> {
            String type = ((Element)element.select("td").get(0)).text().isEmpty() ? "Not-implemented" : ((Element)element.select("td").get(0)).text();
            String songName = ((Element)element.select("td").get(2)).text();
            Album tmp = new Album();
            tmp.setSongName(songName);
            tmp.setAlbumType(type);
            res.add(tmp);
        });
        return res;
    }

    public static enum ALBUM_TYPE {
        ALBUM_A,
        ALBUM_B,
        ALBUM_C;

    }

    public static enum MASTERPLUS_TYPE {
        NEWMASTERPLUS,
        LEGACYMASTERPLUS;

    }
}

