/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.database;

import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.ranfa.lib.database.AlbumCycleDefinitionProperty;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EstimateAlbumTypeCycle {
    private static final String CYCLEPATH = "generated/albumCycle.json";
    private static final String DATEFORMAT = "YYYY/MM/dd";
    private static Logger logger = LoggerFactory.getLogger(EstimateAlbumTypeCycle.class);
    public static final String ALBUM_A = "ALBUM A";
    public static final String ALBUM_B = "ALBUM B";
    public static final String ALBUM_C = "ALBUM C";

    public static void Initialization() {
        if (Files.exists(Paths.get(CYCLEPATH, new String[0]), new LinkOption[0])) {
            return;
        }
        logger.info("Cycle definition file does not exist.Trying to ask you...");
        AlbumCycleDefinitionProperty property = new AlbumCycleDefinitionProperty();
        String inputType = JOptionPane.showInputDialog("\u73fe\u5728\u306eMASTER\uff0b\u306eALBUM\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\uff08A,B,C\uff09");
        if (!(inputType.equals("A") || inputType.equals("B") || inputType.equals("C"))) {
            logger.error("inputType has invaild.Canceling initiate...");
            return;
        }
        String inputDaysLeft = JOptionPane.showInputDialog("MASTER\uff0b\u306eALBUM\u5207\u308a\u66ff\u3048\u307e\u3067\u3042\u3068\u4f55\u65e5\u3067\u3059\u304b\uff1f\n(\u6b8b\u308a\u6642\u9593\u304c\u8868\u793a\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u306f0\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044)");
        SimpleDateFormat format = new SimpleDateFormat(DATEFORMAT);
        String dateDefinited = format.format(new Date());
        property.setDateDefinited(dateDefinited);
        property.setDaysLeft(Integer.parseInt(inputDaysLeft));
        property.setType(inputType.equals("A") ? ALBUM_A : (inputType.equals("B") ? ALBUM_B : ALBUM_C));
        EstimateAlbumTypeCycle.write(property);
    }

    private static void write(AlbumCycleDefinitionProperty property) {
        ObjectWriter writer = new ObjectMapper().writer(new DefaultPrettyPrinter());
        try {
            writer.writeValue(Paths.get(CYCLEPATH, new String[0]).toFile(), (Object)property);
        }
        catch (IOException e) {
            logger.warn("Couldn't write album type information.", (Throwable)e);
        }
    }

    public static String getCurrentCycle() {
        if (Files.notExists(Paths.get(CYCLEPATH, new String[0]), new LinkOption[0])) {
            throw new IllegalStateException("Program seems to have avoided first initiating. how could it have done?");
        }
        AlbumCycleDefinitionProperty property = new AlbumCycleDefinitionProperty();
        try {
            property = new ObjectMapper().readValue(Paths.get(CYCLEPATH, new String[0]).toFile(), AlbumCycleDefinitionProperty.class);
        }
        catch (IOException e) {
            logger.error("Error while reading local definition file.", (Throwable)e);
        }
        Date presentDate = new Date();
        Calendar presentCalendar = Calendar.getInstance();
        presentCalendar.setTime(presentDate);
        presentCalendar.set(11, 0);
        presentCalendar.set(12, 0);
        presentCalendar.set(13, 0);
        presentCalendar.set(14, 0);
        presentDate = presentCalendar.getTime();
        String dateDefinited = property.getDateDefinited();
        String[] dates = dateDefinited.split("/");
        presentCalendar.set(Integer.parseInt(dates[0]), Integer.parseInt(dates[1]) - 1, Integer.parseInt(dates[2]));
        Date definiteDate = presentCalendar.getTime();
        switch (presentDate.compareTo(definiteDate)) {
            case 0: {
                return property.getType();
            }
            case 1: {
                LocalDate presentLocalDate = presentDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                LocalDate definitedLocalDate = definiteDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                long delta = ChronoUnit.DAYS.between(definitedLocalDate, presentLocalDate);
                if (delta < (long)property.getDaysLeft()) {
                    return property.getType();
                }
                if ((delta -= (long)property.getDaysLeft()) > Integer.MAX_VALUE) {
                    JOptionPane.showMessageDialog(null, "ALBUM\u5468\u671f\u306e\u63a8\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\u66ab\u5b9a\u7684\u306a\u63aa\u7f6e\u3068\u3057\u3066\u524d\u56de\u8d77\u52d5\u6642\u306eALBUM\u7a2e\u985e\u3092\u8868\u793a\u3057\u307e\u3059\u3002\n(\u5185\u90e8\u5909\u6570\u30a8\u30e9\u30fc\uff1adelta has the value that is more than Integer.MAX_VALUE.\uff09");
                    logger.error("Valuable was overflowed.");
                }
                String res = EstimateAlbumTypeCycle.cycling(property.getType(), (int)delta);
                return res;
            }
        }
        throw new IllegalStateException("Date delta has illegal value. the system clock might be incorrect?");
    }

    private static String cycling(String currentType, int times) {
        int cyclingDelta = (times / 14 + 1) % 3;
        String[] typeArray = new String[]{ALBUM_A, ALBUM_B, ALBUM_C};
        int currentIndex = Arrays.asList(typeArray).indexOf(currentType);
        int nextIndex = currentIndex + cyclingDelta;
        int nextIndexDelta = nextIndex % 3;
        return typeArray[nextIndexDelta];
    }
}

