/*
 * Decompiled with CFR 0.152.
 */
package com.ranfa.lib.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import lombok.NonNull;

public class CountedThreadFactory
implements ThreadFactory {
    private final Supplier<String> identifier;
    private final AtomicLong count = new AtomicLong(1L);
    private final boolean isDaemon;

    public CountedThreadFactory() {
        this(() -> "Default", "Thread");
    }

    public CountedThreadFactory(Supplier<String> identifier, String specifier) {
        this(identifier, specifier, true);
    }

    public CountedThreadFactory(Supplier<String> identifier, String specifier, boolean isDaemon) {
        this.identifier = () -> String.valueOf((String)identifier.get()) + " " + specifier;
        this.isDaemon = isDaemon;
    }

    @Override
    public Thread newThread(@NonNull Runnable r) {
        if (r == null) {
            throw new NullPointerException("r is marked non-null but is null");
        }
        Thread thread = new Thread(r, String.valueOf(this.identifier.get()) + "-Worker " + this.count.getAndIncrement());
        thread.setDaemon(this.isDaemon);
        return thread;
    }
}

