/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.ranfa.lib.io.FileIO;
import com.ranfa.lib.io.OutputDataStructure;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import test.mock.ObjectWriteMock;

public class ObjectIOTest {
    private static final String filename = "test.drs";
    private static Map<String, String> testMap;
    private static List<Map<String, String>> testList;

    @BeforeClass
    public static void init() {
        testMap = new LinkedHashMap<String, String>();
        testMap.put("songname", "testname001");
        testMap.put("level", "28");
        testMap.put("difficulty", "MASTER");
        testMap.put("attribute", "\u30ad\u30e5\u30fc\u30c8");
        testMap.put("score", "1200000");
        testList = new ArrayList<Map<String, String>>();
        testList.add(testMap);
    }

    @Test
    public void writeTest() {
        Assert.assertTrue((boolean)ObjectWriteMock.write(testList, filename));
    }

    @Test
    public void readNonNullTest() {
        OutputDataStructure structure = FileIO.read(filename);
        Assert.assertNotNull((Object)structure);
    }

    @Test
    public void readEqualsTest() {
        OutputDataStructure structure = FileIO.read(filename);
        if (structure != null) {
            Assert.assertEquals((Object)new OutputDataStructure(testList), (Object)structure);
        }
    }

    @AfterClass
    public static void del() {
        try {
            Files.deleteIfExists(Paths.get(filename, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

