#set terminal pdf enhanced
#set output "band.pdf"

set border lw 2
#
set style line 1 lt 1 lw 2 lc 0 dashtype 2
set style line 2 lt 1 lw 2 lc 0
set style line 3 lt 1 lw 2 lc 1
#
set ytics scale 3.0, -0.5 2.0 font "GothicBBB-Medium,24"
set xtics( \
"G" 0.0000, \
"M" 0.6013, \
"K" 0.9485, \
"G" 1.6428, \
"A" 2.0972, \
"L" 2.6986, \
"H" 3.0457, \
"A" 3.7401) \
    offset 0.0, 0.0 font "GothicBBB-Medium,24"
set label "E_F" at -0.15, 7.6494 center font "GothicBBB-Medium,24"
#
unset key
#
set grid xtics ls 2
set ylabel "Energy [eV]" offset 0.0, 0.0 font "GothicBBB-Medium,24"
#
plot[:][-5:15] \
               7.6494 ls 1, \
               "bands.out.gnu" u 1:2 w l ls 3
pause -1
