#set terminal pdf enhanced
#set output "pdos.pdf"

set border lw 2
#
set style line 1 lt 0 lw 2 lc 8 dashtype 1
set style line 2 lt 1 lw 2 lc 9
set style line 3 lt 1 lw 2 lc 1
set style line 4 lt 1 lw 2 lc 3
#
set xlabel "Energy [eV]" offset 0.0, 0.0 font "GothicBBB-Medium,24"
set ylabel "Density of states [/eV/spin]" offset 0.0, 0.0 font "GothicBBB-Medium,24"
set xtics font "GothicBBB-Medium,24"
set ytics font "GothicBBB-Medium,24"
#
set key left top font "GothicBBB-Medium,24"
set label "E_F" at 7.6494, -0.05 center font "GothicBBB-Medium,24"
set arrow nohead from 7.6494, 0.0 to 7.6494, 0.9 ls 1
#
plot[-5:15][0:] \
                "pwscf.pdos_tot" u 1:2 w l ls 2 tit "Total", \
                'pwscf.pdos_atm#2(B)_wfc#2(p)' u 1:($3*2) w l ls 3 tit "B p_z", \
                'pwscf.pdos_atm#2(B)_wfc#2(p)' u 1:(($4+$5)*2) w l ls 4 tit "B p_x+p_y"

pause -1
