/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.util.Log;
import java.io.IOException;
import java.util.UUID;

public class QtBluetoothSocketServer
extends Thread {
    long qtObject = 0L;
    public boolean logEnabled = false;
    private static final String TAG = "QtBluetooth";
    private boolean m_isSecure = false;
    private UUID m_uuid;
    private String m_serviceName;
    private BluetoothServerSocket m_serverSocket = null;
    private static final int QT_NO_BLUETOOTH_SUPPORTED = 0;
    private static final int QT_LISTEN_FAILED = 1;
    private static final int QT_ACCEPT_FAILED = 2;

    public QtBluetoothSocketServer() {
        this.setName("QtSocketServerThread");
    }

    public void setServiceDetails(String string, String string2, boolean bl) {
        this.m_uuid = UUID.fromString(string);
        this.m_serviceName = string2;
        this.m_isSecure = bl;
    }

    @Override
    public void run() {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            QtBluetoothSocketServer.errorOccurred(this.qtObject, 0);
            return;
        }
        try {
            if (this.m_isSecure) {
                this.m_serverSocket = bluetoothAdapter.listenUsingRfcommWithServiceRecord(this.m_serviceName, this.m_uuid);
                if (this.logEnabled) {
                    Log.d((String)TAG, (String)"Using secure socket listener");
                }
            } else {
                this.m_serverSocket = bluetoothAdapter.listenUsingInsecureRfcommWithServiceRecord(this.m_serviceName, this.m_uuid);
                if (this.logEnabled) {
                    Log.d((String)TAG, (String)"Using insecure socket listener");
                }
            }
        }
        catch (IOException iOException) {
            if (this.logEnabled) {
                Log.d((String)TAG, (String)("Server socket listen() failed:" + iOException.toString()));
            }
            iOException.printStackTrace();
            QtBluetoothSocketServer.errorOccurred(this.qtObject, 1);
            return;
        }
        if (this.isInterrupted()) {
            return;
        }
        if (this.m_serverSocket != null) {
            try {
                while (!this.isInterrupted()) {
                    if (this.logEnabled) {
                        Log.d((String)TAG, (String)"Waiting for new incoming socket");
                    }
                    BluetoothSocket bluetoothSocket = this.m_serverSocket.accept();
                    if (this.logEnabled) {
                        Log.d((String)TAG, (String)"New socket accepted");
                    }
                    QtBluetoothSocketServer.newSocket(this.qtObject, bluetoothSocket);
                }
            }
            catch (IOException iOException) {
                if (this.logEnabled) {
                    Log.d((String)TAG, (String)("Server socket accept() failed:" + iOException.toString()));
                }
                iOException.printStackTrace();
                QtBluetoothSocketServer.errorOccurred(this.qtObject, 2);
            }
        }
        Log.d((String)TAG, (String)"Leaving server socket thread.");
    }

    public void close() {
        if (!this.isAlive()) {
            return;
        }
        try {
            this.interrupt();
            if (this.m_serverSocket != null) {
                this.m_serverSocket.close();
            }
            this.join(20L);
        }
        catch (Exception exception) {
            Log.d((String)TAG, (String)("Closing server socket close() failed:" + exception.toString()));
            exception.printStackTrace();
        }
    }

    public static native void errorOccurred(long var0, int var2);

    public static native void newSocket(long var0, BluetoothSocket var2);
}

