import DNSConfig, { IDNSConfig } from 'Entities/DNSConfig';
import GetVersionRequest, { IGetVersionRequest } from 'Entities/GetVersionRequest';
import Login, { ILogin } from 'Entities/Login';
import ProfileInfo, { IProfileInfo } from 'Entities/ProfileInfo';
import ServerStatus, { IServerStatus } from 'Entities/ServerStatus';
import UpstreamsConfig, { IUpstreamsConfig } from 'Entities/UpstreamsConfig';
import UpstreamsConfigResponse, { IUpstreamsConfigResponse } from 'Entities/UpstreamsConfigResponse';
import VersionInfo, { IVersionInfo } from 'Entities/VersionInfo';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export default class GlobalApi {
    static async beginUpdate(): Promise<number | Error> {
        return await fetch(`/control/update`, {
            method: 'POST',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async dnsConfig(dnsconfig: IDNSConfig): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const dnsconfigValid = new DNSConfig(dnsconfig);
        haveError.push(...dnsconfigValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/dns_config`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(dnsconfigValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async dnsInfo(): Promise<IDNSConfig | Error> {
        return await fetch(`/control/dns_info`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async getProfile(): Promise<IProfileInfo | Error> {
        return await fetch(`/control/profile`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async getVersionJson(getversionrequest: IGetVersionRequest): Promise<IVersionInfo | string[] | Error> {
        const haveError: string[] = [];
        const getversionrequestValid = new GetVersionRequest(getversionrequest);
        haveError.push(...getversionrequestValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/version.json`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(getversionrequestValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async login(login: ILogin): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const loginValid = new Login(login);
        haveError.push(...loginValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/login`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(loginValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async logout(): Promise<number | Error> {
        return await fetch(`/control/logout`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async status(): Promise<IServerStatus | Error> {
        return await fetch(`/control/status`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async testUpstreamDNS(upstreamsconfig: IUpstreamsConfig): Promise<IUpstreamsConfigResponse | string[] | Error> {
        const haveError: string[] = [];
        const upstreamsconfigValid = new UpstreamsConfig(upstreamsconfig);
        haveError.push(...upstreamsconfigValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/test_upstream_dns`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(upstreamsconfigValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }
}
