import Stats, { IStats } from 'Entities/Stats';
import StatsConfig, { IStatsConfig } from 'Entities/StatsConfig';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export default class StatsApi {
    static async stats(): Promise<IStats | Error> {
        return await fetch(`/control/stats`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async statsConfig(statsconfig: IStatsConfig): Promise<number | string[] | Error> {
        const haveError: string[] = [];
        const statsconfigValid = new StatsConfig(statsconfig);
        haveError.push(...statsconfigValid.validate());
        if (haveError.length > 0) {
            return Promise.resolve(haveError);
        }
        return await fetch(`/control/stats_config`, {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(statsconfigValid.serialize()),
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async statsInfo(): Promise<IStatsConfig | Error> {
        return await fetch(`/control/stats_info`, {
            method: 'GET',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.json();
            } else {
                return new Error(String(res.status));
            }
        })
    }

    static async statsReset(): Promise<number | Error> {
        return await fetch(`/control/stats_reset`, {
            method: 'POST',
        }).then(async (res) => {
            if (res.status === 200) {
                return res.status;
            } else {
                return new Error(String(res.status));
            }
        })
    }
}
