"use strict";
/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.crc32c = exports.crc32 = void 0;
/**
 *
 * A module containing various checksum implementations intended for streaming payloads
 *
 * @packageDocumentation
 * @module checksums
 * @mergeTarget
 */
const binding_1 = __importDefault(require("./binding"));
/**
 * Computes an crc32 checksum.
 *
 * @param data The data to checksum
 * @param previous previous crc32 checksum result. Used if you are buffering large input.
 *
 * @category Crypto
 */
function crc32(data, previous) {
    return binding_1.default.checksums_crc32(data, previous);
}
exports.crc32 = crc32;
/**
 * Computes a crc32c checksum.
 *
 * @param data The data to checksum
 * @param previous previous crc32c checksum result. Used if you are buffering large input.
 *
 * @category Crypto
 */
function crc32c(data, previous) {
    return binding_1.default.checksums_crc32c(data, previous);
}
exports.crc32c = crc32c;
//# sourceMappingURL=checksums.js.map