/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
/**
 * Represents an error encountered in native code. Can also be used to convert a numeric error code into
 * a human-readable string.
 *
 * @module aws-crt
 * @category System
 */
export declare class CrtError extends Error {
    readonly error: any;
    /** The original integer error code from the CRT */
    readonly error_code?: number;
    /** The translated error name (e.g. AWS_ERROR_UNKNOWN) */
    readonly error_name?: string;
    /** @var error - The original error. Most often an error_code, but possibly some other context */
    constructor(error: any);
}
