"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotIdentityClient = exports.IotIdentityError = exports.model = void 0;
const model = __importStar(require("./model"));
exports.model = model;
const util_1 = require("util");
/**
 * @module aws-iot-device-sdk
 * @category IotIdentity
 */
class IotIdentityError extends Error {
    constructor(message, payload) {
        // 'Error' breaks JS prototype chain when instantiated
        super(message);
        this.payload = payload;
        // restore prototype chain
        const myProto = new.target.prototype;
        if (Object.setPrototypeOf) {
            Object.setPrototypeOf(this, myProto);
        }
        else {
            this.prototype = myProto;
        }
    }
}
exports.IotIdentityError = IotIdentityError;
/**
 * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html
 *
 * @module aws-iot-device-sdk
 * @category IotIdentity
 */
class IotIdentityClient {
    constructor(connection) {
        this.connection = connection;
        this.decoder = new util_1.TextDecoder('utf-8');
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     * Publish CreateKeysAndCertificate message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotIdentity
     */
    publishCreateKeysAndCertificate(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create/json";
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to CreateKeysAndCertificateAccepted messages
     *
     * subscribeToCreateKeysAndCertificateAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToCreateKeysAndCertificateAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create/json/accepted";
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to CreateKeysAndCertificateRejected messages
     *
     * subscribeToCreateKeysAndCertificateRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToCreateKeysAndCertificateRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create/json/rejected";
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to RegisterThingRejected messages
     *
     * subscribeToRegisterThingRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToRegisterThingRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/provisioning-templates/{templateName}/provision/json/rejected";
            topic = topic.replace("{templateName}", request.templateName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to CreateCertificateFromCsrAccepted messages
     *
     * subscribeToCreateCertificateFromCsrAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToCreateCertificateFromCsrAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create-from-csr/json/accepted";
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     * Publish RegisterThing message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotIdentity
     */
    publishRegisterThing(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/provisioning-templates/{templateName}/provision/json";
            topic = topic.replace("{templateName}", request.templateName);
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to RegisterThingAccepted messages
     *
     * subscribeToRegisterThingAccepted may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToRegisterThingAccepted(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/provisioning-templates/{templateName}/provision/json/accepted";
            topic = topic.replace("{templateName}", request.templateName);
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     *
     * Subscribe to CreateCertificateFromCsrRejected messages
     *
     * subscribeToCreateCertificateFromCsrRejected may be called while the device is offline, though the async
     * operation cannot complete successfully until the connection resumes.
     *
     * Once subscribed, `messageHandler` is invoked each time a message matching
     * the `topic` is received. It is possible for such messages to arrive before
     * the SUBACK is received.
     *
     * @param request Subscription request configuration
     * @param qos Maximum requested QoS that server may use when sending messages to the client.
     *            The server may grant a lower QoS in the SUBACK
     * @param messageHandler Callback invoked when message or error is received from the server.
     * @returns Promise which returns a `mqtt.MqttSubscribeRequest` which will contain the
     *          result of the SUBSCRIBE. The Promise resolves when a SUBACK is returned
     *          from the server or is rejected when an exception occurs.
     *
     * @category IotIdentity
     */
    subscribeToCreateCertificateFromCsrRejected(request, qos, messageHandler) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create-from-csr/json/rejected";
            const on_message = (topic, payload) => {
                let response;
                let error;
                try {
                    const payload_text = this.decoder.decode(payload);
                    response = JSON.parse(payload_text);
                }
                catch (err) {
                    error = new IotIdentityError(err.message, payload);
                }
                finally {
                    messageHandler(error, response);
                }
            };
            return this.connection.subscribe(topic, qos, on_message);
        });
    }
    /**
     * API Documentation: https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#fleet-provision-api
     * Publish CreateCertificateFromCsr message
     * If the device is offline, the PUBLISH packet will be sent once the connection resumes.
     *
     * @param request Message to be serialized and sent
     * @param qos Quality of Service for delivering this message
     * @returns Promise which returns a `mqtt.MqttRequest` which will contain the packet id of
     *          the PUBLISH packet.
     *
     * * For QoS 0, completes as soon as the packet is sent.
     * * For QoS 1, completes when PUBACK is received.
     * * QoS 2 is not supported by AWS IoT.
     *
     * @category IotIdentity
     */
    publishCreateCertificateFromCsr(request, qos) {
        return __awaiter(this, void 0, void 0, function* () {
            let topic = "$aws/certificates/create-from-csr/json";
            return this.connection.publish(topic, JSON.stringify(request), qos);
        });
    }
}
exports.IotIdentityClient = IotIdentityClient;
//# sourceMappingURL=iotidentityclient.js.map