"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.JobStatus = exports.RejectedErrorCode = void 0;
/**
 * @module aws-iot-device-sdk
 * @category IotJobs
 */
var RejectedErrorCode;
(function (RejectedErrorCode) {
    RejectedErrorCode["UNKNOWN_ENUM_VALUE"] = "UNKNOWN_ENUM_VALUE";
    RejectedErrorCode["INVALID_TOPIC"] = "InvalidTopic";
    RejectedErrorCode["INVALID_STATE_TRANSITION"] = "InvalidStateTransition";
    RejectedErrorCode["RESOURCE_NOT_FOUND"] = "ResourceNotFound";
    RejectedErrorCode["INVALID_REQUEST"] = "InvalidRequest";
    RejectedErrorCode["REQUEST_THROTTLED"] = "RequestThrottled";
    RejectedErrorCode["INTERNAL_ERROR"] = "InternalError";
    RejectedErrorCode["TERMINAL_STATE_REACHED"] = "TerminalStateReached";
    RejectedErrorCode["INVALID_JSON"] = "InvalidJson";
    RejectedErrorCode["VERSION_MISMATCH"] = "VersionMismatch";
})(RejectedErrorCode = exports.RejectedErrorCode || (exports.RejectedErrorCode = {}));
/**
 * @module aws-iot-device-sdk
 * @category IotJobs
 */
var JobStatus;
(function (JobStatus) {
    JobStatus["UNKNOWN_ENUM_VALUE"] = "UNKNOWN_ENUM_VALUE";
    JobStatus["IN_PROGRESS"] = "IN_PROGRESS";
    JobStatus["FAILED"] = "FAILED";
    JobStatus["QUEUED"] = "QUEUED";
    JobStatus["TIMED_OUT"] = "TIMED_OUT";
    JobStatus["SUCCEEDED"] = "SUCCEEDED";
    JobStatus["CANCELED"] = "CANCELED";
    JobStatus["REJECTED"] = "REJECTED";
    JobStatus["REMOVED"] = "REMOVED";
})(JobStatus = exports.JobStatus || (exports.JobStatus = {}));
//# sourceMappingURL=model.js.map