// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.MqttWs = void 0;
const mqtt_1 = require("./mqtt");
/**
 * Provides MQTT over WebSockets transport for the device [client]{@link module:azure-iot-device.Client} class.
 * This class is not meant to be used directly, instead it should just be passed to the [client]{@link module:azure-iot-device.Client} object.
 */
/*Codes_SRS_NODE_DEVICE_MQTT_12_001: [The constructor shall accept the transport configuration structure.]*/
/*Codes_SRS_NODE_DEVICE_MQTT_12_002: [The constructor shall store the configuration structure in a member variable.]*/
/*Codes_SRS_NODE_DEVICE_MQTT_12_003: [The constructor shall create an base transport object and store it in a member variable.]*/
class MqttWs extends mqtt_1.Mqtt {
    /**
     * @private
     * @constructor
     * @param   {Object}    config  Configuration object derived from the connection string by the client.
     */
    constructor(authenticationProvider, mqttBase) {
        super(authenticationProvider, mqttBase);
        /*Codes_SRS_NODE_DEVICE_MQTT_16_017: [The `MqttWs` constructor shall initialize the `uri` property of the `config` object to `wss://<host>:443/$iothub/websocket`.]*/
    }
    _getBaseTransportConfig(credentials) {
        let baseConfig = super._getBaseTransportConfig(credentials);
        baseConfig.uri = 'wss://' + (credentials.gatewayHostName || credentials.host) + ':443/$iothub/websocket';
        return baseConfig;
    }
}
exports.MqttWs = MqttWs;
//# sourceMappingURL=mqtt_ws.js.map