"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var msRest = require("@azure/ms-rest-js");
var Mappers = require("../models/statisticsMappers");
var Parameters = require("../models/parameters");
/** Class representing a Statistics. */
var Statistics = /** @class */ (function () {
    /**
     * Create a Statistics.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    function Statistics(client) {
        this.client = client;
    }
    Statistics.prototype.getDeviceStatistics = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getDeviceStatisticsOperationSpec, callback);
    };
    Statistics.prototype.getServiceStatistics = function (options, callback) {
        return this.client.sendOperationRequest({
            options: options
        }, getServiceStatisticsOperationSpec, callback);
    };
    return Statistics;
}());
exports.Statistics = Statistics;
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var getDeviceStatisticsOperationSpec = {
    httpMethod: "GET",
    path: "statistics/devices",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.RegistryStatistics
        },
        default: {}
    },
    serializer: serializer
};
var getServiceStatisticsOperationSpec = {
    httpMethod: "GET",
    path: "statistics/service",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.ServiceStatistics
        },
        default: {}
    },
    serializer: serializer
};
//# sourceMappingURL=statistics.js.map