/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import * as Mappers from "../models/cloudToDeviceMessagesMappers";
import * as Parameters from "../models/parameters";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";

/** Class representing a CloudToDeviceMessages. */
export class CloudToDeviceMessages {
  private readonly client: IotHubGatewayServiceAPIsContext;

  /**
   * Create a CloudToDeviceMessages.
   * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
   */
  constructor(client: IotHubGatewayServiceAPIsContext) {
    this.client = client;
  }

  /**
   * Deletes all the pending commands for a device in the IoT Hub.
   * @param id The unique identifier of the device.
   * @param [options] The optional parameters
   * @returns Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse>
   */
  purgeCloudToDeviceMessageQueue(id: string, options?: msRest.RequestOptionsBase): Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse>;
  /**
   * @param id The unique identifier of the device.
   * @param callback The callback
   */
  purgeCloudToDeviceMessageQueue(id: string, callback: msRest.ServiceCallback<Models.PurgeMessageQueueResult>): void;
  /**
   * @param id The unique identifier of the device.
   * @param options The optional parameters
   * @param callback The callback
   */
  purgeCloudToDeviceMessageQueue(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PurgeMessageQueueResult>): void;
  purgeCloudToDeviceMessageQueue(id: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.PurgeMessageQueueResult>, callback?: msRest.ServiceCallback<Models.PurgeMessageQueueResult>): Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse> {
    return this.client.sendOperationRequest(
      {
        id,
        options
      },
      purgeCloudToDeviceMessageQueueOperationSpec,
      callback) as Promise<Models.CloudToDeviceMessagesPurgeCloudToDeviceMessageQueueResponse>;
  }

  /**
   * Gets the feedback for cloud-to-device messages. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for more information. This
   * capability is only available in the standard tier IoT Hub. For more information, see [Choose the
   * right IoT Hub tier](https://aka.ms/scaleyouriotsolution).
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  receiveFeedbackNotification(options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
  /**
   * @param callback The callback
   */
  receiveFeedbackNotification(callback: msRest.ServiceCallback<void>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  receiveFeedbackNotification(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  receiveFeedbackNotification(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      receiveFeedbackNotificationOperationSpec,
      callback);
  }

  /**
   * Completes the cloud-to-device feedback message. A completed message is deleted from the feedback
   * queue of the service. See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
   * for more information.
   * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
   * used to resolve race conditions when completing a feedback message.
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  completeFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
  /**
   * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
   * used to resolve race conditions when completing a feedback message.
   * @param callback The callback
   */
  completeFeedbackNotification(lockToken: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param lockToken The lock token obtained when the cloud-to-device message is received. This is
   * used to resolve race conditions when completing a feedback message.
   * @param options The optional parameters
   * @param callback The callback
   */
  completeFeedbackNotification(lockToken: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  completeFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        lockToken,
        options
      },
      completeFeedbackNotificationOperationSpec,
      callback);
  }

  /**
   * Abandons the lock on a cloud-to-device feedback message. See
   * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for more information.
   * @param lockToken The lock token obtained when the cloud-to-device message is received.
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  abandonFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
  /**
   * @param lockToken The lock token obtained when the cloud-to-device message is received.
   * @param callback The callback
   */
  abandonFeedbackNotification(lockToken: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param lockToken The lock token obtained when the cloud-to-device message is received.
   * @param options The optional parameters
   * @param callback The callback
   */
  abandonFeedbackNotification(lockToken: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  abandonFeedbackNotification(lockToken: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        lockToken,
        options
      },
      abandonFeedbackNotificationOperationSpec,
      callback);
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const purgeCloudToDeviceMessageQueueOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "devices/{id}/commands",
  urlParameters: [
    Parameters.id
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {
      bodyMapper: Mappers.PurgeMessageQueueResult
    },
    default: {}
  },
  serializer
};

const receiveFeedbackNotificationOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "messages/serviceBound/feedback",
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    200: {},
    204: {},
    default: {}
  },
  serializer
};

const completeFeedbackNotificationOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "messages/serviceBound/feedback/{lockToken}",
  urlParameters: [
    Parameters.lockToken
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    204: {},
    default: {}
  },
  serializer
};

const abandonFeedbackNotificationOperationSpec: msRest.OperationSpec = {
  httpMethod: "POST",
  path: "messages/serviceBound/feedback/{lockToken}/abandon",
  urlParameters: [
    Parameters.lockToken
  ],
  queryParameters: [
    Parameters.apiVersion
  ],
  responses: {
    204: {},
    default: {}
  },
  serializer
};
