import * as msRest from "@azure/ms-rest-js";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as operations from "./operations";
import { IotHubGatewayServiceAPIsContext } from "./iotHubGatewayServiceAPIsContext";
declare class IotHubGatewayServiceAPIs extends IotHubGatewayServiceAPIsContext {
    configuration: operations.ConfigurationOperations;
    statistics: operations.Statistics;
    devices: operations.Devices;
    bulkRegistry: operations.BulkRegistry;
    query: operations.Query;
    jobs: operations.Jobs;
    cloudToDeviceMessages: operations.CloudToDeviceMessages;
    modules: operations.Modules;
    digitalTwin: operations.DigitalTwin;
    /**
     * Initializes a new instance of the IotHubGatewayServiceAPIs class.
     * @param credentials Subscription credentials which uniquely identify client subscription.
     * @param [options] The parameter options
     */
    constructor(credentials: msRest.ServiceClientCredentials, options?: Models.IotHubGatewayServiceAPIsOptions);
}
export { IotHubGatewayServiceAPIs, IotHubGatewayServiceAPIsContext, Models as IotHubGatewayServiceAPIsModels, Mappers as IotHubGatewayServiceAPIsMappers };
export * from "./operations";
