import * as msRest from "@azure/ms-rest-js";
import * as Models from "../models";
import { IotHubGatewayServiceAPIsContext } from "../iotHubGatewayServiceAPIsContext";
/** Class representing a Jobs. */
export declare class Jobs {
    private readonly client;
    /**
     * Create a Jobs.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client: IotHubGatewayServiceAPIsContext);
    /**
     * Creates a new import or export job on the IoT Hub. See
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
     * for more information.
     * @param jobProperties The job specifications.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsCreateImportExportJobResponse>
     */
    createImportExportJob(jobProperties: Models.JobProperties, options?: msRest.RequestOptionsBase): Promise<Models.JobsCreateImportExportJobResponse>;
    /**
     * @param jobProperties The job specifications.
     * @param callback The callback
     */
    createImportExportJob(jobProperties: Models.JobProperties, callback: msRest.ServiceCallback<Models.JobProperties>): void;
    /**
     * @param jobProperties The job specifications.
     * @param options The optional parameters
     * @param callback The callback
     */
    createImportExportJob(jobProperties: Models.JobProperties, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties>): void;
    /**
     * Gets the status of all import and export jobs in the IoT Hub. See
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
     * for more information.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsGetImportExportJobsResponse>
     */
    getImportExportJobs(options?: msRest.RequestOptionsBase): Promise<Models.JobsGetImportExportJobsResponse>;
    /**
     * @param callback The callback
     */
    getImportExportJobs(callback: msRest.ServiceCallback<Models.JobProperties[]>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    getImportExportJobs(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties[]>): void;
    /**
     * Gets the status of an import or export job in the IoT Hub. See
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-identity-registry#import-and-export-device-identities
     * for more information.
     * @param id The unique identifier of the job.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsGetImportExportJobResponse>
     */
    getImportExportJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsGetImportExportJobResponse>;
    /**
     * @param id The unique identifier of the job.
     * @param callback The callback
     */
    getImportExportJob(id: string, callback: msRest.ServiceCallback<Models.JobProperties>): void;
    /**
     * @param id The unique identifier of the job.
     * @param options The optional parameters
     * @param callback The callback
     */
    getImportExportJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobProperties>): void;
    /**
     * Cancels an import or export job in the IoT Hub.
     * @param id The unique identifier of the job.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsCancelImportExportJobResponse>
     */
    cancelImportExportJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsCancelImportExportJobResponse>;
    /**
     * @param id The unique identifier of the job.
     * @param callback The callback
     */
    cancelImportExportJob(id: string, callback: msRest.ServiceCallback<any>): void;
    /**
     * @param id The unique identifier of the job.
     * @param options The optional parameters
     * @param callback The callback
     */
    cancelImportExportJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<any>): void;
    /**
     * Gets details of a scheduled job from the IoT Hub. See
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
     * @param id The unique identifier of the job.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsGetScheduledJobResponse>
     */
    getScheduledJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsGetScheduledJobResponse>;
    /**
     * @param id The unique identifier of the job.
     * @param callback The callback
     */
    getScheduledJob(id: string, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * @param id The unique identifier of the job.
     * @param options The optional parameters
     * @param callback The callback
     */
    getScheduledJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * Creates a new job to schedule twin updates or direct methods on the IoT Hub at a scheduled time.
     * See https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
     * @param id The unique identifier of the job.
     * @param jobRequest The job request info.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsCreateScheduledJobResponse>
     */
    createScheduledJob(id: string, jobRequest: Models.JobRequest, options?: msRest.RequestOptionsBase): Promise<Models.JobsCreateScheduledJobResponse>;
    /**
     * @param id The unique identifier of the job.
     * @param jobRequest The job request info.
     * @param callback The callback
     */
    createScheduledJob(id: string, jobRequest: Models.JobRequest, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * @param id The unique identifier of the job.
     * @param jobRequest The job request info.
     * @param options The optional parameters
     * @param callback The callback
     */
    createScheduledJob(id: string, jobRequest: Models.JobRequest, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * Cancels a scheduled job on the IoT Hub. See
     * https://docs.microsoft.com/en-us/azure/iot-hub/iot-hub-devguide-jobs for more information.
     * @param id The unique identifier of the job.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsCancelScheduledJobResponse>
     */
    cancelScheduledJob(id: string, options?: msRest.RequestOptionsBase): Promise<Models.JobsCancelScheduledJobResponse>;
    /**
     * @param id The unique identifier of the job.
     * @param callback The callback
     */
    cancelScheduledJob(id: string, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * @param id The unique identifier of the job.
     * @param options The optional parameters
     * @param callback The callback
     */
    cancelScheduledJob(id: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.JobResponse>): void;
    /**
     * Gets the information about jobs using an IoT Hub query. See
     * https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language for more information.
     * @param [options] The optional parameters
     * @returns Promise<Models.JobsQueryScheduledJobsResponse>
     */
    queryScheduledJobs(options?: Models.JobsQueryScheduledJobsOptionalParams): Promise<Models.JobsQueryScheduledJobsResponse>;
    /**
     * @param callback The callback
     */
    queryScheduledJobs(callback: msRest.ServiceCallback<Models.QueryResult>): void;
    /**
     * @param options The optional parameters
     * @param callback The callback
     */
    queryScheduledJobs(options: Models.JobsQueryScheduledJobsOptionalParams, callback: msRest.ServiceCallback<Models.QueryResult>): void;
}
