"use strict";
/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Statistics = void 0;
const msRest = require("@azure/ms-rest-js");
const Mappers = require("../models/statisticsMappers");
const Parameters = require("../models/parameters");
/** Class representing a Statistics. */
class Statistics {
    /**
     * Create a Statistics.
     * @param {IotHubGatewayServiceAPIsContext} client Reference to the service client.
     */
    constructor(client) {
        this.client = client;
    }
    getDeviceStatistics(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, getDeviceStatisticsOperationSpec, callback);
    }
    getServiceStatistics(options, callback) {
        return this.client.sendOperationRequest({
            options
        }, getServiceStatisticsOperationSpec, callback);
    }
}
exports.Statistics = Statistics;
// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getDeviceStatisticsOperationSpec = {
    httpMethod: "GET",
    path: "statistics/devices",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.RegistryStatistics
        },
        default: {}
    },
    serializer
};
const getServiceStatisticsOperationSpec = {
    httpMethod: "GET",
    path: "statistics/service",
    queryParameters: [
        Parameters.apiVersion
    ],
    responses: {
        200: {
            bodyMapper: Mappers.ServiceStatistics
        },
        default: {}
    },
    serializer
};
//# sourceMappingURL=statistics.js.map