/// <reference types="node" />
import Servient, { ProtocolServer, ExposedThing } from "@node-wot/core";
import { Socket } from "dgram";
export default class CoapServer implements ProtocolServer {
    readonly scheme: string;
    private readonly PROPERTY_DIR;
    private readonly ACTION_DIR;
    private readonly EVENT_DIR;
    private readonly port;
    private readonly address?;
    private readonly server;
    private readonly things;
    constructor(port?: number, address?: string);
    start(servient: Servient): Promise<void>;
    stop(): Promise<void>;
    getSocket(): Socket;
    getPort(): number;
    expose(thing: ExposedThing, tdTemplate?: WoT.ExposedThingInit): Promise<void>;
    destroy(thingId: string): Promise<boolean>;
    private handleRequest;
    private isEmpty;
}
