"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
class FileClient {
    constructor() {
        this.setSecurity = (metadata) => false;
    }
    toString() {
        return "[FileClient]";
    }
    readResource(form) {
        return new Promise((resolve, reject) => {
            const filepath = form.href.split("//");
            const resource = fs.createReadStream(filepath[1]);
            const extension = path.extname(filepath[1]);
            console.debug("[binding-file]", `FileClient found '${extension}' extension`);
            let contentType;
            if (form.contentType) {
                contentType = form.contentType;
            }
            else {
                contentType = "application/octet-stream";
                switch (extension) {
                    case ".txt":
                    case ".log":
                    case ".ini":
                    case ".cfg":
                        contentType = "text/plain";
                        break;
                    case ".json":
                        contentType = "application/json";
                        break;
                    case ".jsonld":
                        contentType = "application/ld+json";
                        break;
                    default:
                        console.warn("[binding-file]", `FileClient cannot determine media type of '${form.href}'`);
                }
            }
            resolve({ type: contentType, body: resource });
        });
    }
    writeResource(form, content) {
        return new Promise((resolve, reject) => {
            reject(new Error(`FileClient does not implement write`));
        });
    }
    invokeResource(form, content) {
        return new Promise((resolve, reject) => {
            reject(new Error(`FileClient does not implement invoke`));
        });
    }
    unlinkResource(form) {
        return new Promise((resolve, reject) => {
            reject(new Error(`FileClient does not implement unlink`));
        });
    }
    subscribeResource(form, next, error, complete) {
        error(new Error(`FileClient does not implement subscribe`));
        return null;
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
}
exports.default = FileClient;
//# sourceMappingURL=file-client.js.map