import { Subscription } from "rxjs/Subscription";
import * as TD from "@node-wot/td-tools";
import { ProtocolClient, Content } from "@node-wot/core";
import { HttpForm, HttpConfig } from "./http";
import OAuthManager from "./oauth-manager";
export default class HttpClient implements ProtocolClient {
    private readonly agent;
    private readonly provider;
    private proxyRequest;
    private allowSelfSigned;
    private oauth;
    private credential;
    private activeSubscriptions;
    constructor(config?: HttpConfig, secure?: boolean, oauthManager?: OAuthManager);
    toString(): string;
    readResource(form: HttpForm): Promise<Content>;
    writeResource(form: HttpForm, content: Content): Promise<void>;
    subscribeResource(form: HttpForm, next: (value: Content) => void, error?: (error: Error) => void, complete?: () => void): Promise<Subscription>;
    invokeResource(form: HttpForm, content?: Content): Promise<Content>;
    unlinkResource(form: HttpForm): Promise<void>;
    start(): Promise<void>;
    stop(): Promise<void>;
    setSecurity(metadata: Array<TD.SecurityScheme>, credentials?: unknown): boolean;
    private generateFetchRequest;
    private fetch;
    private checkFetchResponse;
    private static isOAuthTokenExpired;
    private static fixLocalhostName;
}
