"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointValidator = exports.Validator = void 0;
const node_fetch_1 = __importStar(require("node-fetch"));
const credential_1 = require("./credential");
const http = __importStar(require("http"));
const https_1 = require("https");
class Validator {
}
exports.Validator = Validator;
function extractTokenFromRequest(request) {
    const headerToken = request.headers.authorization;
    const url = new URL(request.url, `http://${request.headers.host}`);
    const queryToken = url.searchParams.get("access_token");
    if (!headerToken && !queryToken) {
        throw new Error("Invalid request: only one authentication method is allowed");
    }
    if (queryToken) {
        return queryToken;
    }
    const matches = headerToken.match(/Bearer\s(\S+)/);
    if (!matches) {
        throw new Error("Invalid request: malformed authorization header");
    }
    return matches[1];
}
class EndpointValidator extends Validator {
    constructor(config) {
        super();
        this.config = config;
        const endpoint = config.endpoint;
        this.agent = endpoint.startsWith("https")
            ? new https_1.Agent({
                rejectUnauthorized: !config.allowSelfSigned,
            })
            : new http.Agent();
    }
    validate(tokenRequest, scopes, clients) {
        var _a;
        return __awaiter(this, void 0, void 0, function* () {
            const token = extractTokenFromRequest(tokenRequest);
            const request = new node_fetch_1.Request(this.config.endpoint, {
                method: "POST",
                body: `token=${token}`,
                headers: {
                    "content-type": "application/x-www-form-urlencoded",
                },
                agent: this.agent,
            });
            if (this.config.credentials) {
                yield new credential_1.BasicCredential(this.config.credentials).sign(request);
            }
            const response = yield (0, node_fetch_1.default)(request);
            if (response.status !== 200) {
                throw new Error("Introspection endpoint error: " + response.statusText);
            }
            let contentType = response.headers.get("content-type");
            contentType = (_a = response.headers.get("content-type")) === null || _a === void 0 ? void 0 : _a.split(";")[0];
            if (contentType !== "application/json") {
                throw new Error("Introspection response is not a json file. Content-Type: " + response.headers.get("content-type"));
            }
            const validationResult = (yield response.json());
            if (validationResult.active === undefined) {
                throw new Error("Malformed token introspection response: active is undefined");
            }
            if (!validationResult.active) {
                return false;
            }
            if (validationResult.scope) {
                const tokenScopes = validationResult.scope.split(" ");
                const validScope = tokenScopes.some((tokenScope) => {
                    return scopes.some((thingScope) => tokenScope === thingScope);
                });
                if (!validScope)
                    return false;
            }
            if (validationResult.client_id && !validationResult.client_id.match(clients)) {
                return false;
            }
            return true;
        });
    }
}
exports.EndpointValidator = EndpointValidator;
function default_1(method) {
    if (!method || !(method === null || method === void 0 ? void 0 : method.name)) {
        throw new Error("Undefined oauth token validation method");
    }
    switch (method.name) {
        case "introspection_endpoint":
            return new EndpointValidator(method);
        default:
            throw new Error("Unsupported oauth token validation method " + method.name);
    }
}
exports.default = default_1;
//# sourceMappingURL=oauth-token-validation.js.map