/// <reference types="node" />
import ModbusRTU from "modbus-serial";
import { ReadCoilResult, ReadRegisterResult } from "modbus-serial/ModbusRTU";
import { ModbusEntity, ModbusFunction, ModbusForm, ModbusEndianness } from "./modbus";
import { Content } from "@node-wot/core";
declare class ModbusTransaction {
    connection: ModbusConnection;
    unitId: number;
    registerType: ModbusEntity;
    function: ModbusFunction;
    base: number;
    quantity: number;
    content?: Buffer;
    operations: Array<PropertyOperation>;
    endianness: ModbusEndianness;
    constructor(connection: ModbusConnection, unitId: number, registerType: ModbusEntity, func: ModbusFunction, base: number, quantity: number, endianness: ModbusEndianness, content?: Buffer);
    inform(op: PropertyOperation): void;
    trigger(): void;
    execute(): Promise<void>;
}
export declare class ModbusConnection {
    host: string;
    port: number;
    client: ModbusRTU;
    connecting: boolean;
    connected: boolean;
    timer: NodeJS.Timer;
    currentTransaction: ModbusTransaction;
    queue: Array<ModbusTransaction>;
    config: {
        connectionTimeout?: number;
        operationTimeout?: number;
        connectionRetryTime?: number;
        maxRetries?: number;
    };
    constructor(host: string, port: number, config?: {
        connectionTimeout?: number;
        operationTimeout?: number;
        connectionRetryTime?: number;
        maxRetries?: number;
    });
    enqueue(op: PropertyOperation): void;
    connect(): Promise<void>;
    trigger(): Promise<void>;
    close(): void;
    readModbus(transaction: ModbusTransaction): Promise<ReadCoilResult | ReadRegisterResult>;
    writeModbus(transaction: ModbusTransaction): Promise<void>;
    private contentConversion;
    private modbusstop;
}
export declare class PropertyOperation {
    unitId: number;
    registerType: ModbusEntity;
    base: number;
    quantity: number;
    function: ModbusFunction;
    content?: Buffer;
    endianness: ModbusEndianness;
    transaction: ModbusTransaction;
    resolve: (value?: Content | PromiseLike<Content>) => void;
    reject: (reason?: Error) => void;
    constructor(form: ModbusForm, endianness: ModbusEndianness, content?: Buffer);
    execute(): Promise<Content | PromiseLike<Content>>;
    done(base?: number, buffer?: Buffer): void;
    failed(reason: Error): void;
}
export {};
