"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var mqtt_client_1 = require("./mqtt-client");
var MqttsClientFactory = (function () {
    function MqttsClientFactory(config) {
        var _this = this;
        this.config = config;
        this.scheme = "mqtts";
        this.clients = [];
        this.getClient = function () {
            var client = new mqtt_client_1.default(_this.config, true);
            _this.clients.push(client);
            return client;
        };
    }
    MqttsClientFactory.prototype.init = function () {
        return true;
    };
    MqttsClientFactory.prototype.destroy = function () {
        console.debug("[binding-mqtt]", "MqttClientFactory stopping all clients for '" + this.scheme + "'");
        this.clients.forEach(function (client) { return client.stop(); });
        return true;
    };
    return MqttsClientFactory;
}());
exports.default = MqttsClientFactory;
//# sourceMappingURL=mqtts-client-factory.js.map