import { MqttBrokerServerConfig } from "./mqtt";
import { ProtocolServer, Servient, ExposedThing } from "@node-wot/core";
export default class MqttBrokerServer implements ProtocolServer {
    readonly scheme: string;
    private port;
    private address;
    private brokerURI;
    private readonly things;
    private readonly config;
    private broker;
    private hostedServer;
    private hostedBroker;
    constructor(config: MqttBrokerServerConfig);
    expose(thing: ExposedThing): Promise<void>;
    private exposeProperty;
    private exposeAction;
    private exposeEvent;
    private handleMessage;
    private handleAction;
    private handlePropertyWrite;
    destroy(thingId: string): Promise<boolean>;
    start(servient: Servient): Promise<void>;
    stop(): Promise<void>;
    getPort(): number;
    getAddress(): string;
    private selfHostAuthentication;
}
