"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@node-wot/core");
const mqtt = __importStar(require("mqtt"));
const url = __importStar(require("url"));
const Subscription_1 = require("rxjs/Subscription");
const stream_1 = require("stream");
class MqttClient {
    constructor(config = {}, secure = false) {
        this.config = config;
        this.client = undefined;
        this.scheme = "mqtt" + (secure ? "s" : "");
    }
    subscribeResource(form, next, error, complete) {
        return new Promise((resolve, reject) => {
            const contentType = form.contentType;
            const requestUri = new url.URL(form.href);
            const topic = requestUri.pathname.slice(1);
            const brokerUri = `${this.scheme}://` + requestUri.host;
            if (this.client === undefined) {
                this.client = mqtt.connect(brokerUri, this.config);
            }
            this.client.on("connect", () => {
                this.client.subscribe(topic);
                resolve(new Subscription_1.Subscription(() => {
                    this.client.unsubscribe(topic);
                }));
            });
            this.client.on("message", (receivedTopic, payload, packet) => {
                console.debug("[binding-mqtt]", "Received MQTT message (topic, data): (" + receivedTopic + ", " + payload + ")");
                if (receivedTopic === topic) {
                    next({ type: contentType, body: stream_1.Readable.from(payload) });
                }
            });
            this.client.on("error", (err) => {
                if (this.client) {
                    this.client.end();
                }
                this.client = undefined;
                if (error)
                    error(err);
                reject(err);
            });
        });
    }
    readResource(form) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error("Method not implemented.");
        });
    }
    writeResource(form, content) {
        return __awaiter(this, void 0, void 0, function* () {
            throw new Error("Method not implemented.");
        });
    }
    invokeResource(form, content) {
        return __awaiter(this, void 0, void 0, function* () {
            const requestUri = new url.URL(form.href);
            const topic = requestUri.pathname.slice(1);
            const brokerUri = `${this.scheme}://${requestUri.host}`;
            if (this.client === undefined) {
                this.client = mqtt.connect(brokerUri, this.config);
            }
            if (content === undefined) {
                this.client.publish(topic, JSON.stringify(Buffer.from("")));
            }
            else {
                const buffer = yield core_1.ProtocolHelpers.readStreamFully(content.body);
                this.client.publish(topic, buffer);
            }
            return { type: core_1.ContentSerdes.DEFAULT, body: stream_1.Readable.from([]) };
        });
    }
    unlinkResource(form) {
        return __awaiter(this, void 0, void 0, function* () {
            const requestUri = new url.URL(form.href);
            const topic = requestUri.pathname.slice(1);
            return new Promise((resolve, reject) => {
                if (this.client && this.client.connected) {
                    this.client.unsubscribe(topic);
                    console.debug("[binding-mqtt]", `MqttClient unsubscribed from topic '${topic}'`);
                }
                resolve();
            });
        });
    }
    start() {
        return __awaiter(this, void 0, void 0, function* () {
        });
    }
    stop() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.client)
                this.client.end();
        });
    }
    setSecurity(metadata, credentials) {
        if (metadata === undefined || !Array.isArray(metadata) || metadata.length === 0) {
            console.warn("[binding-mqtt]", `MqttClient received empty security metadata`);
            return false;
        }
        const security = metadata[0];
        if (security.scheme === "basic") {
            this.config.username = credentials.username;
            this.config.password = credentials.password;
        }
        return true;
    }
    mapQoS(qos) {
        switch (qos) {
            case 2:
                return (qos = 2);
            case 1:
                return (qos = 1);
            case 0:
            default:
                return (qos = 0);
        }
    }
    logError(message) {
        console.error("[binding-mqtt]", `[MqttClient]${message}`);
    }
}
exports.default = MqttClient;
//# sourceMappingURL=mqtt-client.js.map