package tunnelstore

import (
	"net/url"
	"strconv"
	"time"

	"github.com/google/uuid"
)

const (
	TimeLayout = time.RFC3339
)

type Filter struct {
	queryParams url.Values
}

func NewFilter() *Filter {
	return &Filter{
		queryParams: url.Values{},
	}
}

func (f *Filter) ByName(name string) {
	f.queryParams.Set("name", name)
}

func (f *Filter) ByNamePrefix(namePrefix string) {
	f.queryParams.Set("name_prefix", namePrefix)
}

func (f *Filter) ExcludeNameWithPrefix(excludePrefix string) {
	f.queryParams.Set("exclude_prefix", excludePrefix)
}

func (f *Filter) NoDeleted() {
	f.queryParams.Set("is_deleted", "false")
}

func (f *Filter) ByExistedAt(existedAt time.Time) {
	f.queryParams.Set("existed_at", existedAt.Format(TimeLayout))
}

func (f *Filter) ByTunnelID(tunnelID uuid.UUID) {
	f.queryParams.Set("uuid", tunnelID.String())
}

func (f *Filter) MaxFetchSize(max uint) {
	f.queryParams.Set("per_page", strconv.Itoa(int(max)))
}

func (f Filter) encode() string {
	return f.queryParams.Encode()
}
