"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var TextCodec = (function () {
    function TextCodec(subMediaType) {
        if (!subMediaType) {
            this.subMediaType = 'text/plain';
        }
        else {
            this.subMediaType = subMediaType;
        }
    }
    TextCodec.prototype.getMediaType = function () {
        return this.subMediaType;
    };
    TextCodec.prototype.bytesToValue = function (bytes, schema, parameters) {
        var parsed;
        parsed = bytes.toString(parameters.charset);
        return parsed;
    };
    TextCodec.prototype.valueToBytes = function (value, schema, parameters) {
        var body = "";
        if (value !== undefined) {
            body = value;
        }
        var be = undefined;
        if (parameters && parameters.charset) {
            switch (parameters.charset) {
                case "ascii":
                    be = "ascii";
                    break;
                case "utf8":
                    be = "utf8";
                    break;
                case "utf-8":
                    be = "utf-8";
                    break;
                case "utf16le":
                    be = "utf16le";
                    break;
                case "ucs2":
                    be = "ucs2";
                    break;
                case "ucs-2":
                    be = "ucs-2";
                    break;
                case "base64":
                    be = "base64";
                    break;
                case "latin1":
                    be = "latin1";
                    break;
                case "binary":
                    be = "binary";
                    break;
                case "hex":
                    be = "hex";
                    break;
            }
        }
        if (be) {
            return Buffer.from(body, be);
        }
        else {
            return Buffer.from(body);
        }
    };
    return TextCodec;
}());
exports.default = TextCodec;
//# sourceMappingURL=text-codec.js.map