"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var NetconfCodec = (function () {
    function NetconfCodec() {
    }
    NetconfCodec.prototype.getMediaType = function () {
        return 'application/netconf';
    };
    NetconfCodec.prototype.bytesToValue = function (bytes, schema, parameters) {
        var parsed;
        try {
            parsed = JSON.parse(bytes.toString());
        }
        catch (err) {
            if (err instanceof SyntaxError) {
                if (bytes.byteLength == 0) {
                    parsed = undefined;
                }
                else {
                    parsed = bytes.toString();
                }
            }
            else {
                throw err;
            }
        }
        if (parsed && parsed.value !== undefined) {
            console.warn("[core/netconf-codec]", "NetconfCodec removing { value: ... } wrapper");
            parsed = parsed.value;
        }
        return parsed;
    };
    NetconfCodec.prototype.valueToBytes = function (value, schema, parameters) {
        var body = "";
        if (value !== undefined) {
            var NSs = {};
            var tmp_obj = this.getPayloadNamespaces(schema, value, NSs, false);
            body = JSON.stringify(tmp_obj);
        }
        return Buffer.from(body);
    };
    NetconfCodec.prototype.getPayloadNamespaces = function (schema, payload, NSs, hasNamespace) {
        if (hasNamespace) {
            var properties = schema.properties;
            if (!properties) {
                throw new Error("Missing \"properties\" field in TD");
            }
            var ns_found = false;
            var alias_ns = '';
            var value = void 0;
            for (var key in properties) {
                var el = properties[key];
                if (!(payload[key])) {
                    throw new Error("Payload is missing '" + key + "' field specified in TD");
                }
                if (el["nc:attribute"] === true && payload[key]) {
                    var ns = payload[key];
                    alias_ns = ns.split(':')[ns.split(':').length - 1];
                    NSs[alias_ns] = payload[key];
                    ns_found = true;
                }
                else if (payload[key]) {
                    value = payload[key];
                }
            }
            if (!ns_found) {
                throw new Error("Namespace not found in the payload");
            }
            else {
                payload = alias_ns + '\\' + ':' + value;
            }
            return { payload: payload, NSs: NSs };
        }
        if (schema && schema.type && schema.type === 'object' && schema.properties) {
            var tmp_hasNamespace = false;
            var tmp_obj = void 0;
            if (schema.properties && schema["nc:container"]) {
                tmp_obj = this.getPayloadNamespaces(schema, payload, NSs, true);
            }
            else {
                tmp_obj = this.getPayloadNamespaces(schema.properties, payload, NSs, false);
            }
            payload = tmp_obj.payload;
            NSs = __assign(__assign({}, NSs), tmp_obj.NSs);
        }
        for (var key in schema) {
            if ((schema[key].type && schema[key].type === 'object') || hasNamespace) {
                var tmp_hasNamespace = false;
                if (schema[key].properties && schema[key]["nc:container"]) {
                    tmp_hasNamespace = true;
                }
                var tmp_obj = this.getPayloadNamespaces(schema[key], payload[key], NSs, tmp_hasNamespace);
                payload[key] = tmp_obj.payload;
                NSs = __assign(__assign({}, NSs), tmp_obj.NSs);
            }
        }
        return { payload: payload, NSs: NSs };
    };
    return NetconfCodec;
}());
exports.default = NetconfCodec;
//# sourceMappingURL=netconf-codec.js.map