"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class TextCodec {
    constructor(subMediaType) {
        if (!subMediaType) {
            this.subMediaType = "text/plain";
        }
        else {
            this.subMediaType = subMediaType;
        }
    }
    getMediaType() {
        return this.subMediaType;
    }
    bytesToValue(bytes, schema, parameters) {
        const parsed = bytes.toString(parameters.charset);
        return parsed;
    }
    valueToBytes(value, schema, parameters) {
        let body = "";
        if (value !== undefined) {
            body = value.toString();
        }
        let be;
        if (parameters && parameters.charset) {
            switch (parameters.charset) {
                case "ascii":
                    be = "ascii";
                    break;
                case "utf8":
                    be = "utf8";
                    break;
                case "utf-8":
                    be = "utf-8";
                    break;
                case "utf16le":
                    be = "utf16le";
                    break;
                case "ucs2":
                    be = "ucs2";
                    break;
                case "ucs-2":
                    be = "ucs-2";
                    break;
                case "base64":
                    be = "base64";
                    break;
                case "latin1":
                    be = "latin1";
                    break;
                case "binary":
                    be = "binary";
                    break;
                case "hex":
                    be = "hex";
                    break;
            }
        }
        if (be) {
            return Buffer.from(body, be);
        }
        else {
            return Buffer.from(body);
        }
    }
}
exports.default = TextCodec;
//# sourceMappingURL=text-codec.js.map