import * as WoT from "wot-typescript-definitions";
import * as TD from "@node-wot/td-tools";
import Servient from "./servient";
import { InteractionOutput } from "./interaction-output";
import { Content, PropertyContentMap } from "./core";
import { ActionHandlerMap, ContentListener, EventHandlerMap, ListenerMap, PropertyHandlerMap } from "./protocol-interfaces";
export default class ExposedThing extends TD.Thing implements WoT.ExposedThing {
    security: Array<string>;
    securityDefinitions: {
        [key: string]: TD.SecurityType;
    };
    id: string;
    title: string;
    base: string;
    forms: Array<TD.Form>;
    properties: {
        [key: string]: TD.ThingProperty;
    };
    actions: {
        [key: string]: TD.ThingAction;
    };
    events: {
        [key: string]: TD.ThingEvent;
    };
    __propertyHandlers: PropertyHandlerMap;
    __actionHandlers: ActionHandlerMap;
    __eventHandlers: EventHandlerMap;
    __propertyListeners: ListenerMap;
    __eventListeners: ListenerMap;
    private getServient;
    private getSubjectTD;
    constructor(servient: Servient, thingModel?: WoT.ExposedThingInit);
    addDefaultLanguage(thing: ExposedThing): void;
    extendInteractions(): void;
    getThingDescription(): WoT.ThingDescription;
    emitEvent(name: string, data: WoT.InteractionInput): void;
    expose(): Promise<void>;
    destroy(): Promise<void>;
    setPropertyReadHandler(propertyName: string, handler: WoT.PropertyReadHandler): WoT.ExposedThing;
    setPropertyWriteHandler(propertyName: string, handler: WoT.PropertyWriteHandler): WoT.ExposedThing;
    setPropertyObserveHandler(name: string, handler: WoT.PropertyReadHandler): WoT.ExposedThing;
    setPropertyUnobserveHandler(name: string, handler: WoT.PropertyReadHandler): WoT.ExposedThing;
    setActionHandler(actionName: string, handler: WoT.ActionHandler): WoT.ExposedThing;
    setEventSubscribeHandler(name: string, handler: WoT.EventSubscriptionHandler): WoT.ExposedThing;
    setEventUnsubscribeHandler(name: string, handler: WoT.EventSubscriptionHandler): WoT.ExposedThing;
    setEventHandler(name: string, handler: WoT.EventListenerHandler): WoT.ExposedThing;
    readProperty(propertyName: string, options?: WoT.InteractionOptions): Promise<InteractionOutput>;
    _readProperties(propertyNames: string[], options?: WoT.InteractionOptions): Promise<WoT.PropertyReadMap>;
    readAllProperties(options?: WoT.InteractionOptions): Promise<WoT.PropertyReadMap>;
    readMultipleProperties(propertyNames: string[], options?: WoT.InteractionOptions): Promise<WoT.PropertyReadMap>;
    writeProperty(propertyName: string, value: WoT.InteractionInput, options?: WoT.InteractionOptions): Promise<void>;
    writeMultipleProperties(valueMap: WoT.PropertyWriteMap, options?: WoT.InteractionOptions): Promise<void>;
    invokeAction(actionName: string, parameter?: WoT.InteractionInput, options?: WoT.InteractionOptions): Promise<InteractionOutput>;
    observeProperty(name: string, listener: WoT.WotListener, options?: WoT.InteractionOptions): Promise<void>;
    unobserveProperty(name: string): Promise<void>;
    subscribeEvent(name: string, listener: WoT.WotListener, options?: WoT.InteractionOptions): Promise<void>;
    unsubscribeEvent(name: string): Promise<void>;
    handleInvokeAction(name: string, inputContent: Content, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<Content | void>;
    handleReadProperty(propertyName: string, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<Content>;
    _handleReadProperties(propertyNames: string[], options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<PropertyContentMap>;
    handleReadAllProperties(options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<PropertyContentMap>;
    handleReadMultipleProperties(propertyNames: string[], options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<PropertyContentMap>;
    handleWriteProperty(propertyName: string, inputContent: Content, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<void>;
    handleWriteMultipleProperties(valueMap: PropertyContentMap, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<void>;
    handleSubscribeEvent(name: string, listener: ContentListener, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<void>;
    handleUnsubscribeEvent(name: string, listener: ContentListener, options: WoT.InteractionOptions & {
        formIndex: number;
    }): void;
    handleObserveProperty(name: string, listener: ContentListener, options: WoT.InteractionOptions & {
        formIndex: number;
    }): Promise<void>;
    handleUnobserveProperty(name: string, listener: ContentListener, options: WoT.InteractionOptions & {
        formIndex: number;
    }): void;
    private static interactionInputToReadable;
}
