import Servient from "./servient";
import * as TD from "@node-wot/td-tools";
import { ValidateFunction } from "ajv";
import { DataSchemaValue, ExposedThingInit } from "wot-typescript-definitions";
import { SomeJSONSchema } from "ajv/dist/types/json-schema";
import { ThingInteraction } from "@node-wot/td-tools";
import { Resolver } from "@node-wot/td-tools/src/resolver-interface";
export default class Helpers implements Resolver {
    static tsSchemaValidator: ValidateFunction<unknown>;
    private srv;
    constructor(srv: Servient);
    private static staticAddress;
    static extractScheme(uri: string): string;
    static setStaticAddress(address: string): void;
    static getAddresses(): Array<string>;
    static toUriLiteral(address: string): string;
    static generateUniqueName(name: string): string;
    fetch(uri: string): Promise<unknown>;
    static extend<T, U>(first: T, second: U): T & U;
    static parseInteractionOutput(response: WoT.InteractionOutput): Promise<DataSchemaValue>;
    static createExposeThingInitSchema(tdSchema: unknown): SomeJSONSchema;
    static validateExposedThingInit(data: ExposedThingInit): {
        valid: boolean;
        errors: string;
    };
    static parseInteractionOptions(thing: TD.Thing, ti: ThingInteraction, options?: WoT.InteractionOptions): WoT.InteractionOptions;
    static validateInteractionOptions(thing: TD.Thing, ti: ThingInteraction, options?: WoT.InteractionOptions): boolean;
    static parseUrlParameters(url: string, globalUriVariables: {
        [key: string]: TD.DataSchema;
    }, uriVariables: {
        [key: string]: TD.DataSchema;
    }): Record<string, unknown>;
}
