// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/actions/sdk/v2/interactionmodel/slot.proto

package interactionmodel

import (
	reflect "reflect"
	sync "sync"

	_type "google.golang.org/genproto/googleapis/actions/sdk/v2/interactionmodel/type"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Configuration for a slot. Slots are single units of data that can be filled
// through natural language (ie. intent parameters), session parameters, and
// other sources.
type Slot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the slot.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Declares the data type of this slot.
	Type *_type.ClassReference `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Indicates whether the slot is required to be filled before
	// advancing. Required slots that are not filled will trigger a customizable
	// prompt to the user.
	Required bool `protobuf:"varint,3,opt,name=required,proto3" json:"required,omitempty"`
	// Optional. Registers Prompts for different stages of slot filling.
	PromptSettings *Slot_PromptSettings `protobuf:"bytes,4,opt,name=prompt_settings,json=promptSettings,proto3" json:"prompt_settings,omitempty"`
	// Optional. Commit behavior associated with the slot.
	CommitBehavior *Slot_CommitBehavior `protobuf:"bytes,5,opt,name=commit_behavior,json=commitBehavior,proto3" json:"commit_behavior,omitempty"`
	// Optional. Additional configuration associated with the slot which is
	// used for filling the slot. The format of the config is specific to the
	// type of the slot. Resource references to user or session parameter can be
	// added to this config. This config is needed for filling slots related to
	// transactions and user engagement.
	//
	// Example:
	//  For a slot of type actions.type.CompletePurchaseValue, the following
	//  config proposes a digital good order with a reference to a client defined
	//  session parameter `userSelectedSkuId`:
	//
	//    {
	//      "@type": "type.googleapis.com/
	//                  google.actions.transactions.v3.CompletePurchaseValueSpec",
	//      "skuId": {
	//        "skuType": "SKU_TYPE_IN_APP",
	//        "id": "$session.params.userSelectedSkuId",
	//        "packageName": "com.example.company"
	//      }
	//    }
	Config *structpb.Value `protobuf:"bytes,6,opt,name=config,proto3" json:"config,omitempty"`
	// Optional. Configuration to populate a default value for this slot.
	DefaultValue *Slot_DefaultValue `protobuf:"bytes,7,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
}

func (x *Slot) Reset() {
	*x = Slot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Slot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Slot) ProtoMessage() {}

func (x *Slot) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Slot.ProtoReflect.Descriptor instead.
func (*Slot) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescGZIP(), []int{0}
}

func (x *Slot) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Slot) GetType() *_type.ClassReference {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Slot) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *Slot) GetPromptSettings() *Slot_PromptSettings {
	if x != nil {
		return x.PromptSettings
	}
	return nil
}

func (x *Slot) GetCommitBehavior() *Slot_CommitBehavior {
	if x != nil {
		return x.CommitBehavior
	}
	return nil
}

func (x *Slot) GetConfig() *structpb.Value {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Slot) GetDefaultValue() *Slot_DefaultValue {
	if x != nil {
		return x.DefaultValue
	}
	return nil
}

// A single place where slot prompts are defined.
type Slot_PromptSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Prompt for the slot value itself. Example: "What size did you want?"
	InitialPrompt *EventHandler `protobuf:"bytes,1,opt,name=initial_prompt,json=initialPrompt,proto3" json:"initial_prompt,omitempty"`
	// Prompt to give when the user's input does not match the expected
	// value type for the slot for the first time. Example: "Sorry, I
	// didn't get that."
	NoMatchPrompt1 *EventHandler `protobuf:"bytes,2,opt,name=no_match_prompt1,json=noMatchPrompt1,proto3" json:"no_match_prompt1,omitempty"`
	// Prompt to give when the user's input does not match the expected
	// value type for the slot for the second time. Example: "Sorry, I
	// didn't get that."
	NoMatchPrompt2 *EventHandler `protobuf:"bytes,3,opt,name=no_match_prompt2,json=noMatchPrompt2,proto3" json:"no_match_prompt2,omitempty"`
	// Prompt to give when the user's input does not match the expected
	// value type for the slot for the last time. Example: "Sorry, I
	// didn't get that."
	NoMatchFinalPrompt *EventHandler `protobuf:"bytes,4,opt,name=no_match_final_prompt,json=noMatchFinalPrompt,proto3" json:"no_match_final_prompt,omitempty"`
	// Prompt to give when the user does not provide an input for the first
	// time. Example: "Sorry, I didn't get that."
	NoInputPrompt1 *EventHandler `protobuf:"bytes,5,opt,name=no_input_prompt1,json=noInputPrompt1,proto3" json:"no_input_prompt1,omitempty"`
	// Prompt to give when the user does not provide an input for the second
	// time. Example: "Sorry, I didn't get that."
	NoInputPrompt2 *EventHandler `protobuf:"bytes,6,opt,name=no_input_prompt2,json=noInputPrompt2,proto3" json:"no_input_prompt2,omitempty"`
	// Prompt to give when the user does not provide an input for the last
	// time. Example: "Sorry, I didn't get that."
	NoInputFinalPrompt *EventHandler `protobuf:"bytes,7,opt,name=no_input_final_prompt,json=noInputFinalPrompt,proto3" json:"no_input_final_prompt,omitempty"`
}

func (x *Slot_PromptSettings) Reset() {
	*x = Slot_PromptSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Slot_PromptSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Slot_PromptSettings) ProtoMessage() {}

func (x *Slot_PromptSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Slot_PromptSettings.ProtoReflect.Descriptor instead.
func (*Slot_PromptSettings) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Slot_PromptSettings) GetInitialPrompt() *EventHandler {
	if x != nil {
		return x.InitialPrompt
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoMatchPrompt1() *EventHandler {
	if x != nil {
		return x.NoMatchPrompt1
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoMatchPrompt2() *EventHandler {
	if x != nil {
		return x.NoMatchPrompt2
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoMatchFinalPrompt() *EventHandler {
	if x != nil {
		return x.NoMatchFinalPrompt
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoInputPrompt1() *EventHandler {
	if x != nil {
		return x.NoInputPrompt1
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoInputPrompt2() *EventHandler {
	if x != nil {
		return x.NoInputPrompt2
	}
	return nil
}

func (x *Slot_PromptSettings) GetNoInputFinalPrompt() *EventHandler {
	if x != nil {
		return x.NoInputFinalPrompt
	}
	return nil
}

// Message describing the commit behavior associated with the slot after it
// has been successfully filled.
type Slot_CommitBehavior struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The session parameter to write the slot value after it is filled. Note
	// that nested paths are not currently supported. "$$" is used to write the
	// slot value to a session parameter with same name as the slot.
	// Eg: write_session_param = "fruit" corresponds to "$session.params.fruit".
	// write_session_param = "ticket" corresponds to "$session.params.ticket".
	WriteSessionParam string `protobuf:"bytes,1,opt,name=write_session_param,json=writeSessionParam,proto3" json:"write_session_param,omitempty"`
}

func (x *Slot_CommitBehavior) Reset() {
	*x = Slot_CommitBehavior{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Slot_CommitBehavior) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Slot_CommitBehavior) ProtoMessage() {}

func (x *Slot_CommitBehavior) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Slot_CommitBehavior.ProtoReflect.Descriptor instead.
func (*Slot_CommitBehavior) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Slot_CommitBehavior) GetWriteSessionParam() string {
	if x != nil {
		return x.WriteSessionParam
	}
	return ""
}

// Configuration to populate a default value for this slot.
type Slot_DefaultValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The session parameter to be used to initialize the slot value, if it has
	// a non-empty value. The type of the value must match the type of the slot.
	// Note that nested paths are not currently supported.
	// Eg: `session_param = "fruit"` corresponds to `$session.params.fruit`.
	// `session_param = "ticket"` corresponds to `$session.params.ticket`.
	SessionParam string `protobuf:"bytes,1,opt,name=session_param,json=sessionParam,proto3" json:"session_param,omitempty"`
	// Optional. Constant default value for the slot. This will only be used if a value
	// for this slot was not populated through the `session_param`. The
	// type for this value must match the type of the slot.
	Constant *structpb.Value `protobuf:"bytes,2,opt,name=constant,proto3" json:"constant,omitempty"`
}

func (x *Slot_DefaultValue) Reset() {
	*x = Slot_DefaultValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Slot_DefaultValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Slot_DefaultValue) ProtoMessage() {}

func (x *Slot_DefaultValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Slot_DefaultValue.ProtoReflect.Descriptor instead.
func (*Slot_DefaultValue) Descriptor() ([]byte, []int) {
	return file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Slot_DefaultValue) GetSessionParam() string {
	if x != nil {
		return x.SessionParam
	}
	return ""
}

func (x *Slot_DefaultValue) GetConstant() *structpb.Value {
	if x != nil {
		return x.Constant
	}
	return nil
}

var File_google_actions_sdk_v2_interactionmodel_slot_proto protoreflect.FileDescriptor

var file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDesc = []byte{
	0x0a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f, 0x73, 0x6c, 0x6f, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x1a, 0x3a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f,
	0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfd, 0x0a, 0x0a, 0x04, 0x53, 0x6c,
	0x6f, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76,
	0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x12, 0x69, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b,
	0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x6c, 0x6f, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x69, 0x0a,
	0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69,
	0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e,
	0x53, 0x6c, 0x6f, 0x74, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74,
	0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x63, 0x0a,
	0x0d, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x53, 0x6c,
	0x6f, 0x74, 0x2e, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x1a, 0xbf, 0x05, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5b, 0x0a, 0x0e, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c,
	0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73,
	0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64,
	0x6c, 0x65, 0x72, 0x52, 0x0d, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x6e, 0x6f, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x31, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x52, 0x0e, 0x6e, 0x6f, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x31, 0x12, 0x5e, 0x0a, 0x10, 0x6e, 0x6f, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x70,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x32, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64,
	0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c,
	0x65, 0x72, 0x52, 0x0e, 0x6e, 0x6f, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x32, 0x12, 0x67, 0x0a, 0x15, 0x6e, 0x6f, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x12, 0x6e, 0x6f, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x46, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x12, 0x5e, 0x0a, 0x10, 0x6e,
	0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x31, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x0e, 0x6e, 0x6f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x31, 0x12, 0x5e, 0x0a, 0x10, 0x6e,
	0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x32, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x52, 0x0e, 0x6e, 0x6f, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x32, 0x12, 0x67, 0x0a, 0x15, 0x6e,
	0x6f, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x73, 0x64, 0x6b, 0x2e,
	0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x48, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72,
	0x52, 0x12, 0x6e, 0x6f, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x50, 0x72,
	0x6f, 0x6d, 0x70, 0x74, 0x1a, 0x40, 0x0a, 0x0e, 0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x42, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x12, 0x2e, 0x0a, 0x13, 0x77, 0x72, 0x69, 0x74, 0x65, 0x5f,
	0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x11, 0x77, 0x72, 0x69, 0x74, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x1a, 0x71, 0x0a, 0x0c, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x12, 0x37, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x42, 0x91, 0x01, 0x0a, 0x2a, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2e, 0x73, 0x64, 0x6b, 0x2e, 0x76, 0x32, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x09, 0x53, 0x6c, 0x6f, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x73, 0x64, 0x6b, 0x2f, 0x76, 0x32, 0x2f, 0x69, 0x6e, 0x74, 0x65,
	0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3b, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescOnce sync.Once
	file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescData = file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDesc
)

func file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescGZIP() []byte {
	file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescOnce.Do(func() {
		file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescData)
	})
	return file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDescData
}

var file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_actions_sdk_v2_interactionmodel_slot_proto_goTypes = []interface{}{
	(*Slot)(nil),                 // 0: google.actions.sdk.v2.interactionmodel.Slot
	(*Slot_PromptSettings)(nil),  // 1: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings
	(*Slot_CommitBehavior)(nil),  // 2: google.actions.sdk.v2.interactionmodel.Slot.CommitBehavior
	(*Slot_DefaultValue)(nil),    // 3: google.actions.sdk.v2.interactionmodel.Slot.DefaultValue
	(*_type.ClassReference)(nil), // 4: google.actions.sdk.v2.interactionmodel.type.ClassReference
	(*structpb.Value)(nil),       // 5: google.protobuf.Value
	(*EventHandler)(nil),         // 6: google.actions.sdk.v2.interactionmodel.EventHandler
}
var file_google_actions_sdk_v2_interactionmodel_slot_proto_depIdxs = []int32{
	4,  // 0: google.actions.sdk.v2.interactionmodel.Slot.type:type_name -> google.actions.sdk.v2.interactionmodel.type.ClassReference
	1,  // 1: google.actions.sdk.v2.interactionmodel.Slot.prompt_settings:type_name -> google.actions.sdk.v2.interactionmodel.Slot.PromptSettings
	2,  // 2: google.actions.sdk.v2.interactionmodel.Slot.commit_behavior:type_name -> google.actions.sdk.v2.interactionmodel.Slot.CommitBehavior
	5,  // 3: google.actions.sdk.v2.interactionmodel.Slot.config:type_name -> google.protobuf.Value
	3,  // 4: google.actions.sdk.v2.interactionmodel.Slot.default_value:type_name -> google.actions.sdk.v2.interactionmodel.Slot.DefaultValue
	6,  // 5: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.initial_prompt:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 6: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_match_prompt1:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 7: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_match_prompt2:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 8: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_match_final_prompt:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 9: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_input_prompt1:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 10: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_input_prompt2:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	6,  // 11: google.actions.sdk.v2.interactionmodel.Slot.PromptSettings.no_input_final_prompt:type_name -> google.actions.sdk.v2.interactionmodel.EventHandler
	5,  // 12: google.actions.sdk.v2.interactionmodel.Slot.DefaultValue.constant:type_name -> google.protobuf.Value
	13, // [13:13] is the sub-list for method output_type
	13, // [13:13] is the sub-list for method input_type
	13, // [13:13] is the sub-list for extension type_name
	13, // [13:13] is the sub-list for extension extendee
	0,  // [0:13] is the sub-list for field type_name
}

func init() { file_google_actions_sdk_v2_interactionmodel_slot_proto_init() }
func file_google_actions_sdk_v2_interactionmodel_slot_proto_init() {
	if File_google_actions_sdk_v2_interactionmodel_slot_proto != nil {
		return
	}
	file_google_actions_sdk_v2_interactionmodel_event_handler_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Slot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Slot_PromptSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Slot_CommitBehavior); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Slot_DefaultValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_actions_sdk_v2_interactionmodel_slot_proto_goTypes,
		DependencyIndexes: file_google_actions_sdk_v2_interactionmodel_slot_proto_depIdxs,
		MessageInfos:      file_google_actions_sdk_v2_interactionmodel_slot_proto_msgTypes,
	}.Build()
	File_google_actions_sdk_v2_interactionmodel_slot_proto = out.File
	file_google_actions_sdk_v2_interactionmodel_slot_proto_rawDesc = nil
	file_google_actions_sdk_v2_interactionmodel_slot_proto_goTypes = nil
	file_google_actions_sdk_v2_interactionmodel_slot_proto_depIdxs = nil
}
