# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2017-01-23 12:10
from __future__ import unicode_literals

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Entry',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(db_index=True, max_length=64, validators=[django.core.validators.RegexValidator(message='Not a sha256 value.', regex='[a-fA-F0-9]{64}')])),
                ('content', models.BinaryField()),
            ],
        ),
        migrations.CreateModel(
            name='Journal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('uid', models.CharField(db_index=True, max_length=64, validators=[django.core.validators.RegexValidator(message='Not a sha256 value.', regex='[a-fA-F0-9]{64}')])),
                ('content', models.BinaryField()),
                ('deleted', models.BooleanField(default=False)),
                ('owner', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='entry',
            name='journal',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='journal.Journal'),
        ),
        migrations.AlterUniqueTogether(
            name='journal',
            unique_together=set([('uid', 'owner')]),
        ),
        migrations.AlterUniqueTogether(
            name='entry',
            unique_together=set([('uid', 'journal')]),
        ),
    ]
