#ifndef _DRV_VMMC_AUDIO_H
#define _DRV_VMMC_AUDIO_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

******************************************************************************/

/**
   \file drv_vmmc_audio.h
   This file contains the declaration of the functions for the audio module.
*/

#include "drv_tapi_ll_interface.h"
#include "lib_bbd.h"


#if (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO)
/** IP Phone Defines for operation modes */
#define BBD_VMMC_AUDIO_OPMODE_DEFAULT_SIZE     540  /* 460  */

#define BBD_VMMC_IPPHONE_IDLE                  0x2000

#define BBD_VMMC_IPPHONE_HANDS_VOL1            0x2001
#define BBD_VMMC_IPPHONE_HANDS_VOL2            0x2002
#define BBD_VMMC_IPPHONE_HANDS_VOL3            0x2003
#define BBD_VMMC_IPPHONE_HANDS_VOL4            0x2004
#define BBD_VMMC_IPPHONE_HANDS_VOL5            0x2005
#define BBD_VMMC_IPPHONE_HANDS_VOL6            0x2006
#define BBD_VMMC_IPPHONE_HANDS_VOL7            0x2007
#define BBD_VMMC_IPPHONE_HANDS_VOL8            0x2008

#define BBD_VMMC_IPPHONE_HEADS_VOL1            0x2011
#define BBD_VMMC_IPPHONE_HEADS_VOL2            0x2012
#define BBD_VMMC_IPPHONE_HEADS_VOL3            0x2013
#define BBD_VMMC_IPPHONE_HEADS_VOL4            0x2014
#define BBD_VMMC_IPPHONE_HEADS_VOL5            0x2015
#define BBD_VMMC_IPPHONE_HEADS_VOL6            0x2016
#define BBD_VMMC_IPPHONE_HEADS_VOL7            0x2017
#define BBD_VMMC_IPPHONE_HEADS_VOL8            0x2018

#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL1   0x2021
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL2   0x2022
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL3   0x2023
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL4   0x2024
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL5   0x2025
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL6   0x2026
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL7   0x2027
#define BBD_VMMC_IPPHONE_HANDSF_MUFFLED_VOL8   0x2028

#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL1    0x2031
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL2    0x2032
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL3    0x2033
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL4    0x2034
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL5    0x2035
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL6    0x2036
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL7    0x2037
#define BBD_VMMC_IPPHONE_HANDSF_NORMAL_VOL8    0x2038

#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL1    0x2041
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL2    0x2042
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL3    0x2043
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL4    0x2044
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL5    0x2045
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL6    0x2046
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL7    0x2047
#define BBD_VMMC_IPPHONE_HANDSF_ECHOIC_VOL8    0x2048

#define BBD_VMMC_IPPHONE_HANDS_OL_VOL1         0x2051
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL2         0x2052
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL3         0x2053
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL4         0x2054
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL5         0x2055
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL6         0x2056
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL7         0x2057
#define BBD_VMMC_IPPHONE_HANDS_OL_VOL8         0x2058

#define BBD_VMMC_IPPHONE_HEADS_OL_VOL1         0x2061
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL2         0x2062
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL3         0x2063
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL4         0x2064
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL5         0x2065
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL6         0x2066
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL7         0x2067
#define BBD_VMMC_IPPHONE_HEADS_OL_VOL8         0x2068

#define BBD_VMMC_IPPHONE_HANDS_WB_VOL1         0x2101
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL2         0x2102
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL3         0x2103
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL4         0x2104
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL5         0x2105
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL6         0x2106
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL7         0x2107
#define BBD_VMMC_IPPHONE_HANDS_WB_VOL8         0x2108

#define BBD_VMMC_IPPHONE_HEADS_WB_VOL1          0x2111
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL2          0x2112
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL3          0x2113
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL4          0x2114
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL5          0x2115
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL6          0x2116
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL7          0x2117
#define BBD_VMMC_IPPHONE_HEADS_WB_VOL8          0x2118

#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL1 0x2121
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL2 0x2122
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL3 0x2123
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL4 0x2124
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL5 0x2125
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL6 0x2126
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL7 0x2127
#define BBD_VMMC_IPPHONE_HANDSF_WB_MUFFLED_VOL8 0x2128

#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL1  0x2131
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL2  0x2132
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL3  0x2133
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL4  0x2134
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL5  0x2135
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL6  0x2136
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL7  0x2137
#define BBD_VMMC_IPPHONE_HANDSF_WB_NORMAL_VOL8  0x2138

#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL1  0x2141
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL2  0x2142
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL3  0x2143
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL4  0x2144
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL5  0x2145
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL6  0x2146
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL7  0x2147
#define BBD_VMMC_IPPHONE_HANDSF_WB_ECHOIC_VOL8  0x2148

#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL1       0x2151
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL2       0x2152
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL3       0x2153
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL4       0x2154
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL5       0x2155
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL6       0x2156
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL7       0x2157
#define BBD_VMMC_IPPHONE_HANDS_OL_WB_VOL8       0x2158

#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL1       0x2161
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL2       0x2162
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL3       0x2163
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL4       0x2164
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL5       0x2165
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL6       0x2166
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL7       0x2167
#define BBD_VMMC_IPPHONE_HEADS_OL_WB_VOL8       0x2168


#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL1        0x2071
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL2        0x2072
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL3        0x2073
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL4        0x2074
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL5        0x2075
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL6        0x2076
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL7        0x2077
#define BBD_VMMC_IPPHONE_HANDS_ICVA_VOL8        0x2078

#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL1     0x2171
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL2     0x2172
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL3     0x2173
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL4     0x2174
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL5     0x2175
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL6     0x2176
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL7     0x2177
#define BBD_VMMC_IPPHONE_HANDS_WB_ICVA_VOL8     0x2178

#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL1        0x2081
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL2        0x2082
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL3        0x2083
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL4        0x2084
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL5        0x2085
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL6        0x2086
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL7        0x2087
#define BBD_VMMC_IPPHONE_HEADS_ICVA_VOL8        0x2088

#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL1     0x2181
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL2     0x2182
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL3     0x2183
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL4     0x2184
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL5     0x2185
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL6     0x2186
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL7     0x2187
#define BBD_VMMC_IPPHONE_HEADS_WB_ICVA_VOL8     0x2188

/* audio ring volume BBD tags */
#define BBD_VMMC_IPPHONE_RINGTONE_VOL1          0x2201
#define BBD_VMMC_IPPHONE_RINGTONE_VOL2          0x2202
#define BBD_VMMC_IPPHONE_RINGTONE_VOL3          0x2203
#define BBD_VMMC_IPPHONE_RINGTONE_VOL4          0x2204
#define BBD_VMMC_IPPHONE_RINGTONE_VOL5          0x2205
#define BBD_VMMC_IPPHONE_RINGTONE_VOL6          0x2206
#define BBD_VMMC_IPPHONE_RINGTONE_VOL7          0x2207
#define BBD_VMMC_IPPHONE_RINGTONE_VOL8          0x2208

#define BBD_VMMC_IPPHONE_MUTE                   0x8000

/* Operation Mode dependent default volumes - to be adapted */
#define VMMC_AUDIO_DEFAULT_VOLUME           3
#define VMMC_AUDIO_DEFAULT_RING_VOLUME      1
#define VMMC_AUDIO_DEFAULT_ICA_VOLUME       5
/*
#define VMMC_HANDSET_MODE_DEFAULT_VOL       4
#define VMMC_HEADSET_MODE_DEFAULT_VOL       4
#define VMMC_HANDSFREE_MODE_DEFAULT_VOL     4
#define VMMC_HANDSET_OPENL_MODE_DEFAULT_VOL 4
#define VMMC_HEADSET_OPENL_MODE_DEFAULT_VOL 4
#define VMMC_HANDSET_WDB_MODE_DEFAULT_VOL   4
#define VMMC_HEADSET_WDB_MODE_DEFAULT_VOL   4
#define VMMC_HANDSFREE_WDB_MODE_DEFAULT_VOL 4
#define VMMC_HANDSET_WDB_OPENL_MODE_DEFAULT_VOL 4
#define VMMC_HEADSET_WDB_OPENL_MODE_DEFAULT_VOL 4
*/
#endif /* (VMMC_CFG_FEATURES & VMMC_FEAT_AUDIO) */


IFX_return_t VMMC_TAPI_LL_Data_Add_Aux(VMMC_CHANNEL *pCh, IFX_uint32_t nThisCh);
IFX_return_t VMMC_TAPI_LL_Pcm_Add_Aux(VMMC_CHANNEL *pCh, IFX_uint32_t nThisCh);
IFX_return_t VMMC_TAPI_LL_Remove_Aux(VMMC_CHANNEL *pCh, IFX_uint32_t nThisCh);
IFX_return_t VMMC_TAPI_LL_AUDIO_Channel_Cfg (VMMC_DEVICE *pDev);
void TAPI_LL_SetDefEqu_IIR_FIRCoef(VMMC_CHANNEL *pCh);
IFX_return_t VMMC_TAPI_LL_AUDIO_Volume_Set (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t level);
IFX_return_t VMMC_TAPI_LL_AUDIO_Mode_Set (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t mode);
IFX_return_t VMMC_TAPI_LL_AUDIO_Room_Set (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t type);
IFX_return_t VMMC_TAPI_LL_AUDIO_Mute_Set (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t oprn);
IFX_return_t VMMC_TAPI_LL_AUDIO_Ring_Start (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t index);
IFX_return_t VMMC_TAPI_LL_AUDIO_Ring_Stop (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t index);
IFX_return_t VMMC_TAPI_LL_AUDIO_Ring_Volume_Set( IFX_TAPI_LL_CH_t *pLLChannel, IFX_uint32_t level);

IFX_return_t VMMC_TAPI_LL_AUDIO_ICA (IFX_TAPI_LL_CH_t *pLLChannel,IFX_uint32_t oprn);

IFX_int32_t VMMC_AUDIO_InitOpModeParameters( IFX_void_t );
IFX_int32_t VMMC_AUDIO_InitRingParameters( IFX_void_t );

IFX_int32_t VMMC_AUDIO_BBD_AudioOpmode(VMMC_CHANNEL *pCh, bbd_block_t  *bbd_opmode);
IFX_int32_t VMMC_AUDIO_BBD_AudioRing(VMMC_CHANNEL *pCh, bbd_block_t  *bbd_opmode);

void VMMC_AUDIO_Func_Register (IFX_TAPI_DRV_CTX_AUDIO_t *pAudio);
IFX_int32_t VMMC_AUDIO_ChStop (VMMC_CHANNEL *pCh);
IFX_return_t VMMC_AUDIO_Allocate_Ch_Structures (VMMC_DEVICE *pDev);
IFX_int32_t VMMC_AUDIO_Free_Ch_Structures (VMMC_CHANNEL *pCh);
IFX_int32_t VMMC_AUDIO_SamplingMode( VMMC_CHANNEL *pCh,
                                     SM_ACTION action,
                                     OPMODE_SMPL smpl_mode );

IFX_return_t VMMC_AUDIO_MuteCfg( VMMC_CHANNEL  *pCh, IFX_boolean_t mute );
IFX_boolean_t VMMC_AUDIO_IsChannelActive( VMMC_CHANNEL  *pCh );

#endif /* _DRV_VMMC_AUDIO_H */
