#ifndef _DRV_VMMC_HOSTAPI_H
#define _DRV_VMMC_HOSTAPI_H
/******************************************************************************

                              Copyright (c) 2009
                            Lantiq Deutschland GmbH
                     Am Campeon 3; 85579 Neubiberg, Germany

  For licensing information, see the file 'LICENSE' in the root folder of
  this software module.

*******************************************************************************
   Module      : drv_vmmc_hostapi.h
   Description : This file contains the defines, the structures declarations
                 and the global functions declarations for the VMMC INCAIP2
                 host.
******************************************************************************/

/* ================================ */
/* Includes                         */
/* ================================ */
#ifdef EVENT_LOGGER_DEBUG
#include "el_log_macros.h"
#endif /* EVENT_LOGGER_DEBUG */

/* ================================ */
/* Defines                          */
/* ================================ */

/* channel defines */
/** VMMC maximum channel number */
#ifndef VMMC_MAX_CH_NR
#define VMMC_MAX_CH_NR              VMMC_INCAIP2_CH_NR
#endif /* VMMC_MAX_CH_NR */
/** VMMC maximum analog channel number */
#ifndef VMMC_MAX_ANA_CH_NR
#define VMMC_MAX_ANA_CH_NR          VMMC_INCAIP2_ANA_CH_NR
#endif /* VMMC_MAX_ANA_CH_NR */
/** Number of UTD submodules per signaling module */
#define VMMC_NUM_UTD                    1
/** VMMC INCAIP2 maximum EDSP channels */
#define VMMC_MAX_EDSP                   4
/** Maximum Number of Coder */
#define VMMC_MAX_CODER                  4
/** Maximum Number of Signalling */
#define VMMC_MAX_SIG                    4
#define VMMC_MAX_SIG_ROM                3 /* 3 signalling channel in ROM */
/** Maximum Number of PCM */
#define VMMC_MAX_PCM                    8

/* FIXME: all xCPE have max 1 PCM I/O, but incaip2?? */
#define PCM_HIGHWAY                    1

/** count of PCM shortcut channel resources */
#define VMMC_PCM_S_CH_RES_CNT          2

/** default ring frequency */
#define VMMC_DEFAULT_RING_FREQ                     25 /* Hz */
/** default ring amplitude */
#define VMMC_DEFAULT_RING_AMP                      0x7FFF
/** default ring hook level */
#define VMMC_DEFAULT_HOOK_LEVEL                    0x4AA0
/** default ring trip dup time */
#define VMMC_DEFAULT_RING_TRIP_DUP_TIME            0x5 /* 10 ms */
/** default ring dc offset */
#define VMMC_DEFAULT_RING_DC_OFFSET                0x0000 /* 0 Vdc */
/** default hook settling time */
#define VMMC_DEFAULT_HOOK_SETTLING_TIME            64  /* ms */
/** default hook dup time */
#define VMMC_DEFAULT_HOOK_DUP_TIME                 12  /* ms */
/** default overtemperature dup time */
#define VMMC_DEFAULT_OVT_DUP_TIME                  0x08 /* 8 ms */

/* ============================= */
/* Global Structures             */
/* ============================= */
typedef struct _VMMC_INCAIP2_HOST_CHANNEL VMMC_HOST_CHANNEL;

typedef enum
{
   VMMC_RING_TRIP_TYPE_NORMAL = 0,
   VMMC_RING_TRIP_TYPE_FAST
} VMMC_RING_TRIP_TYPE_t;

/* Ring Configuration */
typedef struct
{
   /* ring frequency */
   IFX_uint16_t ring_freq;
   /* ring amplitude */
   IFX_uint16_t ring_amp;
   /* ring hook level */
   IFX_uint16_t ring_hook_level;
   /* ring trip type */
   VMMC_RING_TRIP_TYPE_t ring_trip_type;
   /* ring trip dup time*/
   IFX_uint16_t ring_trip_dup_time;
   /* ring dc offset */
   IFX_uint16_t ring_dco;
} VMMC_RingCfg_t;

/* DC Thresholds */
typedef struct
{
   /* hook dup time */
   IFX_uint16_t hook_dup_time;
   /* onhook settling time */
   IFX_uint16_t onhook_time;
   /* overtempure duptime */
   IFX_uint16_t ovt_dup_time;
} VMMC_DcThr_t;


struct _VMMC_INCAIP2_HOST_CHANNEL
{
   /* EdspX Stat2 register */
   IFX_uint16_t      regEdspX_Stat2;
   /* LineX rising edge interrupt mask */
   IFX_uint16_t      regLineX_IntR;
   /* LineX falling edge interrupt mask */
   IFX_uint16_t      regLineX_IntF;
   /* extend here */
};


#ifdef EVENT_LOGGER_DEBUG

enum { DEV_TYPE_VOICE_MACRO = IFX_TAPI_DEV_TYPE_VOICE_MACRO };

/* Event Logger (debugging) macros, defining more
   meaningful names to Event Logger macros */
/* register read logging macro */
#define LOG_RD_REG(dev_num, ch, reg_offset, reg_data, count)\
   EL_LOG_EVENT_REG_RD(DEV_TYPE_VOICE_MACRO, dev_num, ch, reg_offset,\
                       reg_data, count)

/* single register write logging macro */
#define LOG_WR_REG(dev_num, ch, reg_offset, val)\
   do {\
      IFX_uint16_t tmp;\
      tmp = (val);\
      EL_LOG_EVENT_REG_WR(DEV_TYPE_VOICE_MACRO, dev_num, ch, reg_offset, &tmp, 1);\
   } while(0)

/* multiple register write logging macro */
#define LOG_WR_REG_MULTI(dev_num, ch, reg_offset, reg_data, count)\
   EL_LOG_EVENT_REG_WR(DEV_TYPE_VOICE_MACRO, dev_num, ch, reg_offset,\
                       reg_data, count)

/* command read logging macro */
#define LOG_RD_CMD(dev_num, ch, pcmd, pdata, count, err)\
   EL_LOG_EVENT_CMD_RD(DEV_TYPE_VOICE_MACRO, dev_num, ch, pcmd, pdata,\
                       count, err)

/* command write logging macro */
#define LOG_WR_CMD(dev_num, ch, pdata, count, err)\
   EL_LOG_EVENT_CMD_WR(DEV_TYPE_VOICE_MACRO, dev_num, ch, pdata, count, err)

/* voice inbox read logging macro */
#define LOG_RD_PKT(dev_num, ch, pdata, count, err)\
   EL_LOG_EVENT_PKT_RD(DEV_TYPE_VOICE_MACRO, dev_num, ch, pdata, (count) >> 1, err)

/* voice outbox write logging macro */
#define LOG_WR_PKT(dev_num, ch, pdata, count, err)\
   EL_LOG_EVENT_PKT_WR(DEV_TYPE_VOICE_MACRO, dev_num, ch, pdata, (count) >> 1, err)

/* event mailbox reading logging macro */
#define LOG_RD_EVENT_MBX(dev_num, ch, pdata, count)\
   EL_LOG_EVENT_EVT_MBX_RD(DEV_TYPE_VOICE_MACRO, dev_num, ch, pdata, count)

#else /* EVENT_LOGGER_DEBUG */

#define LOG_RD_REG(dev_num, ch, reg_offset, reg_data, count)
#define LOG_WR_REG(dev_num, ch, reg_offset, val)
#define LOG_WR_REG_MULTI(dev_num, ch, reg_offset, reg_data, count)
#define LOG_RD_CMD(dev_num, ch, pcmd, pdata, count, err)
#define LOG_WR_CMD(dev_num, ch, pdata, count, err)
#define LOG_RD_PKT(dev_num, ch, pdata, count, err)
#define LOG_WR_PKT(dev_num, ch, pdata, count, err)
#define LOG_EVENT_IRQ(dev_type, dev_num, ch, irq_name, irq_details)
#define LOG_RD_EVENT_MBX(dev_num, ch, pdata, count)

#endif /* EVENT_LOGGER_DEBUG */

#endif /* _DRV_VMMC_HOSTAPI_H */
