# Generated by Django 3.0.3 on 2020-05-20 11:03

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("django_etebase", "0002_userinfo"),
    ]

    operations = [
        migrations.CreateModel(
            name="CollectionInvitation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "uid",
                    models.CharField(
                        db_index=True,
                        max_length=44,
                        validators=[
                            django.core.validators.RegexValidator(
                                message="Expected a 256bit base64url.", regex="^[a-zA-Z0-9\\-_]{43}$"
                            )
                        ],
                    ),
                ),
                ("signedEncryptionKey", models.BinaryField()),
                (
                    "accessLevel",
                    models.CharField(
                        choices=[("adm", "Admin"), ("rw", "Read Write"), ("ro", "Read Only")],
                        default="ro",
                        max_length=3,
                    ),
                ),
                (
                    "fromMember",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="django_etebase.CollectionMember"
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="incoming_invitations",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "unique_together": {("user", "fromMember")},
            },
        ),
    ]
