.TH GENERATE-IPV6-ADDRESS 8
.SH NAME
generate\-ipv6\-address \- perform IPv6 address generation
.SH SYNOPSIS
.B generate\-ipv6\-address
[
.B \-p
] {
.B \-r
|
.I prefix
} [
.I mac\-48
]
.SH DESCRIPTION
.B Generate\-ipv6\-address
generates IPv6 addresses from a given prefix and either a given MAC-48
address (an Ethernet hadrware address) or a randomly drawn host
number.
.SH OPTIONS
.TP
.B \-p
Generate a prefix rather than a node address.
.TP
.B \-r
Use a randomly generated RFC 4193 prefix.
.TP
.B \-s
Use a randomly generated subnet number rather than 0.  This is only
useful with
.BR \-r ,
or when given a /48 prefix.
.TP
.I prefix
Use the given prefix.  /64 is implied, except when
.B \-s
is specified, in which case /48 is implied.
.TP
.I mac\-48
Generate a host number from the given MAC\-48 address.  If omitted,
the host number is drawn randomly (and the local/global bit is set to
zero).
.SH EXAMPLES
Generate a host number from a given prefix and MAC\-48 address:
.IP
$ ahcp\-generate\-address 2001:DB8:1234:5678:: 12:34:56:78:9a:bc
.PP
Generate a host number from a given prefix and a randomly chosen host number:
.IP
$ ahcp\-generate\-address 2001:DB8:1234:5678::
.PP
Generate a random /48 prefix according to RFC 4193:
.IP
$ ahcp\-generate\-address \-p \-r
.PP
Generate a random /64 prefix according to RFC 4193:
.IP
$ generate\-ipv6\-address \-p \-r \-s
.PP
.SH SEE ALSO
.BR ahcpd (8).
.SH AUTHOR
Juliusz Chroboczek.

