// Code generated by go-bindata. (@generated) DO NOT EDIT.

 //Package translations generated by go-bindata.// sources:
// translations/dicts/de_DE.toml
// translations/dicts/en_US.toml
// translations/dicts/eo.toml
// translations/dicts/tt_TT.toml
// translations/dicts/zh_CN.toml
package translations

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"net/http"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// ModTime return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}


type assetFile struct {
	*bytes.Reader
	name            string
	childInfos      []os.FileInfo
	childInfoOffset int
}

type assetOperator struct{}

// Open implement http.FileSystem interface
func (f *assetOperator) Open(name string) (http.File, error) {
	var err error
	if len(name) > 0 && name[0] == '/' {
		name = name[1:]
	}
	content, err := Asset(name)
	if err == nil {
		return &assetFile{name: name, Reader: bytes.NewReader(content)}, nil
	}
	children, err := AssetDir(name)
	if err == nil {
		childInfos := make([]os.FileInfo, 0, len(children))
		for _, child := range children {
			childPath := filepath.Join(name, child)
			info, errInfo := AssetInfo(filepath.Join(name, child))
			if errInfo == nil {
				childInfos = append(childInfos, info)
			} else {
				childInfos = append(childInfos, newDirFileInfo(childPath))
			}
		}
		return &assetFile{name: name, childInfos: childInfos}, nil
	} else {
		// If the error is not found, return an error that will
		// result in a 404 error. Otherwise the server returns
		// a 500 error for files not found.
		if strings.Contains(err.Error(), "not found") {
			return nil, os.ErrNotExist
		}
		return nil, err
	}
}

// Close no need do anything
func (f *assetFile) Close() error {
	return nil
}

// Readdir read dir's children file info
func (f *assetFile) Readdir(count int) ([]os.FileInfo, error) {
	if len(f.childInfos) == 0 {
		return nil, os.ErrNotExist
	}
	if count <= 0 {
		return f.childInfos, nil
	}
	if f.childInfoOffset+count > len(f.childInfos) {
		count = len(f.childInfos) - f.childInfoOffset
	}
	offset := f.childInfoOffset
	f.childInfoOffset += count
	return f.childInfos[offset : offset+count], nil
}

// Stat read file info from asset item
func (f *assetFile) Stat() (os.FileInfo, error) {
	if len(f.childInfos) != 0 {
		return newDirFileInfo(f.name), nil
	}
	return AssetInfo(f.name)
}

// newDirFileInfo return default dir file info
func newDirFileInfo(name string) os.FileInfo {
	return &bindataFileInfo{
		name:    name,
		size:    0,
		mode:    os.FileMode(2147484068), // equal os.FileMode(0644)|os.ModeDir
		modTime: time.Time{}}
}

// AssetFile return a http.FileSystem instance that data backend by asset
func AssetFile() http.FileSystem {
	return &assetOperator{}
}

var _de_deToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xac\x58\xdd\x72\xdb\xb8\x92\xbe\xe7\x53\xf4\xe2\xd4\xd9\x64\x52\x91\x62\xc9\x49\x26\x61\x42\x57\xd9\xb1\xe2\xb8\x62\x67\xbd\x96\x3d\xa9\x9d\x38\x17\x20\xd9\x24\x71\x44\x82\x3c\x00\x28\x8d\x65\xf9\x4d\xb6\x6a\x6f\xf2\x0c\xb9\xca\x9d\x5e\x6c\xab\x01\xe8\x37\xf6\x99\xe4\xd4\x5c\x89\x02\xba\x1b\x8d\xfe\xf9\xba\x1b\x49\x2d\x33\x91\x67\xa2\xc4\x88\xbd\xb7\xdf\xad\xe2\x46\xd4\x52\xa7\xdc\xa0\x60\x41\xab\x79\x8e\x11\xfb\x0d\xd5\x04\x65\xda\xca\x3c\x84\x9b\x9d\x5b\xf8\x54\x37\x44\x85\xf2\xf3\x95\xbc\x92\xff\xe5\xff\x84\x57\x92\x05\xa6\x36\xbc\x8c\xd8\x11\x6a\x5e\x19\x16\x04\xc1\xa7\x02\xcb\xe6\x73\xd0\x70\x53\xe8\x88\x7d\xe0\x49\x01\x25\x4f\x63\xae\x50\xc2\x5b\xae\x62\x9d\x14\x58\x71\xc3\xa1\x95\x29\x9c\xf0\xeb\xba\x35\x1a\x74\x3d\x11\x08\x29\x2a\xb8\x43\x2d\x98\x08\x95\x82\x90\x76\x3f\xab\xcb\x1c\x65\x8a\x12\xce\x51\x14\x28\xed\x7f\xc8\x51\xb7\x49\x61\x42\x16\x94\x75\x1e\xb1\x43\x81\x70\xa6\x6a\x53\x8f\xea\xb2\x74\x32\x62\xcc\x84\x4c\xd1\x80\x16\x49\x41\xc2\x6e\x76\x6e\x59\x30\x51\xc2\x18\x94\x5b\xd6\x20\x71\x49\xa1\x04\xc6\x28\x81\xb7\x99\xa3\xa5\x7b\x45\x8c\xb1\xe0\x00\xad\x02\x21\xfc\x13\x6a\x52\xe9\xf5\x9b\x4e\xb2\x17\x04\x67\xaa\x9e\xa2\xd6\x92\x8f\x45\x6e\xc5\x84\x01\x40\x07\x46\xf6\xa2\xaf\x2f\x9b\xbd\x10\xea\x18\xa5\x5d\xfc\x87\x5b\x3c\xac\x27\x72\x2f\x04\x29\x30\x45\x65\x37\x5e\xbf\xe9\xb4\x7b\x21\x14\xbc\x8c\x11\x86\x28\x0c\x82\x24\x13\x2e\x39\x5f\xbf\xe9\xa4\x77\x11\xb4\xd2\xac\x28\xe2\xbd\x10\x72\x2e\xa7\xf7\x8a\xc8\xee\x22\x58\x89\xc8\x73\xa7\xdf\xbb\xba\x42\xd2\x6f\xc1\x0e\xba\x51\x42\xe6\x9e\xea\xc8\x11\x0d\x64\xba\xa0\xb1\x12\x56\x44\x64\x92\x04\xb5\x06\x9e\x58\x6f\x3a\x83\xbc\xbe\xe0\xa4\x9f\x37\x57\xae\xda\xa6\x11\xa8\x5a\x99\x43\x5b\xe9\xa4\xe0\xe5\x42\x8b\x34\x0d\xc1\xd9\x1a\x50\x48\xeb\x0a\x9d\xe3\x64\xfe\xa5\x20\x92\x85\x00\xe7\x03\x22\x80\x23\x92\x85\x30\xae\x97\x9b\x28\xa1\x12\x06\x86\xc7\x47\x17\x83\xf3\x53\x78\xd8\x7b\xf6\x8b\x13\xbd\xfb\x17\x8a\xfe\xef\xcb\xe3\x0b\x78\xb8\xeb\x25\xbf\x0c\xc1\xcc\xbf\x9a\xbf\x42\xf0\xfb\xe3\x93\x13\x78\xf8\xf2\x97\x65\x6c\xe9\x5a\x19\x67\x2b\x67\xca\x24\x84\x37\x67\x97\xf6\xb3\x0a\xe1\x14\x2b\xfb\xd9\x84\x70\x76\x7c\xb8\x64\xca\x44\x69\xd6\x78\x9e\x84\xf0\xd6\xae\x40\x8c\x5c\xc5\xe4\x7e\x67\xee\x87\xa4\xa5\x42\x99\xda\x3c\x3b\xf0\x9b\xad\xcc\x7f\x21\x46\xeb\xb9\x81\x34\xa8\xf6\x96\x02\xf8\x68\x8a\x0d\x29\x64\x25\xf8\xd0\x4a\xf6\x7c\x58\xe8\x84\x37\xb8\x22\x2e\xe7\x5f\x29\xf5\x65\x10\xbc\x39\xbb\xec\x58\x9a\x53\xac\x3a\x47\x8a\x37\x45\x67\x38\xe2\xe5\xfa\xc5\x8a\x10\xb4\x5b\x42\x09\xc2\xe9\x57\xae\xad\x05\xc1\x07\x34\xd3\x09\xaa\x91\xa3\x8f\x43\xb8\x5c\x06\x0f\x4c\x27\xc2\x1e\x05\xa7\x07\xc2\xc0\x13\xd0\xf6\x34\xcf\x4c\x04\x07\xd7\x06\x35\x34\xaa\x86\x21\x8e\x5a\x99\x62\x40\x79\xfd\x37\x98\xff\xef\xc1\xe0\x7c\x38\xb8\xf8\x7d\x70\x1e\xc2\x01\x41\x03\xcc\xbf\xc5\xa8\x34\x9a\x29\x4a\x18\x12\x46\x09\xf4\xa8\xd5\x79\xf4\xe8\x03\xaf\x50\x3e\x7a\x04\x52\x24\x85\x09\x4a\x0f\x66\x11\x30\xc6\x06\x94\x02\x31\x6f\xcd\x82\xdc\x46\x3f\xa4\x98\xf1\xb6\x34\xf4\x59\x09\x29\x2a\x5e\xd2\x67\xcc\x8d\x41\x75\x4d\x9f\x23\x61\x48\x75\x2d\xe4\xe8\xa7\x74\x5a\x41\xeb\x77\x7a\x25\x75\x59\x2b\xbb\x87\xdf\x2b\xb7\x0e\xc9\xdb\x1a\xfa\xcf\x4e\xca\xd5\x08\x1e\x66\xf3\x6f\x0a\x26\x28\xe6\xff\x87\x12\xde\x09\x0a\x85\x5c\xb5\x32\xa5\xb8\x07\x5d\x97\x5c\x89\x29\xa6\x1b\x7f\x7a\xcf\x2d\xef\xf6\x5a\x29\xf2\xc2\x99\xa0\x96\xf5\x88\x0b\xfa\x1c\x8b\x04\xe9\x57\xd6\x2a\xfd\xa9\x8b\x7f\x14\x69\x8e\xdf\x3b\x63\x62\x97\xfd\x7d\x1d\x8d\x7e\x6c\x19\x84\x5c\x96\x9d\xb1\xab\x73\x68\x60\x82\x8a\x6a\xca\x68\xfe\x55\x52\x65\x23\x4d\x92\xa6\xb5\x31\x4d\xe1\x7a\xc2\xb5\x49\x05\xcf\x15\xaf\x2a\xab\x38\x56\x76\xef\xac\xb8\xd6\x36\xd6\xe0\x3f\x61\x38\xe1\x4d\x67\xd8\xa0\x48\x0a\x54\x4b\xd1\x12\x8e\x14\xcf\x84\xb5\x81\xc1\xaa\x21\xae\x21\x4a\xca\x64\xac\x1a\x54\xdc\xb4\x3e\x7d\x52\xa1\x47\xb4\xbb\x2a\xbe\x36\x11\x9b\xc5\x11\x12\xde\xa2\x36\x4d\x49\xb1\x22\x1b\xae\x8c\x20\x50\x25\xce\xa6\x9e\xa0\x82\x0e\x0c\x08\x50\x0e\x6c\x2c\x09\xd4\x86\xcb\xdc\x99\x14\x8d\x55\x76\x91\x32\x25\xd7\xd6\xfa\x8d\xaa\x13\x0d\x1d\x38\x26\x57\xf2\x91\x11\x63\x5c\x60\x50\x29\xb4\x41\x72\x43\x10\x7c\xe2\x2a\xd7\x9f\x7d\xf5\x7b\x27\xca\x0c\x0d\xfe\x61\x80\x8a\x87\xc8\x51\x76\x99\x8b\xaf\x88\x82\x6a\x2d\x9a\x20\x43\x6d\xb4\xc1\xb2\xb4\x34\x3a\xe1\xd4\x74\x0c\xdd\x02\x90\x5d\x56\x39\xaf\x33\x3e\x32\xb5\x05\xc4\xc7\xb0\xb7\xc3\x82\x31\x2a\x2d\x6a\x19\xb1\xdf\xed\x19\xd6\x6d\xbf\xb9\x35\x02\x54\x9b\xce\xb1\xab\xc2\x5d\x16\x34\xa8\x92\xa6\x5d\x12\x53\x60\xfc\x03\x53\x24\xc7\x81\xa8\xac\xff\x5c\x00\x00\xb7\xea\x36\x2d\x1f\x53\x93\xd0\xaa\xa4\xd0\x49\x21\x85\x31\x25\x39\xed\x4e\x86\xe5\x2d\xc9\x5d\x11\xbb\x58\x73\x1a\xd8\x0b\x13\x64\x16\x28\x36\x68\xb5\xe1\xa6\xd5\x31\x57\x1b\x4a\x59\xbc\x1f\xda\xad\x12\xc9\xc0\x16\xe7\xc9\xc7\x97\x85\x9a\x3a\x11\x5d\x16\x28\x6e\x30\x62\x6f\x15\xfe\xb3\x45\x39\x05\x3e\x32\x2d\x2f\x85\xb6\xb8\xd7\x05\x6a\x6d\x2a\xcb\x2d\xe1\x77\x02\x6f\x61\x4f\x47\xb9\x08\xe1\x25\x28\x9b\x2e\x5c\xb1\x5e\x75\xc5\x20\x72\xf6\x38\x15\x92\x32\x7e\x4b\xe0\x15\xeb\xed\xec\x40\xa5\x2d\x1d\x2f\x4b\x04\xf7\x7f\x8b\x8e\x79\x78\xa3\x96\xae\x72\xad\x9a\xcf\xa2\x06\xa7\x22\x13\xa3\xf5\x86\xcd\x42\x05\x39\xed\x00\x65\x6b\xa6\xa8\xea\x18\x55\x56\xce\xbf\x24\x05\x76\x17\x01\xee\xad\x72\xc5\x3a\x57\xec\x31\xb4\x15\x4c\x5b\x28\xed\x55\xba\x2c\x90\x68\x22\xf6\x91\xca\xe6\x5a\xaa\x2f\x02\xd8\x3b\xcd\x45\x57\x17\x4e\xb1\x50\xa8\x10\x86\xeb\xcb\xcb\x5c\x76\x46\x26\x5f\xc3\xfb\xba\xaa\xb8\x86\x1c\x8d\x42\x69\x5b\x95\x8f\xae\x1e\xa4\xd4\x1c\x92\xc9\xbc\x11\xbb\xf7\xc9\xe2\x6d\x52\x58\x81\x22\x97\xb5\x5a\xe3\x80\x2b\xf6\x1f\x57\x8c\x05\xf8\x47\x53\x2b\x13\xb1\x7d\x4a\x27\x57\xbe\x48\xfb\x53\x34\x4a\x8c\x50\x7a\xcb\xa0\x84\x81\x25\xb4\xdd\x65\x8a\x15\x50\xae\xe6\xd4\x6f\x52\x93\x50\x2b\xd3\x65\x41\x15\x37\xd4\x40\xfb\x3b\x53\x54\x00\x2f\xf5\xaa\xa6\x6d\xc4\xa6\x36\x11\x7b\x3b\xff\x56\x28\x03\x17\x94\x78\x5b\x69\x62\x20\xe5\x9a\x92\xdb\x22\x98\xbd\xc1\x40\x51\xeb\xac\x3b\xf0\x04\xde\x62\x51\xa2\x4a\xea\x14\x6d\x36\xcb\xec\xde\x09\xc1\x21\x28\x97\xce\x2e\x36\x0a\x86\x86\xcb\x94\xab\x14\x85\x5b\x25\xdc\xfa\x0e\x57\x75\x5d\x96\xf0\xf0\xf4\x72\x38\x84\xc3\xfd\x21\x0c\xce\x87\x17\x03\xd8\x3f\x3f\xba\x3c\x1d\x7c\xb8\x80\xe1\xe0\xf8\xc3\x2f\x2c\x20\xd0\xb1\x0d\xf6\x89\xd0\x06\x5e\xa7\x48\x35\x41\xcf\x7c\x59\x9d\xad\x97\xb1\x99\x1d\x2f\x66\x23\xbc\xa6\x7d\x99\xeb\x3d\x57\xaf\x2c\x47\x08\x87\xaa\x4d\x46\x06\x8e\x50\xcd\xbf\x18\x94\x54\x18\x9c\xe5\x5d\x2f\x44\xc3\x88\xaf\x1b\xd6\x50\xc4\xeb\x4f\x09\x81\x0e\x47\x03\x54\xdf\x72\xeb\xe1\x65\x01\x27\x67\xd9\xc2\xb0\xa6\xc8\x9d\xf4\x1b\x63\x8e\x67\xb2\x0a\x7b\xea\x55\x44\x0f\xdb\xa4\x68\x32\x9e\xa2\x53\xef\x0e\x8b\xbb\x09\x84\x24\xf8\x8a\x16\xc2\x76\x35\x23\x5c\xa9\xbc\x92\xf7\x96\x34\xdb\x5b\xe0\xb5\x0e\x61\x0d\x91\x48\xc0\x05\xb7\x68\xa5\x62\x61\x6b\x0e\x9d\x27\xbb\xce\x22\x32\xd7\x21\x5c\x52\x75\xd0\x66\xfe\xcd\x4c\x0d\xc2\xb0\x51\x3c\x29\x96\x75\x78\xc1\xb0\x88\x44\xe6\x46\x2a\x42\xfa\xa4\x50\x28\xe2\x2d\xe8\xb3\x91\x32\xfa\xfe\x96\x5d\x5b\x69\xdc\x78\xda\x45\xa5\x3e\x07\xee\x5b\x5f\x4b\xc3\xff\x88\xd8\xce\x0c\x74\x52\x94\x98\x14\xa4\x83\x5d\xbc\x6f\x5a\x7c\x65\x83\xcd\x20\xbc\x1f\xfc\x4f\xf4\xdb\xfe\xc9\xe5\x00\xb4\x2d\x2c\x13\xae\xdc\x20\x97\x62\xa3\x30\xb1\x2c\x11\xeb\xcd\xc8\x20\x25\xd2\x56\x08\x0f\x6e\x7a\xb7\x0f\x80\xc2\x6f\x8c\x8a\x9a\x49\xd3\x85\xe3\x65\xaa\xdf\xf4\x6e\xa3\x9b\xfe\x2d\x45\xaa\xc4\x88\xf5\x17\xac\x7f\xb3\xbc\x37\xbd\x5b\x57\x25\x7c\xad\xdb\x9d\x41\x2b\xf3\xf9\xb7\xd2\x88\x1c\x15\x50\xe5\x18\xd2\x4e\xe7\xa3\x95\x45\x9a\x04\xc1\x27\x54\xaa\x5e\x5e\xb7\xe1\x4a\x63\xc4\x9e\xce\xee\x1c\x83\x47\x35\x81\x96\xeb\x6f\x80\x4b\x5e\x5e\xeb\x35\x04\x0a\x9d\xc8\xa4\x14\x5e\xca\xb3\x19\xec\x2f\x88\x50\xda\x09\xe3\xcd\xc9\x71\x67\x5f\xe5\x6d\x85\x84\x7e\x9e\xa3\xac\x73\x8d\xa6\x6d\x22\xf6\x7c\xb6\x3d\x35\x6f\x1c\x89\xd4\x35\x2a\xfa\xc4\xad\x43\x5b\x39\x92\xf5\x44\xd6\x8d\x89\xd8\xaf\x33\xb8\x94\x31\x8e\xb8\xe5\x74\x6f\x05\x70\xc5\x6e\x76\x6e\xaf\xd8\x2b\x92\x1f\xaf\x60\xd1\x27\xdd\xe3\x8d\x94\x7a\x6c\xe3\xf4\xb1\xcb\x18\x37\x29\xf9\xc4\xa6\x5c\xbd\x92\x3e\xc4\x32\x2e\xca\x88\xbd\xf8\x01\x53\xad\x4f\xf3\x9b\xb6\x2a\x30\x19\xd9\x07\x83\x97\x33\xca\x32\x5b\x18\x0c\x4a\xf4\x88\xf8\xca\x1a\x8d\x9c\xcb\x82\x8a\x10\x3c\xf1\x86\xea\xed\xcc\x3c\x09\xc4\x28\x2a\x6a\xbc\x9c\x5d\xe4\x82\xa3\xb3\x40\x7c\x1f\x17\xb2\xf6\x02\x22\xd6\xeb\xcd\xe0\xbd\x4d\x88\xcd\xaa\x70\xb3\x73\xeb\x68\x33\x6e\x38\xb5\x59\x49\x11\xb1\x5e\x7f\x46\xb5\x68\x82\x6a\x22\xd0\x3e\x7c\xa8\x8d\x93\xf7\x63\xd5\x66\x6b\xc7\x1e\xcb\xac\x56\x15\xf7\x0f\x34\x4e\x9e\xc2\xa4\x1e\x2f\xe4\xed\xce\x20\xc6\x02\x63\xc2\xc0\x9f\x10\xf5\xca\xf7\xde\x7e\xb4\x87\x55\xc4\xcb\x3a\xc5\x71\x56\xb7\x32\x8d\x58\xef\xe9\xe2\x6a\x1e\x86\x2c\xd2\xd2\xc5\x72\xcc\x68\xce\x92\x2c\xb0\x26\x44\xa5\x22\xd6\x7b\x76\xaf\x15\x57\xe2\xd7\x22\xc3\x55\xa5\xde\xf3\xd9\x1a\xc0\xde\xe9\x6e\x77\xd4\x02\x00\xe9\x78\x21\xbf\x93\xa6\x90\x93\xc6\xbf\xfe\xa9\xb4\x12\xf5\x86\xb0\xef\x15\xf3\x09\xd7\x7b\xf1\x27\xb2\xee\xcb\xd9\x4c\xc8\x74\xd1\x5d\xf5\x5e\xfe\xbb\x0a\x95\x75\x5e\x37\x28\x23\xd6\xdf\xf9\xd7\x79\x9c\xe3\xfc\x6b\x96\xc9\x55\x89\x58\x83\x2f\x1e\x93\x8d\xfb\xbd\x19\x5c\xf0\xd8\xf6\x3e\x8b\x56\xf8\xa2\x6e\xce\xeb\x89\x03\xaf\x51\x49\x4e\x56\xb6\x1f\xd9\xe9\xfa\x2d\x7f\x19\x59\x17\xb5\x36\x54\x73\x23\xd6\xef\xcf\xe0\x9d\xff\xb7\x65\x8a\x38\x47\x17\x6e\x1b\x96\x08\x3e\x39\x3b\x74\x3d\x2c\xba\x9a\x17\xb1\xfe\x2e\xa1\xca\x0a\x4c\xfd\xd0\x67\x5b\xd1\x9b\x9d\xdb\x2e\x9c\xb6\x5a\x83\x53\x8a\xe2\x97\x10\xdf\x27\x93\x8d\xe1\x88\xf5\x9f\xce\x7c\x89\xcc\x5c\xc8\x09\xb9\x0e\xfc\x6f\x2d\x19\x54\x24\xe6\xa6\x77\x6b\x05\x74\x37\xa2\xf3\x8c\x9c\xec\xb3\xa3\x7f\x6b\xaf\x2e\xa4\xe9\xc2\x21\xd7\xf0\x91\x5a\x39\x5b\x5f\x76\x6f\xb7\xfb\x5b\x9b\x0e\xf6\x24\x59\xcc\xbf\x16\xee\xa9\xa7\x47\x43\x42\xc9\x75\x81\x3a\x62\xfd\x67\xb0\xd0\x6d\xc2\x95\xa4\x06\x6a\x53\xb9\x69\x0b\x63\x81\x25\xc2\x83\x27\x0f\x68\xcb\x1e\x77\xd3\xbb\x7d\x05\xd3\x56\xcf\xbf\x98\xa9\x1d\x5f\x24\x9c\xce\xbf\x95\xe5\xb2\x35\xb5\x9d\x61\xf0\xc9\x99\xb0\x5b\x92\x3b\x3f\x07\x34\x64\x46\x6c\x7d\x92\xa4\x06\x9d\x8e\xb4\x83\x51\xc4\xec\x10\xc4\x5b\x52\xce\xb8\xe5\x9c\xb7\x39\x46\x0c\x4e\x68\xea\xa0\x69\xad\xc1\x1c\x4b\x60\x81\x7f\xb5\x88\xd8\xfa\xcc\x69\x5a\xed\xb7\xd6\xd6\x61\x31\x3e\xc1\xc6\xfc\xe4\xdb\xfc\x65\x5f\xbf\x52\x45\xa2\x11\xf2\x8e\x2d\xf7\x1c\x4d\x68\x5c\x45\x0c\x16\xc3\xf6\x8a\x6f\x75\x5f\x89\xc6\x35\x12\x12\x0d\x4f\xa8\x19\x37\xd7\x11\xeb\x3f\x87\xd9\x52\xa6\x1d\x79\x85\x99\x7f\x31\xd6\x27\x79\xdd\xe8\xd6\x88\xf2\x87\x02\x55\x62\x3e\xe6\xa5\xc2\x64\x1c\xb1\xfe\xaf\xb0\x00\xb2\x10\x24\xe6\x9c\x26\x69\x65\x67\x0b\x87\xec\xa3\xf9\x37\x65\x7d\x04\x58\x35\x19\xb5\xfa\x72\x35\xcc\x50\x82\xca\x0d\x05\xba\x70\x8e\x09\x4a\x63\x5f\xa9\xce\x31\x19\x6f\x9c\xa9\x91\x0c\xd3\x7f\xf1\xc3\x67\xe6\x04\x17\x29\x9a\x1f\x3e\x72\x88\xd2\x84\xcb\x06\xc5\xdb\x93\x02\x67\x11\x3e\xc3\xa4\xa0\xd6\x8e\x05\x55\xdd\x92\x32\xa7\xb5\x74\xaf\x80\x2c\x68\x35\xa6\x11\x3b\xc2\x58\xd1\xa8\x64\x58\x90\x29\xb4\xa3\x04\xb5\xbd\x65\xad\x59\xa0\x74\xc4\xce\x69\x80\x61\xc1\x44\x47\xec\xa3\xfb\x5c\x1d\xd4\xa8\x3a\xf9\x1c\xb8\x46\x9d\x22\xd5\x7e\x84\x40\xf3\x67\x8c\x65\xc4\x96\xcf\xa4\xc0\x36\x78\xba\x05\xf2\x14\x6d\x2b\x65\x95\xda\x97\x53\x5e\x94\x84\xd3\x55\xc5\xa9\x38\x1d\x20\x65\xbe\x0f\xf3\x37\x67\x97\x7f\xf7\x61\x74\x8a\xd5\xdf\x59\xd0\x88\x34\x62\x67\xc7\x87\x5b\x42\x7d\x2f\x6a\x25\xf6\x5f\xc2\xcc\x3e\x0e\x38\xd1\x9b\x71\xb2\x11\x41\xf7\x04\x8d\xa2\x7a\x8f\x63\xea\x0d\x77\x60\xb6\xba\x88\x13\x24\xff\x75\xc4\xd1\x30\xb8\xdb\x83\x19\xb8\x7b\xc0\x83\x46\x3f\xd8\x0a\xd5\x56\xe7\x98\xb9\x21\x70\x83\x75\xa1\x57\xc4\x76\xfb\xf7\x9f\xfb\x23\x37\x68\x44\x9a\xd4\x72\x1c\xb1\xdd\x5d\xb0\x9d\xd7\x18\x17\x2f\xd2\xb6\x1f\x3f\x3b\x3e\x24\x80\x12\x3e\x80\x80\x34\xb5\xed\x57\xc9\x69\x3e\x80\x13\x1a\xb3\xc1\x96\xcf\xa6\xf5\x92\x9e\xde\x29\xc9\xda\x79\x05\x43\x42\x42\x56\xd6\xdc\x6c\x49\x0c\x1d\xfa\xaf\xc4\x56\x58\x79\xb1\x04\xaa\x87\xee\xdd\x68\xf1\x9c\x46\x37\x3c\xc5\x6a\xd3\x6a\x4b\xc9\xa3\xa5\x0e\x1b\xe6\x5b\x97\x9e\xa3\x49\xaa\x34\x62\xbb\xcf\x57\x66\x8c\x9d\x3b\x7e\x12\x41\xba\xd0\xe8\x33\x55\x27\xb6\xee\x76\x41\x84\x54\x54\xba\xd0\x88\x34\xa4\x22\x62\xed\xd3\xa0\x4a\x6c\xb2\xef\xae\x00\x66\xb3\x55\xb3\x26\x77\x6a\x74\xc8\x60\x1f\x3c\x10\xae\x2b\xf3\x63\xc7\x55\x16\x97\xfd\x71\x2f\x56\xb7\xd3\x1e\x62\xd7\x2a\xc2\x4f\x86\xfd\x9f\x1e\xed\xbb\xa7\x5d\xca\xae\xfd\x56\xe7\x3c\xde\xee\x15\xee\x69\x9b\xfe\x3f\x00\x00\xff\xff\x2e\xa9\x9b\xb5\xce\x1c\x00\x00")

func de_deTomlBytes() ([]byte, error) {
	return bindataRead(
		_de_deToml,
		"de_DE.toml",
	)
}

func de_deToml() (*asset, error) {
	bytes, err := de_deTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "de_DE.toml", size: 7374, mode: os.FileMode(420), modTime: time.Unix(1611683186, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _en_usToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x58\x5f\x73\xd4\x38\x12\x7f\xf7\xa7\xe8\xd3\xd6\x2e\x90\x4a\x86\xcc\x04\x16\x30\x38\x55\x10\x02\x97\xda\x84\xcd\xe6\xcf\x51\x57\x84\x07\x8d\xdd\x63\x6b\x63\x4b\x5e\x49\x9e\x61\x2e\x93\xef\x7e\xd5\x2d\x79\xfe\x84\x70\xb7\xf0\x64\xa9\xd5\xdd\xea\x56\xb7\x7e\xdd\x72\x6e\xf4\x44\x95\x13\x55\x63\x26\x0e\x78\x0c\x34\x11\x49\xe7\x64\x89\x99\xb8\xa4\x4f\x0a\x37\xbb\xb7\xf0\xc9\xb4\x5e\x19\xed\x3e\x5f\xe9\x2b\xfd\x7b\x18\xa7\x57\x5a\x24\xde\x78\x59\x67\xe2\x82\x3e\x22\x49\x92\x4f\x15\xd6\xed\xe7\xa4\x95\xbe\x72\x99\x38\x36\xb2\x90\xe3\x1a\x21\x37\xb5\xb1\x2e\xaf\xb0\x41\x07\xbf\x40\x2d\xe7\xa6\xf3\x6e\x1b\xa4\x2e\xc0\x57\xb4\xbe\xdc\x7e\x1b\xa4\x45\x70\x28\x6d\x5e\x61\x01\x13\x63\xb7\x41\x69\x30\xb6\x40\x9b\x8a\xa4\x36\x65\x26\x2e\x2a\x84\xda\x04\x7e\x50\x8e\xd6\x6f\x76\x6f\x45\x32\xb3\xca\x7b\xd4\x4b\x77\xe2\x1c\xbc\x09\xeb\x64\x5c\x26\x84\x48\xfe\xe8\x94\x4f\xe1\x2f\x30\x16\x5e\x1d\xec\xe4\xfb\x49\x72\x6a\x4d\x8e\xce\x81\x96\x53\x55\x4a\x72\x30\x4d\x00\x76\xe0\x9a\x6d\x7c\x75\xd9\xee\xa7\xd0\xb5\x4c\xfa\x33\x90\xde\x9a\x99\xde\x4f\xa1\x30\x33\xcd\xe4\x57\x07\x3b\xdd\x7e\x0a\x95\xac\x27\xd0\xca\x12\x7b\xf6\x57\x07\x3b\xc5\x06\x7d\x5d\x62\xbc\x9f\xc2\xa4\xab\xeb\xbb\x12\x93\x0d\xfa\x52\xa2\x2c\xc3\xde\xff\x34\x0d\xee\xa7\xf0\x67\xd7\xb4\xe4\x9c\x37\x41\xf0\x7d\x58\x3d\xd4\xc5\xda\xe2\xd8\x78\x6f\x9a\x95\x87\x32\x0f\xe1\x0b\x5b\x5d\x48\x32\xc1\x9b\xb2\xac\x11\xda\xc8\x52\x5a\xd3\xb5\x4a\x97\xcc\x52\x14\x29\x5c\xab\xba\x06\x87\x35\xe6\x1e\x8b\x25\x9b\xb1\x81\x13\xcc\xa4\xa7\xa1\x83\x99\xf2\x15\x9c\x1f\xbd\xbf\x38\x3c\x3b\x81\x87\xc3\xa7\x8f\x82\x96\xbd\x1f\xd3\xf2\xc7\xe5\xd1\x05\x3c\xdc\x8b\x4a\x5e\xfc\x98\x92\xdf\x8e\x8e\x8f\xe1\xe1\x8b\x47\xab\x43\x70\xc6\x7a\xa5\xcb\x70\x08\x79\x0a\x07\xa7\x97\x3c\x6c\x52\x38\xc1\x86\x87\x6d\x0a\xa7\x47\x6f\x57\x22\x13\x55\x7b\xb4\x4b\xa1\xc7\x29\x38\x2f\xad\x07\x2c\x14\xa9\x8a\xeb\xbc\xf6\x70\x56\x51\x66\xc6\x95\x47\x24\xc0\x87\x7d\xa8\x3d\xda\xfd\x14\x64\x9e\x63\xeb\x57\x12\x31\xe8\xf9\x7e\x8c\x9f\xcb\x65\x4b\xf1\xcd\x6b\x94\xb6\x67\x4b\x0e\x4e\x2f\x79\xfd\x04\x1b\x28\xad\x6c\x2b\x70\xb9\xac\x97\x06\x55\x29\xcf\x11\x54\xc8\x95\xba\x9f\x9b\xce\x27\xc9\x07\xf4\x33\x63\xaf\x03\xeb\x78\x19\xf1\x31\xfa\x19\xa2\x86\x66\xdc\x3a\x56\xce\x22\x05\x8c\xe7\x1e\x1d\xb4\x68\xc1\x61\x6e\x74\x91\xd0\xad\xf9\x09\x2e\xce\x5e\x7f\x38\x3f\x7e\x7d\xf1\xfb\xd9\x79\x0a\xa7\x35\x4a\x47\xc9\xa9\x1f\x78\xf0\x56\x6a\x57\x4b\x8f\x7c\x9f\xc3\x05\x87\xad\x2d\x2d\x1b\x74\x5b\x5b\x49\xbc\xf1\x90\x81\x10\xe2\x4d\xa7\x6a\xbf\xa3\x74\x8f\x03\x7c\x3e\x05\x4e\x64\x57\x7b\x1a\x36\x4a\xab\x46\xd6\x34\x1c\x4b\xef\xd1\xce\x69\x78\xad\x7c\x5e\xa1\x76\x4a\x5f\x7f\x9f\x31\x0c\x3e\x8c\x3d\x6b\x06\x6d\x20\xd2\xa6\x55\xeb\x4b\x77\x4d\x8b\xc3\x9d\x42\xda\x6b\x78\x38\x31\x16\x66\x95\xf2\x08\x63\x99\x5f\x53\x02\xea\x82\x32\x15\x9c\xa9\xa5\x55\xff\xc1\x62\x63\x32\xfc\x95\xe5\xee\xd2\x6a\x55\x56\xc1\x6f\xa3\xcd\xb5\x54\x34\x9c\xaa\x1c\xe9\xab\x8d\x2d\xbe\xcf\xdb\x99\x2a\x4a\x5c\x3f\xfa\x40\x88\x4e\x7e\x8c\x13\x5f\x49\x0f\xb9\xd4\x30\x46\xe8\x1c\x16\x70\x27\x1a\x79\xdb\x71\x56\x52\xce\xd5\x46\x16\x21\xe1\xd8\x48\x6c\x78\xe5\xb4\x9a\x3b\x95\xcb\x1a\x7e\x01\x37\x93\x2d\xd1\x8d\x9d\x93\xb2\x15\xaf\xc7\xa6\x25\xde\x73\xd4\xce\x58\x9e\xa2\x95\xbe\xb3\xe8\xf8\x30\x95\xbb\xde\x50\xc5\x84\x56\x5a\xaf\x08\xa2\x48\x17\xb1\xb5\x66\x86\x16\x76\xe0\x75\x9f\x0d\x30\x96\x7c\x6b\x34\x7a\x36\x25\xe6\x36\x1b\xca\x02\xd6\xe4\x0e\x76\xe0\x88\xae\x1b\xc1\xdd\x74\x05\x6d\xb5\x72\x9e\x0e\x34\x49\x3e\x49\x5b\xba\xcf\xb1\x26\x9c\x57\x66\x06\xbe\x52\x0e\x5c\x6e\x11\xf5\x40\x84\x0c\xc9\xc4\x39\x7a\x90\xeb\x39\x31\x10\x09\x5f\x92\x4c\xbc\x5f\x5e\x42\x84\x89\xcc\x3d\x95\xaa\xfd\x5d\x91\x4c\xd1\x3a\x65\x74\x26\x4e\xad\xd2\x1e\xe2\x94\xaf\x17\x7e\x51\x7e\x20\x92\x16\x6d\xde\x76\x71\x5b\x94\x79\xc5\x07\xad\x34\x47\x90\x86\x21\x68\x64\x45\xdb\xc9\x69\x19\x39\xe5\x14\x2d\xd5\x83\x6f\x31\xd3\x01\xf7\xbe\xac\x9d\x35\xf1\x4e\x64\x65\x51\x57\xc8\xdb\x3b\x2f\x7d\xe7\xc6\xd2\xf6\x7a\x61\x49\x09\x98\x49\x9a\xbd\x62\x5f\xad\xf4\x98\x89\x33\x9c\x58\x74\x15\x4c\x2c\xfe\xd5\xa1\xce\xe7\x03\x38\x31\xce\x33\x13\x74\x5a\x79\x17\x41\x0d\x8b\x01\xc0\x95\x18\x36\x57\x02\x32\xb0\x51\x0c\xa7\x14\xb6\x46\xe9\xce\x63\x58\xdf\xdd\x6d\xdc\x3d\x2c\x4c\x1f\x88\x88\x17\x99\xf8\x20\x1b\x24\x4c\x8f\x80\xe2\x5a\xcc\x43\xd5\xa7\xab\x47\x56\x5e\x1e\x0d\xe0\xd2\x21\x5c\x89\x9d\x2b\x41\xe5\xae\x55\x2d\x99\xad\xd1\x53\xec\xa8\x4c\x50\x9e\x70\x7e\x28\xca\x87\x89\xcc\x71\x00\xe7\xb4\x9d\xac\x57\x24\xd7\xdf\x86\x02\x27\x4a\x63\x01\x9d\x23\x50\xcf\x4d\xd3\x48\x70\xd8\x4a\x3a\x87\x02\xa6\xb2\xee\xd0\x0d\x42\x6a\xad\xe4\x64\xed\x0c\x09\xab\x52\x1b\xbb\x14\xbe\x12\xff\xb8\x12\x22\xc1\x2f\xad\xb1\x3e\x13\x87\x9a\x7b\xa1\x06\xbd\x55\xb9\x63\x0f\xc2\x12\x98\x10\x4b\xf2\x4e\x4d\x14\x95\x35\x63\x29\x4e\x84\xca\x31\x44\xbd\x0f\x64\x06\x48\xc7\x80\xcd\x11\x77\x3e\x13\x67\x9d\x76\x40\x43\xb7\x4c\xb2\x58\xfc\x5c\x97\x53\xda\x3f\x9e\x48\x55\x77\x96\xb0\xb0\x40\xce\x6d\x3d\xf9\xaa\xf1\xa3\xd3\xa3\xeb\xab\xb4\xf3\x28\x0b\x3a\xf6\x08\x77\xf0\xf0\xe4\xf2\xfc\x02\xde\x1c\xc2\xbb\xa3\xb3\xf3\x0b\x78\x7d\xf6\xfe\xf2\xe4\xf0\xc3\xc5\xa3\xef\x01\xa6\xad\xad\x5a\x8e\xb1\x76\x5b\x5b\xf0\x50\x14\x48\x08\xe7\xc4\x36\x88\x08\x3b\xe2\x11\xb9\xe5\x2b\x9c\x47\xe9\xbc\x92\xba\xc4\x3e\xcf\xd9\xf0\x84\x6e\x2f\x37\x70\xc7\xca\x79\x78\x15\xb5\x2c\xa2\x8a\xc5\x3a\x72\x2f\xb8\x07\x5d\x5c\xe3\x9c\xd6\x75\xe9\xf6\x03\x7e\xb3\x44\x0a\x7c\x35\x1d\xd5\xc6\x48\x03\xc6\x4b\x8e\x4a\x28\xb8\x1c\xac\x08\x9e\x24\xda\xc3\x23\xd0\xde\x0e\xc6\x77\x8a\x18\xa3\xe6\x7a\xe5\xb8\xcb\xb7\xbe\xc8\x28\x45\xf6\x05\x2e\x36\x23\xf4\xc0\x9d\xe5\xe6\x33\x04\x24\x74\xc1\x81\x93\x44\xa2\x35\x29\xfc\x2f\x18\x97\xd1\x22\xae\x99\x38\x77\x29\x44\x70\x43\x9a\x8e\x8d\xb4\x05\x8c\x95\x2e\x94\x2e\xdd\x20\x38\xa6\xcb\x9e\xcb\x75\x2d\xe5\x1e\x16\x4c\xed\x08\x6c\xfa\x28\x52\xd3\x38\xa0\xb3\xa7\xae\x1a\x33\xf1\x91\x3e\x6c\xb9\x5c\xe6\xc9\x5a\x1f\x3f\x60\x8c\x0d\x84\x01\x5a\xfb\x39\x09\x63\x37\xd7\x5e\x7e\xc9\xc4\xee\x02\xc6\xb2\x58\x97\x80\xb0\xf4\x12\x5c\x65\xba\xba\x20\x9f\x7e\x3b\xfc\x77\xf6\xaf\xd7\xc7\x97\x87\xdb\x30\x93\x2e\x34\xf1\x05\xb6\x16\x73\xb6\x27\x13\xc3\x05\xd4\x4a\x23\xad\xa4\xf0\xe0\x66\x78\xfb\x80\xde\x03\x3d\x0b\x83\xd1\x51\xbc\x93\x37\xc3\xdb\xec\x66\x74\x2b\x12\x12\xc8\xc4\x28\x4a\xfe\xc4\xa2\x37\xc3\xdb\x00\x9f\x11\xda\xf7\x16\xa0\xf4\x54\xd6\xaa\x80\x0b\x6c\xda\x73\xc6\x78\xbe\xfc\xc1\x88\x24\xf9\x84\xd6\x9a\xa5\x57\xad\xb4\x0e\x33\xf1\x64\x01\x74\xd3\xb0\x60\x24\x22\xda\xba\x83\x69\x90\xcd\x6b\x15\xd9\x9f\x2e\x98\x89\xb0\xe2\xe0\xf8\x08\xa8\x20\x45\x9e\xda\x94\x0e\x7d\xd7\x66\xe2\xd7\x75\x95\x4c\x5b\x3e\x7d\x22\x6f\xa7\xaf\xb5\x99\x69\xd3\xfa\x4c\x3c\x5b\xc0\x65\x98\x42\x78\xb2\xc1\x95\xb8\xd9\xbd\xbd\x12\x2f\xc1\xdb\xf9\xea\xe1\xb5\x9e\x8c\xdb\x9c\x26\xdb\x21\xcd\xb6\xa9\x95\x8e\xb7\x84\x1e\x78\x1c\x6c\x32\x20\x13\xcf\x17\xf0\x6e\x69\x09\xd3\xef\xc9\xd9\xde\xc7\x0a\xf3\x6b\x7e\xab\xbd\x58\x00\x9f\x94\x03\xd4\xb9\xe9\x08\x37\xb1\x78\x09\x13\x6b\x1a\x8e\x9a\x48\x22\x20\x06\x77\x87\xbb\x91\x9f\x7c\xe5\xbe\xba\x6b\xf9\x09\x1a\xb9\x62\xa8\xb4\x89\xf3\x4c\x0c\x87\x0b\xd0\x66\x03\x56\x89\x9f\xd9\x26\xd2\xcb\x7a\x82\x3e\xaf\x32\x31\x1c\xd1\x49\x7a\x59\x47\xfd\x4c\xa6\x0d\x88\x5b\xe9\x89\x89\xaa\x2d\xe6\x66\xda\xcb\xec\x2d\x80\xe7\x11\x0e\xbe\x21\xf9\x12\xdc\xb5\x6a\xdb\x48\x5a\x9a\x58\xe0\x74\x42\x2d\x61\x26\x86\x4f\xd8\xc6\xce\xb1\x16\x12\xe3\x05\x91\xb0\xd7\x68\x6d\x26\x86\x4f\xef\x77\x3c\x6a\x5b\x0b\x58\x00\xee\xe1\x46\x62\x4c\x94\x2e\xd6\x83\x1a\x2e\x54\xb0\xef\x2b\x05\x16\x25\xd9\xf4\x6c\x5d\x01\xd1\xee\x55\xf0\xf5\xfe\x31\x79\x87\xcf\xef\x4b\xf6\x4d\x05\x31\x1b\xc8\xba\xbe\xa2\x0f\x5f\x7c\xcf\xb6\xb5\x29\x4d\x4b\x2f\xfa\xd1\xee\xba\x18\xd1\x56\x7f\x00\xd6\x6e\x30\x9d\x6f\x26\x46\xc3\x05\xf8\x35\xfc\x86\x0b\xd3\x9e\x99\x59\xbc\xc0\x35\xf5\x81\xbe\x92\x1a\x76\x07\x71\x25\xda\xa9\x4d\x65\x9c\xa7\x42\x90\x89\xd1\x68\x01\x39\xe3\x90\x36\x1e\x48\x49\xbf\x16\x99\x93\x4f\xc1\xa5\x41\x04\x82\xb0\x55\x26\x46\x7b\x0b\x38\x8a\xd8\x11\xb7\x27\x29\x12\x1a\x00\x9c\x74\xce\x13\xb2\x19\xcd\x7d\x4d\xc8\x52\x63\x1b\x49\x92\x4f\x16\x70\x1c\x1a\x9d\x90\x09\x46\xaf\xa1\x5b\xe0\x82\x26\x2a\xb8\x19\xde\x0e\xe0\x90\xd9\x7a\x0c\xb9\x19\xdd\x52\x0d\x95\xd4\xd5\x0c\xe0\xa3\xb1\x45\x40\xcd\xbd\x5b\xea\x91\x88\x43\x82\x35\x33\xa8\x90\x5e\x1c\xb4\xfd\x90\x9a\xc1\x5a\xba\x0a\x5d\x26\x46\x4f\x97\xdb\xcf\xa4\xd5\xc4\xbf\x61\x80\x37\x06\x1a\xa9\xe7\xf0\xe0\xf1\x03\x4a\xab\x19\x6d\x70\x33\xbc\x7d\x19\xda\x1e\xe2\xc7\x2f\xde\x4a\xf8\xb3\xd3\xd7\x04\xff\x9f\x62\x63\xca\x75\xff\x73\x42\xdd\x7d\x26\xe0\x2d\x35\xf9\xfc\x6f\x09\xb8\xbd\xcd\x04\x37\xb1\x3d\xa5\x94\x5d\x89\x99\x80\x53\xee\xfa\x8f\x71\x8a\x35\x88\x24\x76\xfe\x99\x80\x37\xf1\x0d\x70\xce\x1d\x6b\x5c\x5a\xa3\xf7\x5d\x30\xe3\xf6\xb2\x03\x8e\x0d\xe1\xf2\xa9\xd0\xef\xa6\xd1\x2b\xfd\xd5\x42\xf8\xe9\x45\xc8\xd4\x64\x82\xde\xdb\xf4\xb2\xe9\x45\x56\x7e\x69\xf4\xa1\xb2\x69\xf4\xfc\xcc\x50\x7e\x9e\x89\xd1\xc6\xc5\xe4\xf0\x47\xdd\x3d\x4f\x00\xbf\xd2\xb4\xae\xf3\xaa\xee\x73\x0f\xcb\xa9\xac\x2d\xe6\xd3\x4c\x8c\x9e\x45\x2c\x48\x41\x63\x29\xf9\x01\x13\x72\x97\xd0\xcd\x62\x8e\xda\xd7\x73\x1e\xa8\x29\x16\xcb\x0d\x0a\xe9\xe5\xa6\xf2\x41\xe4\x7e\x43\xef\xf9\x33\xcc\xa7\x1b\xbb\x39\x24\xdf\x47\xcf\xff\xd6\x6e\xc4\xfc\x77\x77\x3a\x47\xed\xd3\x65\xa5\x8c\xc7\x45\xf1\xef\xb3\x80\x92\x40\x24\x0d\xd5\x83\x4c\x9c\xd0\x47\x24\xd4\xc0\x64\xe2\xd2\x61\x21\x92\x89\x45\xcc\xc4\x3b\x8b\x28\x12\xeb\x32\x71\xf6\xd8\x89\x64\xe6\x32\xf1\x91\x06\x2b\x9d\xf4\xac\xfb\x9c\x84\x86\x2d\x13\xf0\x8e\x07\x29\xd0\x03\x62\x8c\x35\xa5\xd1\xf2\x67\x90\xd8\x10\x1a\x54\x28\x0b\xe4\xfa\xcd\x36\x1c\x04\x1b\xb8\xdf\x27\xc4\x3e\x08\x83\x98\xa1\x07\xa7\x97\x3f\xc7\x74\x38\xc1\xe6\x67\x91\xb4\xaa\xc8\xc4\xe9\xd1\xdb\x3b\x4a\x63\x9f\xc3\x1a\x47\x2f\xee\xe6\x01\xa5\x39\x2f\xde\x9b\x00\x96\x0a\x18\x4e\xa9\xf9\xd8\xdd\x84\xc8\x40\x5f\xfd\xd7\x8a\x02\xf4\x36\xd8\x1b\xae\xb3\xe2\x17\xcc\x3b\x8f\xf0\xa0\x75\x0f\x20\xba\x12\x99\xfb\xcd\x32\xb1\x37\xba\x6b\xd7\xea\x87\xd9\x7d\x76\xb5\xaa\xc8\x8d\x9e\x66\x62\x6f\x6f\x5d\x90\x68\x68\x3d\x9c\x1e\xbd\xa5\xa9\x8a\x01\x1f\x30\x60\xf4\x45\xa3\xed\xa2\xe8\x93\xfb\x44\xe9\x3c\xf8\x5f\x33\x57\xb0\xda\xc8\x7b\x54\x34\xd8\x44\x15\x4f\xef\x53\x71\x82\xcd\xff\x55\x51\xa2\xcf\x9b\x22\x13\x7b\x5f\x5d\xcc\xfe\xa7\x40\x3c\xaa\x7b\xdc\x1f\x40\xeb\x28\x85\xd2\x80\xb7\x2a\x25\x90\x1d\x40\xab\xe8\x5c\xf7\x82\x8b\xf4\x98\xe7\x8b\xb4\xf7\xec\x9b\x1b\xb4\x5d\x34\xf3\x07\xb6\x68\x18\xc8\xe2\x16\xcf\xbf\xb5\x45\x83\x0d\x86\x1f\x30\x3f\xb8\x4d\x2c\xeb\x7b\x2f\xbe\x2e\xeb\xa6\xf3\x6d\xd7\x5f\xe8\xff\x06\x00\x00\xff\xff\x80\x9c\x16\x45\x37\x18\x00\x00")

func en_usTomlBytes() ([]byte, error) {
	return bindataRead(
		_en_usToml,
		"en_US.toml",
	)
}

func en_usToml() (*asset, error) {
	bytes, err := en_usTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "en_US.toml", size: 6199, mode: os.FileMode(420), modTime: time.Unix(1611683106, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _eoToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x58\xdb\x76\xdb\xb6\xd2\xbe\xe7\x53\xcc\x8f\xae\xfe\x39\xac\x58\xb1\xec\xa4\x49\x94\x30\x6b\xb9\x89\xd3\xed\x55\x3b\xf1\xf6\xa1\xfb\x22\xce\xc5\x88\x1c\x51\x10\x41\x80\x1b\x00\x95\x5a\x96\xef\x77\xdf\xa1\x79\x84\x5e\xf6\x0d\x9c\xf7\xda\x6b\x40\x50\xa7\x24\x6d\xb3\x7b\x25\x8a\x98\x23\xe6\xc3\x37\x03\x66\x46\x8f\x64\x31\x92\x8a\x52\xb1\x67\x0b\x93\x9b\xdc\x38\x49\xd6\x88\xa4\x71\x58\x50\x2a\xce\x67\x98\x9b\x01\x5c\x6d\x5f\xc3\x5b\x1a\x2a\x33\x79\x77\xa1\x2f\xf4\x3e\x3f\x0d\x2e\xb4\x48\xbc\xf1\xa8\x52\x71\xda\x54\x46\x24\x49\xf2\x76\x4c\xaa\x7e\x97\xd4\xe8\xc7\x2e\x15\x1f\x7f\x45\x7b\xf3\x81\x86\x0a\xa1\x54\xc6\xe2\x04\x5c\x49\x95\x99\xc0\xff\x03\xe9\x1a\x6f\x3e\xc8\xc2\x4c\xee\x41\x89\x13\x50\x08\xb8\x1a\xc0\x3d\x20\xe7\xd1\x81\xb1\x39\x82\x23\x7b\xf3\x0b\x7a\x59\x48\x37\x10\x89\x32\x45\x2a\x0e\x4d\xd1\x89\x82\xb7\x66\x2a\x6f\x3e\xa0\x83\x9b\x5f\x88\x43\x15\xc9\x7b\x2b\xbd\x27\xdd\x66\x65\x73\x03\xae\xb4\x72\x28\x6f\x3e\xc8\x15\x21\x8e\x35\x15\x42\x24\xfb\x4a\x5a\x39\x80\x7f\x03\x7e\xfc\x0d\x9e\xbd\xd8\xca\x9e\x27\xc9\xb1\x35\x19\xcd\x10\x34\x4e\x65\x81\xb9\x99\x0c\x12\x80\x2d\x28\x43\xb4\xcf\x4e\x9b\xda\x92\x7e\x3e\x00\x17\x1e\xc2\xd2\xa4\x5d\x3a\x42\xe5\xba\xd5\xaa\x7b\x0e\x02\xcf\x5e\x6c\x35\xcf\x07\x90\x37\x46\x23\x70\xfa\x06\xd6\x57\xf3\x8d\xd5\x4f\xd4\x87\xcf\x07\x50\x2b\xfa\x82\xfa\x68\x63\x75\x5d\xbd\x28\xda\xf8\xfe\x41\x93\xca\x70\xe4\xa8\xbc\x04\x54\xc1\x88\x69\x65\x7e\x68\x45\x5e\x49\xbd\x26\x11\x0d\x19\xbd\xdc\x16\x2c\xba\x1d\x79\x76\x88\xba\x20\xcf\x0a\xa8\x3c\x59\x2d\xa1\x0e\x42\x46\x43\x61\x9b\x5a\x16\x32\xc8\xe5\xf9\x00\x46\x52\x4b\x2e\x35\x29\x2a\xbd\xf4\x38\xd1\x9d\xec\x44\x87\xcd\xdf\xd0\x34\x1a\xca\x46\xc3\xe9\xc1\x0f\x67\xfb\x27\x47\x70\xbb\xff\xf0\x4e\x6b\x6b\xf7\xef\xd8\xfa\xe7\xf9\xc1\x19\xdc\xde\x8d\xa6\x9e\xfc\x1d\x53\x3f\x1e\x1c\x1e\xc2\xed\x27\x77\x96\x1b\x63\x6c\x2e\x17\x7b\x93\x0d\xe0\xc5\xf1\x79\x78\xac\x06\x70\x44\x95\xb1\x26\xfc\xab\x07\x70\x7c\xf0\x72\xa9\x35\x92\xca\xdb\x25\xca\xee\x0f\xa0\x34\x15\xe9\x4c\x82\xa5\x1c\x4b\x2f\x5b\x09\xa9\x62\xa1\x6e\xe7\x4d\x15\x97\x30\x97\x77\x58\x2b\xd4\x62\x5f\x4b\x2b\xb9\x12\x65\x46\xf5\x86\x56\x44\x49\xf6\xbc\x2d\xf2\xbe\x2b\xb1\x66\x59\x62\xf4\xaf\x48\x26\x2f\x8e\xcf\x83\x48\x88\x17\xa1\xb0\x38\x92\x8a\x8f\x10\x2a\xd9\xc6\x37\x1e\xc0\xcc\x54\x6d\x5d\x55\x80\x79\xf8\x9b\x9c\x90\x37\xad\xc4\x70\x89\x06\xa9\x3d\x59\xa8\x86\xb5\x0b\x56\xd9\x0c\xc1\x10\x27\xde\x4c\xa0\x36\x16\xf2\x06\x13\x3e\x85\xdf\xc0\xd9\xc9\xde\xeb\xd3\xc3\xbd\xb3\x37\x27\xa7\x03\x38\x56\x84\x8e\x20\x37\xfa\x96\x07\x6f\x51\x3b\x85\x9e\xc0\x8f\x09\x14\x5e\x9a\xc6\xc3\xdd\xbb\x1a\x2b\x72\x77\xef\x26\xed\x0b\x07\x29\x08\x21\xf6\x75\x69\xb4\xf3\xb6\xe1\x4a\xae\x10\x4d\xd8\xa4\x9c\x46\xd8\x28\xcf\x8f\x95\xd4\xb2\x42\xc5\x8f\x43\xf4\x9e\xec\x25\x3f\x96\xd2\x67\x63\xd2\x4e\xea\xf2\xeb\x82\xca\x8c\x32\xd6\x65\x63\xaa\x68\x25\xb2\x95\xb7\x9f\x0d\x6f\x8d\x17\x37\x23\x8c\x8f\x5b\x39\xda\x12\x6e\xf3\x5e\x0d\x15\xea\x12\x61\x64\xb4\x61\xf8\x82\x33\x0a\xad\x9c\x51\xbe\xf6\xa7\xff\x5d\x50\xd9\x7c\xa7\x64\x31\x6e\x33\x37\xda\x94\xc8\xe5\x83\xa9\xcc\x88\x7f\xb5\xb1\xf9\xd7\xe5\xfb\x5e\xe6\x05\xad\x16\xa1\x7d\xb1\xc8\xb2\xdd\x76\x9c\xc0\x2b\xd2\xe4\xbc\xc5\x9b\xdf\x63\x86\x59\xdd\x04\x30\x32\xce\x3e\x7e\xe0\x16\xb1\x00\x59\x88\x8e\xaa\xb0\xfc\x4a\xce\x64\x89\x50\xe2\x65\x0b\xa1\x8f\x1f\x50\xb3\x68\xb5\x06\x4b\xd6\xf0\x54\xd5\xac\x71\x46\x55\x4d\x16\x7d\x63\xb9\x67\x68\x27\x95\x99\x84\x7d\x94\xae\x5c\x5a\x9c\x84\xff\xb9\x74\x35\x5a\x1f\x22\x6c\x66\x98\x47\x53\xb5\x79\x4f\x16\xb6\xe0\x7b\xf4\x64\x25\x3b\x9b\x35\x36\xae\x69\xf2\x21\xb0\x13\xf2\xab\x1a\xd6\x64\x0e\xb6\xe0\x80\x63\xc4\x02\x23\x59\x20\x28\xe9\xbc\xe1\x3d\x4d\x92\xb7\x68\x0b\xf7\x2e\x36\x9c\x9b\xff\x48\xf0\xb2\xd1\x20\xf5\xc8\xd8\xca\x4c\x7a\xa2\x85\x49\x2a\xf6\xb8\x59\xc9\x75\x50\xf4\x44\xe2\x32\x0c\x1d\xba\x5d\x6d\x13\x47\x1d\x4e\x92\xd1\xf7\xe0\xf9\xb6\x48\xa6\x64\x9d\x34\x3a\x15\x47\x46\x7b\x2b\x21\xfe\x0f\x27\x2e\x1c\xf0\x9e\x48\x6a\xb2\x59\xdd\x2c\x44\x6e\x7e\xe1\x20\xb8\x08\xa4\x99\xfd\x5e\x1c\x9f\x6f\x8d\x96\xb5\xe2\xa8\xea\x06\xa7\xc5\x42\x21\xb4\xa6\x3f\xd6\xe0\x4a\x2c\xe4\xfd\xa2\x1c\xcc\xa3\xa4\x61\x84\x63\x4b\x7a\x4c\xd2\x73\x52\x1e\x7d\xe3\x86\x68\x17\xf2\x8b\x37\x43\xb4\x91\x62\x15\x06\x2b\x6c\xda\xa2\xa7\x54\x9c\xd0\xc8\xd2\x47\x06\x16\x98\x91\xa7\xcc\xf4\x18\xa3\x13\xa8\x1a\xc5\xc7\xa9\xd1\x8d\x99\x74\xec\xe7\x71\xd2\x83\x0b\xd1\xaf\x2e\x04\xa4\x60\x3b\xcd\x2e\xf3\x4a\xea\xc6\x1b\x1d\x44\xb6\xb7\x2b\xf7\x79\xa9\x9c\x4a\xa3\xcd\x52\x5a\x44\xb2\x49\xc5\x6b\x53\x19\xc8\x09\xd0\xb6\xb8\x74\x35\x65\x72\x84\xd0\x8d\x25\x7c\x5e\x15\xc2\xf9\x41\x0f\xce\x67\x0d\x5c\x88\xad\x0b\x11\x5e\xd6\xb2\xe6\x72\x68\xf2\xa9\xd8\x0f\x2d\x07\x2c\xf9\x80\xf1\x11\x66\x1c\xd1\x51\x9b\xcd\xe2\x15\x13\xe5\x14\x1d\xcf\x44\x12\x72\xc9\xfd\x8a\xd7\x6b\xb2\xdc\x27\x6a\x64\xb4\x4c\x51\x19\x6b\x26\xbd\x16\x88\xad\x16\x93\x05\xb7\xaf\xa5\xb2\x2c\xb4\xb1\xd8\x29\x5f\x88\xff\xbb\x10\x22\xa1\x9f\x6b\x63\x39\x98\xa1\x92\x45\x03\x15\x79\x2b\x4b\xae\x19\x47\x4b\xa5\xe3\x55\xcc\x4d\xac\x7a\x9b\xa7\xf4\x08\x63\x9c\x92\xe6\xda\x30\xb9\x2f\xca\x68\xc9\x23\x78\x2c\x1d\xd7\x50\x92\x0a\xd4\x1f\xb0\xe1\xd8\x47\x39\xa3\xb2\xe1\xd1\x8e\xff\xb3\x13\x86\xe8\xc8\x58\x19\x50\xc2\x45\x77\x4d\x99\x91\x33\x70\x1f\x46\x12\x1d\x53\x80\xc9\x03\x1c\x8d\x1e\xc5\x59\xb5\x3d\x09\xab\x3b\xdd\xcc\x24\xa0\x66\x08\x71\xc6\xcc\x9c\x1f\x7f\x53\x9e\xe0\xf6\xcb\xfd\x9f\xf6\x4e\x61\xff\xf4\xec\x00\xce\x5f\x9f\xef\xc1\xde\xc9\x0f\xe7\x47\xfb\xaf\xcf\xde\xdc\xf9\xaa\x96\x23\x9d\x07\xe2\xfc\xc8\x25\xfc\x27\x0c\x8e\x87\xfc\xf6\x59\x4e\xcc\xa2\x6e\x1e\xbb\xd0\x7c\x95\xf3\xe7\x61\x14\x9e\x97\x74\xc9\xeb\xba\x70\xcf\x5b\x62\x0f\x1a\x03\x08\x5b\x86\x0e\xb4\xa9\x38\x7b\x46\x13\x57\xb3\x6b\x8d\xdc\x94\x79\x7c\x9e\xc0\xca\x31\x0b\x94\x16\x7d\x0d\x80\x43\x90\x05\x97\xb7\xeb\x2b\x3c\xbe\xb4\x98\x34\x93\xd0\xf7\x57\xe3\x69\x15\x56\xc5\xdb\x79\x67\x8d\x72\x02\xad\x71\xdc\x03\xd8\xd7\x2a\x38\x68\x78\xe2\xb3\x39\x8b\xb6\xd3\xf8\x44\xc3\xd4\x4c\xba\xa0\xc3\x90\xcd\x6a\xb1\x09\x0c\xd6\x58\x1f\x9a\x59\x9b\x05\x2d\x22\x0b\xad\x96\x2e\xbb\x2d\x08\xe3\x57\xa9\x70\xca\x50\xd6\xa0\xb8\x5f\xeb\x5e\x9b\xa8\x2e\x3a\xa9\x06\x5c\x33\xf4\xa4\xd1\xb7\x42\xba\x98\xf2\x03\x4f\x4e\x0d\xe3\xb5\xc7\x35\xe1\xd1\x9f\x52\x71\xca\x03\x7f\xb3\x00\x02\xea\x98\x80\xee\x50\xc3\x47\x39\x49\xde\xb6\x57\xa0\x1e\x59\xfb\x2e\x69\x9f\xdd\xa5\xf6\xf8\x73\x2a\xb6\xe7\x3c\xd8\x0c\x79\x1c\x6f\xf3\xeb\x34\xb7\x9c\xd4\x01\xdf\x4f\xf9\x4c\x35\xf0\xf1\xd7\xc3\x37\xa7\x07\xe9\x4f\x7b\x87\x6f\x4e\xde\x84\x8b\x8b\x74\xed\x0d\x23\xa7\xda\x52\x86\x3e\x30\x73\x7f\xce\x21\x4b\xc3\x4b\x03\xb8\x75\xd5\xbf\xbe\xc5\x0e\x5a\xb2\x42\xd7\x83\x03\x3e\x9b\x7c\xae\xae\xfa\xd7\xe9\xd5\xce\xb5\x48\x94\xd4\x94\x8a\x9d\x4e\xf1\x9b\xa0\x79\xd5\xbf\x6e\x89\x36\xb6\x85\xdd\x10\xe7\x14\x95\xcc\x31\xb4\xc0\x53\x7e\xbf\xd5\xf2\x41\x1b\x47\x92\xbc\x25\x6b\xcd\x22\xc5\x1a\xad\xa3\x54\x3c\x98\xb7\xa3\x3d\x1f\x37\xe9\xa0\x46\x2b\xdb\x54\x17\x47\x6b\xd0\xea\x67\x4a\x46\x95\x87\x73\x40\x8d\x4a\xce\x50\x7b\x82\x17\x87\x07\x5b\x68\x8b\xa6\x22\xcd\x47\x39\x4a\x2b\x53\x38\xf2\x4d\x9d\x8a\xef\xd6\x1d\x44\xdb\x96\x0a\xe9\xbc\x35\x1b\x4e\x1a\x5d\x6a\xf3\x5e\x9b\xda\xa7\xe2\xd1\x1c\x5e\x33\xf1\xa2\x47\x30\x75\x26\x0d\x5c\x88\xab\xed\xeb\x0b\xf1\x94\xdb\xeb\xb4\xe9\xf0\x7f\x6f\x0d\xdc\xf7\x02\xa4\xee\xb5\xd8\xbd\x07\x2d\x11\x84\x93\x16\x61\x31\x42\xa9\x52\xf1\x78\x0e\x47\x2b\x51\xb5\x57\xc3\x4f\xe0\xd1\xa5\x3e\xa6\xac\x0c\x57\xce\x27\x73\x20\x8b\xd6\x4c\xc0\x86\xc3\x13\x1a\xcc\x53\x86\x3f\x97\x45\x24\x81\x36\xb3\x98\x79\x7f\x3b\x4a\x77\x76\x7d\x10\x5b\x72\x6b\xac\xa3\x36\x51\x2d\x15\xfd\xfe\x1c\x34\x69\xd9\x4c\x16\x52\x81\x04\x58\x2d\xc8\x8e\xd0\xa3\x1a\x91\xcf\xc6\xa9\xe8\xef\xcc\x21\xfc\xc7\xe8\x86\x14\xdf\xf4\x50\x33\x7c\xb6\xaf\xc3\x6c\x11\x5d\x58\xca\xcc\xb4\x53\xdb\x9d\x83\x25\x2c\xa5\x0d\xb7\xf2\x2f\xaa\x3e\x0d\x97\xbf\x2e\xea\x45\xac\x39\x4d\x47\xa6\xd1\x79\x2a\xfa\x0f\x62\xb0\xf1\x6c\x07\xcd\x70\x11\xf7\x28\x92\xb0\x09\x64\x6d\x2a\xfa\x0f\x3f\xbb\x0f\xd1\xe2\x4a\xf1\x5a\x62\xef\x6f\x20\x26\x58\xdc\xf8\x78\xd0\xb1\x3e\x7b\x24\xfd\x89\x21\x4b\xc8\xf1\x3d\x5a\x37\xa4\xa8\xf8\x03\x3b\x9f\x86\x13\xe1\xde\x7f\x3c\x87\x57\xdc\x84\x18\xbd\x01\xf7\x5f\xb0\x12\xd1\x32\x92\x3a\xef\xe6\x83\xfe\x93\xff\x21\x04\x65\x0a\x53\x93\x4e\xc5\xce\xf6\xba\x76\xc5\xa5\xb7\x95\x04\xd2\x11\xb0\x1d\x50\x57\xb4\x3d\x0e\x79\x17\x77\xfa\x73\x38\x43\xae\xca\x4a\xdb\x80\x33\x53\x9f\x98\xf7\x1d\x2f\x54\xa8\x6a\x25\xc1\x28\xd8\xee\xc5\xa5\x98\x83\x36\x63\xe3\x3c\x4f\xf5\xa9\xd8\xd9\xe1\x83\xc8\x03\x04\x6f\x40\xc9\x17\xc5\x6e\x31\x4a\x27\x6f\xdb\x7c\x7b\x91\x60\xda\x06\x90\x8a\x9d\xdd\x70\xca\x22\x2d\x75\x71\x84\x46\xc7\x8a\x3d\x78\x49\x8b\xa1\xa4\xd1\x0d\x90\x8a\x20\x37\xb6\x42\xd6\x7f\x30\x87\xfd\x00\x9c\x9a\x59\xa9\xed\x1a\xe0\x1a\xbb\x4a\xa2\xad\x30\x4f\x61\x0b\x5b\x57\xfd\xeb\x5e\x54\x5c\x21\xaa\xab\x9d\xeb\x76\x16\x91\xda\xf7\xe0\x27\x63\xbd\xe9\x78\x7a\xf7\x9a\xe7\xb3\x20\x35\x95\x99\xd1\xe1\xde\x9a\x85\xc9\xae\xcf\x63\xaa\x42\x37\x26\x97\x8a\x9d\x87\x73\xd8\x9b\x12\x6b\xfe\x41\x44\x4c\x6b\x71\x16\xbd\x75\xff\x16\xe3\x73\x1a\x9c\x5d\xf5\xaf\x9f\xc6\xe1\x8b\x3d\x95\xd6\x54\xa8\xc1\x36\xc3\xb6\x0f\xbd\x6d\xb7\xad\xa7\x70\x48\xea\x5d\xc2\x17\x94\x54\xc0\x4b\xbe\xb7\x9c\x3b\x1e\xbd\xc2\x30\x9e\x8a\x30\x7c\x77\x6f\x0a\x6c\x0a\x4a\x05\x1c\x1b\x4f\x3a\xd3\x72\x4a\x8a\x5f\xc7\xcb\x6c\x2a\x16\x97\x98\xd3\x30\x58\x77\x6b\x8b\x05\x7e\xd1\x0e\xec\x2b\x37\x27\x33\x81\x38\x9a\xf2\x3d\x07\x17\xce\x74\x98\x50\xd7\xde\xb6\x9f\x05\x99\xf8\xaa\x54\xc4\xaf\x1b\x0b\xf9\x65\x4e\x9a\x7c\xdb\x5e\x35\x79\xcc\xbc\x9c\x4a\x7f\x99\x8a\x9d\x8d\x93\x6e\x65\x46\xd3\x76\x78\x64\x99\x58\x81\xc2\xd4\xae\xf1\x52\x75\xd0\xa4\x62\x8a\xca\x52\x36\x4d\xc5\xce\xa3\xc8\x2c\x03\xd0\x54\xa0\x97\x53\x8c\x33\x70\x60\xcd\x9b\xdf\x9b\xce\x28\x17\xc3\x92\xcf\xd1\x37\xe1\xd0\x2d\xcd\xf6\xe0\x84\x32\xd2\xfe\xfb\x4b\x4f\xee\x84\xb2\xe9\x9a\x1f\x47\x9c\xf0\xce\xe3\x3f\xf7\xe3\x48\xe7\x7f\xd5\xcd\x29\x69\x3f\x58\xb4\xe5\xb8\x47\x5c\xf0\xae\xec\x5c\x75\x23\x92\xca\x34\xec\x9e\x07\x9f\xf0\x39\x96\xf2\x54\x9c\xcf\x02\xbd\x8e\x2c\xf1\x84\x43\xba\xc6\x02\x45\x62\x5d\x2a\x4e\xee\x73\x8f\x73\xa9\xf8\x17\x3f\x2c\x0d\xf3\x65\xf4\x5d\x12\xe6\x48\x9b\x0a\x78\x15\xbf\xf2\x0c\x80\xef\x31\x43\x52\x0c\x9f\xf8\xa9\x0b\xc4\x9a\x56\x6f\x4c\x98\x53\x18\x19\x42\x20\x3f\xa2\x2a\x1b\x65\x98\x25\xab\x0a\xb9\x07\xfc\xc8\x18\xce\x4d\x84\xe6\x8b\xe3\xf3\x6f\x23\x16\x8e\xa8\xfa\x56\x24\xb5\xcc\x53\x71\x7c\xf0\x52\xac\x47\xd3\x8d\x5a\xc1\xe8\xce\x06\x47\xb6\x14\xc3\xf7\xca\x32\xb8\xc3\xdc\xe8\xcf\xe0\xc0\x72\x7f\xa4\x29\x0f\x3f\xdb\xdc\x87\x60\xc3\xc0\xe2\xeb\x5d\x94\xe7\xdb\xc9\x6e\x7f\x63\xda\x51\xa4\x9b\x4a\xf2\x05\x8a\xb3\xd0\x70\xab\x76\xb7\xa2\x7c\xe7\x2e\x15\xbb\x3b\x9f\x0b\x70\xf9\x75\x70\x25\xb6\xae\x07\xd4\x32\xcf\x8c\x9e\xa6\x62\x77\x77\x5d\xb7\x34\x9a\xf9\x43\xc2\xf1\xc1\x4b\xc0\xc0\x45\x83\x96\x0b\x03\x81\x74\x4d\xa8\x6e\xa2\xfa\x83\x2f\xa8\xf3\xf6\x34\xb3\xc0\x54\x30\x52\xc6\x75\xae\xd7\xed\x54\x54\x45\x3b\x0f\xbf\x60\xe7\x88\xaa\xbf\x60\xa7\x20\x9f\x55\x79\x2a\x76\x37\x87\xb9\x95\x9d\x40\xbd\xdc\xc6\xcd\x6a\xf5\xa0\x76\x0c\xb1\x41\x4b\xcd\x72\xc0\x64\xdc\x83\x5a\xe6\x03\x26\xdf\x90\x70\x4d\x36\x0b\x87\x6d\xf7\xd1\x67\x59\xa1\x99\x75\x40\x08\xfe\x9c\x09\xdf\x90\xbe\xda\x53\x15\x58\x2e\x7a\x7a\xfc\x57\x3c\xcd\xe2\xe7\xa6\x4f\xc9\xe8\x4f\x9d\xc5\x09\x62\xf7\xc9\x06\x40\xe3\x14\x41\x4a\x2e\x87\xcc\xff\x06\x00\x00\xff\xff\xfe\x64\xdc\x00\x88\x19\x00\x00")

func eoTomlBytes() ([]byte, error) {
	return bindataRead(
		_eoToml,
		"eo.toml",
	)
}

func eoToml() (*asset, error) {
	bytes, err := eoTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "eo.toml", size: 6536, mode: os.FileMode(420), modTime: time.Unix(1611683234, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _tt_ttToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x58\x5b\x73\xdb\xb6\x97\x7f\xe7\xa7\x38\x8b\x4e\x9b\xcb\xc4\x8a\x25\x27\x69\xc3\x94\x9e\x49\x1c\x27\xeb\xa9\x9d\xba\xbe\x6c\x66\x27\xce\x03\x44\x1c\x92\xa8\x40\x00\x05\x40\x29\x5a\xcb\xdf\x7d\xe7\x00\xa4\x24\xc7\xce\xbf\x69\xdf\xa8\x83\x73\xc7\xb9\xfc\xa0\xd2\xe8\x4a\xd6\x95\x54\x58\xb0\x83\x77\xef\xe1\xdd\xf1\x21\xcb\x3a\xcf\x6b\x2c\x18\xd6\xdc\x5f\xe6\x70\xbd\x7b\x03\x9f\xbc\x36\x32\x58\xf3\xf9\x4a\x5f\xe9\xf4\xfd\x7b\x7e\xa5\x59\x16\x4c\xe0\xaa\x60\x8a\x07\x73\xc1\xb2\x2c\xfb\xd4\xa0\xb2\x9f\x33\xcb\x43\xe3\x0b\xe6\x50\x38\x03\x5a\xc2\x13\x67\x2a\x10\xd8\x94\x8e\xa3\x07\x74\x1c\x9e\xa0\x92\x15\xd4\xb2\xd2\xa6\x04\x6c\x02\x08\xcd\xe1\x89\x0f\x9d\x59\x72\x05\x3f\x81\xc7\x16\x9b\xd2\x3b\xa3\xe8\x5c\x4d\xb9\xe0\xe6\x38\x67\x99\x32\x75\xc1\xb4\x04\x2f\x21\x69\x30\x0a\xb0\xb9\x20\x2f\x59\xb6\x70\x32\x04\xd4\x05\x33\x01\x34\x86\x20\xdd\x22\x99\x38\x48\xe7\xe4\x5c\xc1\x18\xcb\xf6\xcb\x9d\x83\x5f\xc1\x19\xf8\x0b\xf2\x20\xbb\x3f\xb2\x2c\xa7\xa0\x78\x2d\xe7\x5c\x83\xf7\x58\x1a\x77\x9a\xd9\x0e\xf2\x7d\x7b\xf9\x6b\xf4\x6d\x06\x3b\x00\x99\x5e\x18\x01\xf9\xbe\x5e\x98\xb7\x89\xfc\x67\x24\xdb\x0e\xb0\xe6\x16\x2a\xc5\x1b\xc8\xf7\x3b\xd2\xbe\x66\xdf\x3e\x11\xc3\xc9\x20\xa1\x54\x57\x41\xbe\x3f\xbd\x2b\xd1\x9f\x54\x6b\x09\x13\xc0\x04\xb0\x6d\xf7\x27\xe4\xfb\xd8\x9a\xff\x4e\x1e\xd4\x75\x3c\x6e\x4d\x08\x66\xba\xc5\x21\xf4\x61\x62\x78\x1f\xcf\xb3\x3c\xde\x5b\xc9\xd7\xe1\xd5\x5a\xda\xce\xb8\xba\x27\x58\x40\x55\xd7\x26\x90\x37\xfc\x22\xd9\x7c\xf4\x7c\xfc\x10\x4e\xce\x0e\x2f\xde\x1f\x9d\x43\x13\xe4\x02\x3c\x0e\xdc\x95\x81\x24\xee\xcc\x5a\x83\xc0\x50\xa2\x42\x0f\x4a\xc9\x19\xe4\x42\x24\x2d\x7b\x0f\xe1\xe2\xe8\xf2\x8f\x7f\xa7\x64\xaf\x57\xf2\xf2\x21\x1c\x1f\x1f\xfd\xf6\xef\x94\xbc\x14\x7d\x12\x6a\x2d\x83\x33\x7e\x9d\x84\xcb\xd3\x03\xc8\xcb\x94\x41\x3c\x81\xbc\x8d\x9f\x6f\x8f\x4e\x21\xb7\x1b\x11\x87\x81\x8a\x6d\x10\xea\x7f\x92\x2e\x29\x10\x82\xe3\xc1\x43\xfe\x34\xf2\xe7\x8f\x06\x32\x2a\xd9\x2c\x1e\x46\x62\x2f\x10\x2c\x96\x25\x87\x7c\xdf\x61\xa0\xdb\xd9\x01\xd8\x1c\x3a\x8e\xaa\xa4\x9b\xb5\xbc\xf4\xfd\xd5\xa5\x3a\x4d\x6c\xd1\x11\xc5\x4b\x0f\x8d\xe5\xae\x06\x72\x97\x78\x2e\x4f\x0f\x32\x4d\xdd\x40\x47\x79\x13\xed\x85\xce\x0c\x04\xd5\x47\x31\x73\x66\x11\xf0\x43\x26\xb4\x29\xd1\x83\x43\x0b\x1e\xc3\x72\x0a\x22\x31\x92\x2a\x6f\xa7\x2d\x68\xc4\x45\xc0\xe9\xba\x1a\xa6\x51\x01\x75\xcd\x0f\x70\x71\xf6\xfa\xc3\xf9\xf1\xeb\x8b\xdf\xcf\xce\x73\x38\x55\xc8\x3d\x82\x30\xfa\x41\xa0\x1c\x68\xaf\x78\x40\x08\x0d\x82\xe2\x4b\xd3\x05\x78\xfc\x58\xf3\x16\xfd\xe3\xc7\x59\x22\x78\x28\x80\x31\x36\x74\xb9\x96\x3b\x41\xc9\xee\x4d\x9e\x01\x40\x50\x1d\xaf\x50\xd0\xa7\xe2\xad\xd4\xb2\xa5\xcf\xa5\xc3\x10\xf8\x94\x3e\x67\x5a\x7a\x8d\x4d\x19\xe4\xec\x9f\x39\x53\x1a\x65\x5c\xd9\x60\x8b\x5b\x0e\x45\xa2\x8f\xd4\xc1\xab\xed\x89\xf3\x2d\xd7\x1e\x09\x4d\x95\x36\x2b\xf9\x14\x30\xc8\x66\x01\xce\x54\x0f\x61\xe6\xb8\xd8\xd9\x62\x13\xf8\x7f\xd2\x71\x65\x7c\x74\x9c\x0e\x5f\x8c\x6f\xd1\x42\x53\x4b\xf5\x35\x51\xf2\x99\xd1\x26\xc6\x8d\xa5\x9c\xff\xb3\x28\x17\x52\xd4\xb8\x9d\xf2\x44\xb8\x93\x72\x10\xe8\x3b\xc0\x29\x68\x5e\x42\xe0\x4d\x00\x1f\xb0\x16\xf2\x63\x0c\x35\x95\x96\xe0\x46\x51\x5d\xc5\xca\xeb\x6c\xb9\x39\x21\xd9\xa5\x33\x2d\xb6\x60\xf9\xc2\xc3\x4f\xa0\x78\x29\xfd\xb2\x39\x8d\xbc\x2d\x46\xef\x3d\xba\x2e\x70\x87\xb6\xc5\x00\xce\x78\x8d\xe7\x74\x4c\x3f\x63\x70\xbe\x03\x9a\x45\x32\x38\x6e\x61\xe6\xa5\xb8\xa5\x85\x08\xc4\xe6\xf8\x74\xb8\x7f\x78\x0d\x3b\xe0\x70\x61\x6c\xcc\x2e\xb9\xd7\xd7\x73\x34\x1b\x50\xc7\xa4\x7a\xa9\x36\xc3\x6c\x4e\xc3\x8e\x1a\xed\x08\x76\xc0\x13\x8d\x12\x9a\x65\x9f\xb8\xab\xfd\xe7\x7e\x17\x8c\x34\xa2\x2b\x3d\x78\xd9\x04\x58\x98\xe6\x9c\xa5\xca\x28\xd8\x68\xbb\x1c\x38\x04\x3c\x67\x99\x2f\x39\x2d\xca\xdd\x7d\x5a\x68\xa1\xe4\x55\xdf\x64\x94\x9b\xf7\x2c\x9b\xa3\xf3\xd2\xe8\x82\x8d\x82\xfc\x82\xb1\xa3\xb4\x91\xde\xe1\x1c\x82\x96\xee\x94\x65\x16\x5d\x69\x3b\x62\xa0\x94\x2f\x62\x8e\x69\xf9\x69\x19\x3f\x9b\x92\xe3\xe0\x85\xed\xf8\xbc\xfe\x26\x27\xd6\xdc\xe1\x9c\xf7\xcc\x01\x5b\x1b\xad\x62\xa3\xd1\x35\xbc\x22\xb6\x5b\x97\x40\x7c\x7f\x77\xce\x32\x1f\x78\xe8\xfc\x94\xa7\xf0\x65\x88\x16\xe3\xb0\x75\x7c\xea\xbb\x40\x63\x6e\xb0\xe9\x78\xc0\x82\x8d\x7c\xbb\xbb\x3b\xa6\x6b\x9a\x23\x34\x1e\x5d\x85\x0e\x0a\xb8\x62\x91\x7e\xc5\x00\x46\x18\x3a\x2d\xdb\x7b\x58\xda\x74\x2e\xb0\x1f\x8b\x3e\x48\xdd\x41\xb4\x1b\xbc\x39\x81\xd1\xb2\xd4\xd8\xfd\x85\xae\xea\xc5\xce\x58\x3f\x47\x0a\xf6\x81\xb7\x08\xa6\x1a\x06\x8d\xb7\x58\x02\xa1\x18\xa8\x8c\x8b\xed\x70\x79\x34\x82\x4b\x8f\x70\xc5\x76\xae\x18\x04\x03\x56\x5a\x1c\xb1\x4c\x63\x28\x58\xad\xa5\xef\x40\xa0\x33\xba\x96\xd4\x0b\xc6\x2b\x1e\x1b\xc2\x63\xc9\xab\x54\x34\x23\x8f\x9d\xe2\x73\xda\x24\xdc\x71\x8b\x1e\x78\xdb\x9a\x12\x06\x61\x2d\x2b\x14\x43\x23\xad\xe5\x24\x28\xba\x19\x3c\x87\xd1\x86\x94\x6a\x55\x43\x5c\x49\xe7\x70\xc5\xfe\xeb\x8a\xb1\x0c\xbf\x58\xe3\x02\xdd\x9b\x33\xb4\xb0\x64\x25\x4b\xb4\x3e\x5d\xb3\x01\xa2\x7e\x41\x9a\x2f\xe0\x4b\xe9\x02\xb6\x11\x07\xe9\x43\x96\xb5\x53\xeb\x29\xf7\x34\xae\x3d\x07\x72\x70\x6d\x63\xa8\x08\x4f\x9a\x51\x10\x7a\x72\x9d\x92\xbc\x7a\x4a\x9d\x51\x76\xbe\xdf\x9e\xeb\x12\xf5\xc1\x63\x00\xaf\xbb\x33\xaa\x7d\x5d\x25\x30\xf8\xe8\xe2\xc3\xe1\xc9\xe5\xfb\xb3\xd7\x70\x71\x7e\x76\xf4\x0e\x0e\xdf\xc0\xc5\xf9\xe5\xc9\xc3\x61\x18\xd2\xd2\x15\x1c\x83\xa7\xd5\xe3\x3b\xc2\x1d\x1b\x44\x77\xc0\x32\x25\xc9\x01\x82\x5a\x5e\x73\x17\x56\x7e\x89\xb3\x95\x6f\x02\xb7\xab\xed\x41\xbb\xea\x07\xd3\xca\xd3\xc4\x43\xf1\x2b\x35\xf1\x71\xe6\xfb\xaa\xa7\x80\x87\xf5\x48\x79\xc0\x96\x6b\x48\x9c\x40\x3b\xce\xc7\xbe\x82\xbc\x97\xa6\x35\xb9\xb5\x5c\x84\x92\xdd\x94\xe2\x93\xc7\x90\x0f\x74\x62\xb9\x67\xd2\x6f\xf8\xb6\x0f\x89\x99\x7c\x86\x01\xb9\x92\x27\x11\x29\xba\xae\xc7\xae\xe4\x46\x2f\x19\x39\xd3\xf6\x25\x4b\xfc\x3f\x4d\x5b\x72\x28\xc5\x08\x90\x8d\x7c\xad\xa5\xd0\x72\x0a\xc2\x71\x33\x5d\xe2\x2c\x16\x01\x5d\x25\xe4\x94\xb9\x6c\x14\xc1\x1b\x57\x31\x99\xd4\xfd\x5d\xad\xb9\xa2\xda\x74\xc6\xda\xce\x0f\xbc\x44\xa5\xac\x13\x12\xa6\xf6\xdc\x46\xd9\xc3\xcd\xf1\xe8\x33\x06\xe9\x3e\xc6\x79\x98\xde\x00\x23\x74\xee\x73\x96\xbe\xfd\x52\x07\xfe\xa5\x60\xbb\x2b\xf0\x7c\x01\x4f\x0e\x2f\x8f\x5f\xff\x4f\xf1\xbf\x87\xbf\x51\x24\x42\x75\xa6\xf1\xf0\xea\x0b\x0f\x7a\xe9\x61\xdb\x82\xe0\xd3\x04\xb4\x05\x5a\x87\x25\x0f\x71\x1a\x8e\x57\x80\x5a\x2a\x3a\xc9\xe1\xc1\xf5\xf8\xe6\x41\xdf\x7a\x47\xa9\xfb\x79\x89\xce\xa2\x20\x48\x7f\x3d\xbe\x29\xae\x27\x37\x54\x3e\x1a\x0b\x36\xe9\x25\x7f\x88\xa2\xd7\xe3\x9b\x34\xea\xfa\x31\xbc\xb7\x82\xd4\xa1\x34\x84\xcf\x6d\x8b\x17\x20\xa4\xe2\x73\x2d\x93\x13\x59\xf6\x09\x9d\x33\xeb\xa8\x2c\x77\x1e\x0b\xf6\x6c\x75\xcb\x67\xf4\xb4\x84\x4c\x20\x1c\x24\x79\x95\x27\xd9\x52\xc9\x9e\xfd\x97\x15\xf8\xda\x71\x38\x3a\x3e\x88\xad\xef\xb8\xed\x79\x94\xa9\x3d\x86\xce\x16\xec\xe5\x6a\xf3\x18\xb1\x5d\x40\x7f\x47\x5f\xa7\x67\xda\x2c\xb4\xb1\xa1\x60\xe3\xdd\x15\xa4\xe7\x14\xe8\x85\xd1\x33\x7d\x09\x57\xec\x7a\xf7\xe6\x8a\xbd\x82\xa1\x90\x9d\x81\x27\xa9\x9e\x9e\xd0\xfd\xc3\x93\x5b\x65\xb9\x7e\x27\x2d\x5d\xa0\x57\x58\xbc\xed\x8a\x4b\x55\xb0\xf1\x78\x75\x5f\x95\x62\x7c\x0b\x0d\x5e\xbd\x1b\xa2\x6c\xb0\x9c\xc5\x17\xd5\x78\xb2\x82\xd6\xb8\x0a\x5e\x09\xa4\x99\xd5\x99\x52\x23\x78\x67\x9c\xc3\x78\x71\x2c\x6b\x31\x38\x59\xf6\x11\x8f\xf7\x56\x60\xbb\x88\x80\x29\xdc\x35\xdf\x30\xaa\xfa\xdb\xd2\xa6\x97\x2a\xd8\xf8\xd9\xea\xd6\x2c\x33\x3a\xf2\x47\xb6\x8a\x07\xae\x2a\x0c\x65\x53\xb0\xf1\xf3\x15\xa9\x6d\xca\x80\x55\xaf\x57\xf1\xc0\xab\xc8\x6d\x2a\x2d\x7b\xd5\x0e\x4b\x33\x1f\x64\x5e\xdc\x91\x49\x93\x63\x6e\x4a\x74\x51\x92\x1e\x3b\x56\xce\x3c\xbc\x22\x1d\xb0\x29\x28\x6d\x04\xce\x2b\xd3\x69\x51\xb0\xf1\xcf\xab\x28\x48\xf3\x2c\xb9\x47\x70\xaf\x62\x59\x8c\x1a\x9d\x2b\xd8\xf8\x97\xfb\x03\xef\xb5\x6d\xc1\xca\x34\x47\xc7\x43\x6d\x6c\xdf\x9f\xd0\xb2\xda\x94\x48\x34\xa4\xe5\x1d\x05\x0e\xb9\x28\xd8\x64\xf7\x3e\x05\x1c\xdd\x6d\x05\x77\xed\xf7\xf5\x3b\x19\xdf\x23\x7f\x7f\xd1\x57\x52\x8b\x61\xc1\x4e\x26\xff\xc4\xac\x32\xb5\xb1\xf4\xf0\x5e\x8b\x51\x2b\x68\xb4\xe6\x5e\xf6\xc0\xa7\x94\x1b\x62\x5e\x98\x33\x6b\x2e\x60\xb4\x0b\x3a\x4e\x47\x8f\xaa\xef\xea\xfe\x64\x6b\x13\x84\xde\x4f\x6d\x1a\xe3\x03\xe1\xdc\xde\x60\xcb\x75\xf0\xa6\x21\x5e\x08\x46\xc7\x11\x55\xf6\xcc\xd9\xa7\x14\xd2\xa8\x9f\x05\x09\x16\x17\x6c\xb2\x97\x04\x07\x03\x69\x74\x1c\x91\xd0\x08\x68\xbb\xa1\x36\x34\xee\x82\xef\x4e\xfa\x2a\x35\xae\xe5\x24\xf9\xac\x1f\x4b\xda\xf4\xf7\x1f\xbb\xf1\x38\x05\x98\x44\x5a\x08\xbc\xa5\x72\xbf\x1e\xdf\x8c\x86\xb9\x11\xb9\x0f\xe1\x7a\x72\x13\xc7\xaa\x70\xe6\x23\x8c\x08\x1f\x70\xda\xe2\xd7\x7b\x37\x23\x18\x93\x65\x7a\x1c\x60\x03\x0b\xe3\x80\x47\xd9\xcb\x11\xcb\xbc\xe2\xbe\x41\x5f\xb0\xc9\xf3\x8d\xf9\x5a\x4b\xed\xf8\xe2\x96\x03\xc2\x99\x05\x95\xd3\x83\xa7\x0f\x60\xa9\x79\x0b\xc6\x04\x72\xe3\x15\xcc\x74\xf7\x27\x70\x17\xbe\x20\x09\x46\xf0\x33\xa2\x04\xa5\x94\x8c\x14\x9f\xa2\xfa\x9c\x09\xe9\x67\x05\x83\xf8\xef\x0f\x61\xf1\xb7\x10\xd1\xe8\x9a\x44\xf0\x93\x65\xb4\x81\xb0\x60\xa0\x70\x8e\xc7\x11\x9a\x9f\x02\xcb\xa6\x3c\x04\x74\xcb\x82\x41\x44\x8b\xe7\x3d\x7e\x7f\xd3\x1f\x15\x6c\x8b\x90\x40\xeb\x36\x0c\xbd\x80\x1e\x9f\x0d\xc6\x7b\x88\x1f\xa9\x52\xdf\x39\x48\xff\x4d\xd1\x64\x6a\xd7\x47\xf1\x71\x72\x02\x71\xfa\xf7\x71\x69\x0c\x69\xb9\x69\xda\x35\x41\xce\x65\x58\x16\x6c\xf2\x62\x05\x4a\x86\xce\x5b\x53\xa7\xd1\xb7\x8c\x47\x25\xdf\xc0\x35\xac\xef\xf4\x88\xc6\x7a\xce\x95\xc3\x72\x5e\xb0\xc9\xcf\x2b\xc8\xe7\x25\x9e\xd1\x43\xfa\x4d\xd0\x48\xc3\x66\x74\x5b\x29\x0f\x5c\xac\x15\x0a\x9c\xcb\xc8\xb4\x54\x3d\x37\x95\x48\xbf\xc4\xe6\x32\xf0\x1a\x35\xe4\xeb\x99\x32\x58\xf3\x48\xb1\x4f\x7e\x59\x41\x1e\x34\x9e\x7f\xaf\xb5\xa0\xd1\x7f\xb7\xa5\x4d\xba\xe8\xfe\x87\x2a\xa0\xeb\x67\x59\x6b\x3a\x72\x80\xb6\xc2\x09\xcb\x3a\x8f\xa2\x60\x02\xfd\x25\xcb\x2a\x87\x58\x30\x44\xf7\x8e\x65\xce\x17\xcc\x3f\x3d\x63\xd9\x22\x7e\x7c\xdc\xd6\x69\x9d\x29\x3f\x67\x95\x54\x01\x5d\xc1\x20\x8f\x98\xee\x1d\x10\x9e\x9f\xa2\x8a\x55\xd0\xff\xb7\x02\xec\x96\xd0\xa8\x41\x2e\x30\xae\xf0\xb5\x0f\x07\x34\xe6\xda\x96\xd3\xc4\x16\x9a\x40\xf9\x41\x5f\xa1\x3f\x5e\x9e\x1e\xf4\xe5\xf0\x63\x8b\x27\x2c\xb3\x52\x14\xec\xed\xd1\xe9\x57\x4a\x7b\xa8\x13\x35\x4e\x5e\xae\x20\xbf\x9d\xc5\xb8\xfe\x62\x9d\xdf\xaa\x80\x94\x28\x47\x0b\x0d\xe7\x84\x3f\x76\x57\x04\x17\x37\x0f\x4e\xa4\xcd\xe6\xbe\x16\x20\xa8\xbe\x37\x5e\x41\x9e\x7c\x2d\xe1\x81\xb7\x0f\x00\x43\x57\xe2\x17\xfc\x9a\xb9\x36\xd6\x77\x81\x16\xf9\xde\xe4\x8e\x5f\x1b\x5b\xf7\xf8\x65\xa5\x28\x8d\x9e\x17\x6c\x6f\x2f\xd6\x89\x24\x86\xb7\x47\xa7\x10\x1c\xce\x09\x02\xdc\xe2\x1f\xc5\x11\x32\x2c\x0d\xdb\xf5\xa2\xcf\x48\x94\x1b\x15\xb7\x13\x35\x54\x97\xd2\x70\xbf\x8a\x3c\xc1\x3a\x52\xd1\x62\xdb\xab\x78\x7e\x57\x05\x35\xe4\xdf\xab\xa8\x31\x94\xad\x28\xd8\xde\x8b\x3b\x81\x0f\x99\xfb\x66\xf8\x23\xa0\xda\xf1\x36\x4f\xf3\x96\x30\xc2\xe4\x66\x04\x42\x12\x65\x2f\x85\x48\x6f\xef\xd8\x48\x7b\x3f\x7f\xdd\xf9\xc9\xcd\xce\x7e\xc3\x42\xfe\x5d\x26\x5a\x6c\x37\x26\x08\x35\x7e\xa5\x7e\xe9\x0c\xb6\xd8\xde\x6f\x82\xee\xfc\xfb\xcc\xf4\x6b\x7d\xef\xe5\x0a\x42\x67\x23\x92\xbf\x77\x99\xff\x7f\x00\x00\x00\xff\xff\xa5\x4d\x01\x63\xda\x17\x00\x00")

func tt_ttTomlBytes() ([]byte, error) {
	return bindataRead(
		_tt_ttToml,
		"tt_TT.toml",
	)
}

func tt_ttToml() (*asset, error) {
	bytes, err := tt_ttTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "tt_TT.toml", size: 6106, mode: os.FileMode(420), modTime: time.Unix(1611683613, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _zh_cnToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x9c\x58\xeb\x73\xd3\xd6\xb6\xff\xae\xbf\x62\xdd\xdd\xe9\xd0\x32\xe0\xc6\x0e\x14\x30\x88\x99\x5e\xca\xed\x65\x2e\xbd\x97\xe1\x71\xcf\x9c\x21\x7c\x50\xac\x6d\x5b\x8d\x2c\xe9\x48\xdb\x0e\x39\x71\x66\xcc\x23\x89\x43\x1e\x26\x69\x48\x20\xd0\x42\x68\x28\x81\x16\x9c\x52\x1e\xc6\x8e\x93\x3f\x06\x6d\xc9\xfe\xd4\x7f\xe1\xcc\x7e\xd8\xc8\x10\x4e\x1f\x9f\x2c\xad\xf7\x5a\x7b\xed\xdf\x5a\x72\xca\xb6\xd2\x46\x26\x6d\x98\x58\x45\xed\xf1\xd9\xb0\xf9\x34\x58\x9a\xf4\x1b\x2f\x91\x92\xf7\xb4\x0c\x56\x91\xdf\xdc\x0e\x17\xd7\x83\xa5\xd7\xc1\xaf\x37\x92\x30\xda\x37\x06\xe7\xdb\xa5\xa9\xf6\xea\xeb\x0b\x03\xd6\x80\x25\x1e\x93\x03\x16\x52\x88\x4d\x34\x53\x45\x41\xa9\xd1\x7a\xba\x8a\x14\x45\x39\x9f\xc5\xa6\x73\x41\x71\x34\x92\xf5\x54\x14\xcc\x4c\xb5\x57\xeb\xb4\x5e\xf1\x1b\x73\x7e\xe3\x81\x5f\x9b\xf6\x9b\xcc\x9d\xbf\x79\x93\x8e\x97\x5b\xd5\x06\xad\x2c\xb5\xc7\x67\x5b\x53\xcf\x98\xaf\xd5\xf2\x9b\xd2\x25\x5a\xbb\x42\x7f\x29\x89\x57\xba\x30\x13\x0d\x2f\x89\x14\xd3\xce\xa8\x28\x58\x7e\x40\xb7\x97\x05\xcd\x6f\xce\xfa\xf5\x39\x16\x22\x52\x86\x5d\x83\x10\x6c\xf5\xe6\x44\x5f\x3d\xa3\x13\xb7\xe8\xf8\x03\x21\xc3\xc2\x53\x11\x42\x4a\xbb\x54\xa2\x93\xf5\x24\xfc\x03\x6c\x17\x8e\x1c\xdb\x9b\x3a\xaa\x28\xad\xed\xdb\xe1\xfa\x34\xad\x6e\xb6\xca\x8f\x93\x0a\xc0\x5e\x18\x82\xa0\xbc\x04\x47\xce\x39\x47\x93\xe0\xd7\xae\xf9\xb5\x52\x6b\x75\x86\x73\xbe\x11\x9c\x2f\xed\x61\x8b\xf3\xa6\x23\xbc\x23\xc7\xf6\xe6\x85\x02\x9d\xbd\xd6\x5e\x7d\xd1\x21\xea\x42\xb2\x97\x38\xd8\x35\x1d\x21\xa6\xbb\x36\x3b\xc4\x4c\x46\x38\xfc\x6f\x3b\x87\x8f\x26\x81\x96\x37\xda\xab\x2f\xdb\x57\xd6\x39\xf3\x2b\xc1\x3b\x6e\xe9\x82\x45\xeb\x37\x18\x4b\x26\x14\x7c\x3b\xeb\x37\xef\x88\x84\x8e\x9c\xd5\x06\xb9\xcc\x64\x30\x7b\x5f\xb0\xc3\xc6\x55\xce\xd2\xf5\x24\xd0\xca\x7c\xbb\x74\xc9\xdf\x5e\xa5\x95\x57\x70\xe6\xc4\x57\x67\x8f\x9f\xfe\x1a\x3e\x89\xef\xff\x14\xc2\x46\x39\x78\x22\x35\x82\xf2\xd2\x3b\xaa\xfd\x1f\x52\xed\xff\x3d\xcd\x43\x1f\xd2\x3c\xf4\x6f\x34\x3b\x89\xcd\x2d\xd0\x7a\x45\x24\x96\x4a\xc2\xb1\x53\xe7\xf8\x63\x2e\x09\x74\x62\x9c\x3e\xb9\xc9\xdf\x9c\x24\x48\xe9\x7b\x93\xad\xea\x44\x47\xb7\xb5\x3d\x19\x34\xd6\x84\xee\x67\x49\xa0\x9b\x25\xfa\x70\x3a\xdc\x5c\x6a\x6d\xcd\x0b\x16\xbd\x25\x6a\xfb\x89\x20\x06\xcb\x2f\x3f\x65\xd2\xbc\x88\xc7\x2d\x82\x5d\x76\x44\xdb\xdf\xd1\x27\x37\xa3\xf2\xf2\xfc\x52\x47\xe5\x89\x78\x29\xcd\x61\xe7\x15\xd4\xc6\xdb\xb7\xd6\xde\x4a\x2a\xc7\x4e\x9d\x03\xba\x30\x23\x02\xa5\xb7\xb7\x68\xf3\x7e\x50\x5d\xf4\xb7\xa6\x45\x48\xd9\x24\x04\x8b\x5b\x74\xed\xa1\x20\x72\x9a\x99\x84\x70\xf3\x11\xdd\xa8\x48\x9a\x12\x36\xe7\xc3\x86\x3c\xd8\xc1\x24\xd0\x3b\xeb\x90\x1b\x74\x3c\x66\x17\x82\x6a\x25\x7c\xb8\x40\x9f\x2c\xb7\xae\x5d\x0e\x6e\x6c\x80\xff\x7a\xba\xbd\xfc\x5c\x9c\xbb\xc2\x2e\xc0\x47\x70\xf6\xf4\x17\xff\x7b\xe6\xe4\x17\x67\xff\xef\xf4\x99\x24\x9c\x32\xb1\xe6\x61\xd0\x6d\x6b\x17\x01\xe2\x6a\x96\x67\x6a\x04\x03\xc9\x62\x30\xb5\x11\x3b\x4f\x60\xf7\x6e\x4b\xcb\x61\x6f\xf7\x6e\x45\x10\x3c\x50\x01\x21\xc4\x32\x68\xd4\xa3\xd7\x96\x97\x49\xc7\x69\x2d\x6f\x12\xf6\x98\x33\x2c\x23\xa7\x99\xec\x71\x50\x23\x04\xbb\x23\xec\x71\xc8\x20\xa9\x2c\xb6\x3c\xc3\x1a\xfa\x73\xe1\xa4\x6c\xd3\x76\x53\x59\x9c\xc3\x91\x90\x38\xd1\xe3\xd4\x9e\xb8\xa2\xe8\xf2\x6e\x5c\xf2\x71\xaf\xae\xb9\x43\xf0\x49\xb8\xb8\xee\xd7\xe7\xc2\x5b\xcd\xd6\xd4\xb3\xd6\x95\x99\xe0\x56\xf5\x53\x26\xe4\xd9\xa6\xe6\x1a\xff\xc4\x7a\xcf\x4b\xfc\x73\xae\xf5\x2e\xcd\x34\x32\x59\x91\xb2\x6d\xd9\x43\x9a\xc1\x1e\x0b\x46\x0a\xb3\x5f\xcb\x76\xf5\x3f\x97\xe8\xb0\xa1\x67\x70\xb4\xee\x82\xd0\xc9\xaf\x52\x6d\xdd\xff\x49\x44\x1d\xad\x7e\xb8\x72\x35\x6c\x5c\x65\xc8\x77\x7d\x96\x67\x9c\x72\xf2\xbc\x2d\x59\xc7\xb5\x9e\xdf\x6d\x35\x9b\xf4\xf6\x16\x0f\x12\xe7\x38\x23\x9c\x7a\x14\x5e\x9f\x90\x9d\xb8\x30\xe3\xd7\xd7\x82\xd9\xfb\xe2\x55\x0c\x82\x70\x6e\x52\xaa\x10\x9c\x73\x98\x8a\xbf\x79\x2f\xb8\x7a\x97\xde\x5a\x0f\x6a\x8f\x68\xfd\x47\x5e\x4d\xc3\x1b\x7a\x6b\x2d\xfc\xe1\x52\x78\x9b\x59\xa3\xe5\x09\x3a\x53\xef\xda\x61\x92\x8e\x3d\x8c\x5d\x26\xb9\xf8\x22\xf8\xe5\x5e\x78\xed\x65\x50\xba\xc4\x2b\x84\x89\x88\x87\xb7\xb5\x08\x95\xcb\xbb\x76\xca\x83\xbd\x40\x2b\x55\xbf\xbe\xe6\xd7\x17\x24\x4e\x97\x97\x5b\xab\xeb\xac\xa4\x8a\x72\x5e\x73\x33\xde\x05\x89\xee\xc1\xcd\xad\x70\xad\x4e\x9b\xdf\xd2\xa9\x59\x96\xc6\xd3\xd7\x6f\x4a\x97\x91\x68\x11\x3e\x1c\x22\xf3\xe6\x32\x52\xbc\x94\xc6\x06\x61\xf4\x0e\xd2\x8d\x3a\xad\xff\xf8\xdb\xe6\xcc\xd1\x3e\xa4\x14\xb0\xeb\x19\xb6\xd5\xb1\x1b\x4e\x95\x83\x3b\x3f\xd3\xd7\x2f\xc5\x04\xe1\x26\x1c\xec\xa6\x9c\xbc\x8a\xd8\x0d\x64\x65\x16\x07\xe0\xd7\x9e\x08\x95\xa0\x5a\xf1\x6b\x8f\x19\x47\x04\xe2\xe4\xb5\x42\x66\x07\x69\xfa\xfa\x57\xfa\xdd\x64\x57\x8e\x15\xbb\x9b\xcd\xec\x5c\xb0\x51\x11\xd5\x16\x51\x13\x8d\xe4\xbd\x41\xcd\xed\x48\x04\xcb\x2f\xdb\xcb\xcf\x45\x35\x83\x7b\x15\x2e\xe4\x6a\x84\x65\x56\x7e\x15\x2c\x6d\xb4\xef\xcf\x87\x73\x93\x6f\x4a\x97\x69\xad\xd6\x7a\x78\x29\x5c\xb9\x2a\x34\xe8\xec\x0d\x36\x94\x57\x26\x68\xa5\x1a\x2e\xae\xbf\x29\x5d\x1e\x40\xf1\xdc\x00\x02\x95\x61\x08\x2d\x4f\xb4\x17\xee\x0a\x0b\x82\xd5\xd7\x97\xf3\x3a\xdc\x78\x5f\x5f\x50\xfd\x89\xe1\x4c\x47\x00\x49\x70\x50\x91\xec\xc9\x4a\xa5\xb5\xbd\x21\x47\xf1\xf5\xd9\x37\xa5\xcb\xa2\x15\x60\x00\xed\x1d\x40\xd0\xda\xfe\x3e\x98\x7b\xc0\xf5\x2c\x4c\x54\xd4\x2e\x4d\x05\xd3\x8f\xc2\xe6\x3c\x9d\x5d\x65\xa1\xae\xad\xf8\xb5\xc7\xe2\x35\x5c\x5c\x6f\x97\x96\x69\xe5\x15\x0b\x69\x65\x31\x6a\xe9\x3f\x06\x10\xd0\xed\x66\x78\xe3\x41\x30\x33\x49\x9f\xae\x74\xf5\x91\x82\x2f\x3a\xb6\x4b\x78\xad\x25\xef\xa7\x2a\xad\xfc\xc0\x46\xf3\x75\x96\x6e\x30\x33\xc9\xe6\xc2\xd6\xb7\x9d\xa3\x64\x00\xda\x3d\xea\xe6\x7c\xbb\x74\xd7\xaf\xd5\x39\xac\xca\x33\xf1\x88\x8a\x82\xa9\x87\xad\xd5\x99\xe0\xc5\x74\xab\x7a\x83\xbe\x7e\xd9\xda\x5e\xa4\xb7\xbf\x0f\xca\xd7\xe9\xb5\xbb\x41\x79\x89\xae\xfd\xd2\x7a\xfe\x20\xbc\x77\x49\xb6\x9d\x95\x16\xab\x96\xb8\xab\xc1\xed\x6d\xbf\xf1\x43\xb8\x59\x0f\xef\x5c\xa2\x15\x86\xcd\xe1\xca\xd5\xe8\xc6\xf2\xdb\x66\x99\x6e\x8f\xb7\x57\x1b\xc1\xcd\x6a\xf8\xf3\xcf\x7e\xad\xe4\xd7\x1e\x0b\xc9\xdf\x36\xa7\x90\x62\x1a\x2c\x04\x84\x14\x5a\x5e\xa6\x93\x75\x38\xa2\x63\x86\x31\x5e\x51\xc2\x72\x31\x8a\x85\x45\xbe\x89\x15\x87\xf0\x08\xe3\x5b\x19\xef\xa8\x40\x3e\xae\x91\x04\xd9\x5c\xfc\xe4\xfd\xfa\x9c\x98\x4f\xe1\xca\xd5\xd6\xd3\x2d\xba\x36\x49\xaf\xcf\x32\x69\x69\x97\x6d\x0d\xcc\x61\x30\x55\x0a\xee\x4c\xd1\x89\xf1\xb0\xf9\x34\x0a\x3c\x1c\x6b\x22\xae\x77\x92\x8f\x5e\x3e\x7e\xb5\x59\x74\x1d\xc1\x68\x11\x58\x7b\x5e\xbf\x13\x3e\xbf\xdf\x7a\x55\xa5\x5b\x6c\x57\x90\x70\xc8\x82\x16\x06\xdf\xc3\xbf\x2e\xf2\xf1\xf1\x82\x47\xba\xf9\x09\x85\xf0\xca\x93\xf6\xe2\x53\x91\x90\x95\x79\xcb\x5c\xac\x06\x33\xec\x3a\xb4\xaa\x4f\x5a\xeb\xa5\x70\xbb\xd1\xaa\xce\xc7\x58\x7d\xd9\x3e\xc9\xae\xcf\xc6\x84\xc0\x12\x11\x9f\xd8\x26\xc5\xf9\x45\x23\xe6\x87\xad\x28\xe7\xc5\x72\x1d\xc3\xae\x7b\x41\x11\xcf\xde\x88\x45\xb4\x8b\x2a\xea\x2b\xc2\xa0\xa6\x83\x20\x02\xeb\x09\x10\xac\xc3\xe0\x65\xed\xbc\xa9\xc3\x20\x86\xff\x39\xfe\x77\xf5\xff\xbf\x38\x79\xee\xf8\x1e\x18\xd6\x3c\xb1\xb4\xea\xd8\x71\x71\x4a\x23\x1c\x85\xe2\x45\x30\x0d\x0b\x33\x4e\x12\x76\x8d\xc6\xc7\x76\x81\xe1\x41\x47\x04\xeb\x31\x80\x13\x19\xcb\x76\xb1\x0e\xa3\xf1\x31\x75\x34\x31\xc6\x5a\xc6\xc2\x2a\x4a\x48\xcd\x8f\xb8\xea\x68\x7c\x4c\x40\x8c\xc4\xbf\xfe\x22\x18\x56\x41\x33\x0d\x1d\xce\xe2\x9c\x73\x86\x51\xa1\xa0\x99\x79\x2c\x82\x50\x94\xf3\xd8\x75\xed\x6e\x56\x8e\xe6\x7a\x58\x45\xfb\x8a\x90\xd6\x0c\x13\xeb\x40\x6c\xe0\xb4\x68\x82\x49\xa1\x9b\x32\x0d\x29\xbe\xbf\xc8\x85\x0c\x2b\x03\xc7\x4e\x9e\x00\x06\xdb\x52\xc6\xb4\x33\x1e\x26\x79\x47\x45\x9f\x47\x4d\x72\x1a\x98\x76\x8f\xbd\xbc\x35\x64\xd9\xc3\x96\xed\x10\x15\x1d\x28\xc2\x39\xf1\x0a\xb6\xc3\x4a\x04\x03\x68\xb4\x6f\x6c\x00\x1d\x06\xe2\x8e\x74\x9a\x77\x4f\x4f\x6b\xee\xe1\xed\xb1\x47\xb4\xdf\x1e\xf6\x05\x20\x6f\x04\xfb\xa6\xe1\xc7\xce\x02\x50\xd1\xc1\x22\xfc\x57\x37\x12\x4e\x97\xc9\xe5\x5d\x7e\x1a\x3d\x39\x66\x71\x6a\x88\x7f\x9f\x1c\x2a\x02\xaf\x94\x07\xd8\x4a\xd9\x79\xb6\x2b\x62\xfd\x30\xa4\x5d\x3b\xc7\x4f\x0d\x29\x39\x4c\x5c\x23\x25\xd3\x8d\xf7\x49\x79\x96\x2b\x61\x95\xc9\x3b\xfc\x9b\x4b\x4a\xc9\xa3\xb2\x6c\xf9\xae\xa2\x78\xbc\x08\x96\xdd\xe1\x43\xda\x76\xb9\x3c\x17\x4b\x6b\x44\x33\xd3\x98\xa4\xb2\x2a\x8a\x27\x58\x25\x89\x66\x4a\xfb\x9c\xcc\x1c\x30\x69\xc3\x4a\xdb\xd2\xb4\x8b\x53\x76\xa1\xa3\xd3\x5f\x04\xfe\x8e\x5d\x6d\xd0\xc4\x1f\xd2\x3c\x0c\xde\x90\xe1\x38\x92\xd4\x0d\x51\xc7\x85\xb4\x9d\xb7\x74\x15\xc5\xf7\xf1\x18\xf3\x1e\xb7\xc2\xd4\x38\x03\x29\x3c\x6b\xec\xba\x2a\x8a\xef\xdf\x39\x71\x69\x2d\x72\x60\x02\x3f\xe3\x3d\x8d\x91\x36\x2c\x3d\x7a\xa8\xe2\x42\x89\xf8\xde\x33\xe0\x62\x8d\xc5\x74\x20\x6a\x80\xd1\x76\x34\xf0\xbe\x7f\xd9\xbc\xf1\x83\x3b\x35\x7b\xaf\x01\xd9\x0d\x2c\xba\xce\x24\x8c\x1f\xfa\x33\x6e\x4d\x3b\x63\x3b\xec\x2b\x36\xd1\x17\x55\x63\xb4\xee\x35\x88\x88\x13\x56\x5f\x15\x25\xe2\x45\xe0\x8f\x9d\xad\xf1\xac\xed\x9c\xb6\x87\xe5\x05\x36\xb1\xe7\x01\xc9\x6a\x16\xf4\xc5\x24\x47\xc6\x69\xd9\x59\xdb\x23\x6c\xc1\x54\x51\x22\x51\x84\x14\xc7\x21\xcb\x26\xc0\x8c\x74\x78\x52\x58\x39\x2f\x52\x8a\x49\x20\x10\xae\x54\x94\xe8\x2f\xc2\x09\x89\x1d\xd2\x3d\xd3\x62\x4a\x31\x80\xaf\xf3\x1e\x61\xc8\x66\x5b\x18\xec\xb4\xec\x52\xdb\xcd\x69\x4c\x73\x5f\x11\x4e\x8a\xcf\x0b\xd1\x09\xb6\x15\x41\x37\x21\x05\x39\x69\x60\x34\x3e\x16\x83\xe3\x5c\xac\x83\x21\xa3\x89\x31\xd0\x3c\xd0\xc0\xb0\x48\x0c\xfe\x66\xbb\xba\x40\xcd\xfe\xb1\x18\x9c\xe3\x12\x1a\xb8\xf6\x30\x64\x31\xdb\xcc\x99\xfb\x78\x0c\x29\x9e\xa9\x79\x59\xec\xa9\x28\xb1\xbf\xeb\x7e\x58\x73\x2d\x26\xdf\x13\x00\xb1\x6d\xc8\x69\xd6\x08\xec\xfa\x6c\x17\x6b\xab\x61\xe6\x60\x34\x3e\x76\x18\x0c\x06\xb1\x4c\x1e\x5f\x24\xae\x06\xdf\xe4\xad\xa1\x18\x2b\x90\x48\x3f\x66\x6a\x83\xd8\xbc\xa0\xb0\x9d\x58\x45\x20\x96\xe1\xee\x0e\x0c\x7c\x05\x54\x11\x5f\xfe\xa2\xd4\x8c\x96\xcf\x60\x26\xbf\xf8\xa2\x3d\x59\x01\xa4\xc8\xcf\x25\x41\xea\xee\xca\x92\xd1\xa5\x42\x67\x55\x04\xb1\x1f\x82\x5c\xa6\xe4\x22\x1d\xf5\x60\x61\x62\x58\x3b\xb0\xc4\x9f\x3c\x0c\x98\x72\x2a\x82\x77\x76\x7f\xe0\xe0\x2f\x33\xb3\x30\x11\xb3\xcd\xc2\x44\x4b\x11\xa3\x60\x90\x11\x15\x25\x7a\xae\x26\x6f\x00\x4c\x86\x6d\x77\x08\x3a\x32\x02\xfe\x32\xb6\xe3\xe5\x89\x61\x76\xba\x0f\x67\x0a\x9a\xe9\xe2\x54\x41\x45\x89\x03\x12\x0d\x92\x60\xe1\x8c\x46\x8c\x42\x67\xfc\x30\x7c\x73\x71\x0a\x5b\xc4\x1c\xe1\x0f\x46\x01\xeb\x5d\x07\xba\x46\xb4\x5e\xe3\x31\x29\xfd\x9f\x23\x04\x7b\xa7\x71\xaa\xd0\xe3\xcd\xc3\xac\x00\x89\x83\x7f\xc8\x1b\x13\xfe\xa3\x9e\xce\x60\x8b\x24\xbb\xb3\x52\x96\x8b\x75\x40\xa7\x0f\x44\x1b\x20\x25\xc7\x66\x82\x8a\xe4\xa2\xf3\x6b\x23\x6c\xdc\x45\x4a\xde\xc3\xba\x8a\xe8\xab\x67\xa2\xec\x48\x49\xbb\x98\xed\x8c\x8f\xea\xed\xe5\x67\x48\x71\x3d\x15\xb5\xaa\x8d\xcf\xc2\x87\x0b\x48\x19\xf6\x54\x44\x27\x6e\x89\x97\xb7\xbe\xd8\x77\xd2\x05\x25\x6d\x98\x04\xbb\x2a\xdb\xad\xe5\x9f\x0d\x49\x60\x5b\xf9\x20\x36\x39\x91\x7d\x3a\x01\xea\x51\x8a\x65\xb1\xa6\x63\x3e\xd9\x79\x64\x7e\xed\x71\x70\x63\x83\x21\x60\x2e\xa7\x31\x30\xa7\xf3\x4d\xbf\xb1\x26\xdb\xf6\xd8\xa9\x73\x1f\xcb\x4e\x11\x8d\xf2\x31\x52\x1c\x43\x57\x51\xf4\x6f\x96\x77\x1c\xc8\x6d\x88\x5b\x4f\x1c\x7a\xb7\x57\xd8\x3d\xe0\xcc\x1d\x9b\xc4\x65\x63\x0e\x17\xd8\x8a\xd2\xd7\x0b\xa4\x82\xce\xbf\x0f\xb1\xe7\xe1\xce\x26\xc1\x16\xf8\xfe\x78\x54\x14\x5f\xc4\xa9\x3c\xc1\xb0\xcb\xf1\x76\x81\xcc\x4a\x0a\x77\x9c\xa9\xa8\x3f\xf1\x6e\x5c\x5d\xc3\x3b\xc6\xe5\x18\x7a\xca\xb6\x0a\x2a\xea\xef\x8f\x2a\x32\x1a\x76\x09\x9c\x3a\xf1\x25\x7b\x35\x64\x53\xc4\x38\xac\x74\x46\x8b\x93\x97\xaa\xfb\x76\x52\x65\xf5\xe0\xff\xc4\xf2\x39\x67\xda\xda\x0e\x26\x72\x38\x27\x4d\xec\xdf\xc9\xc4\xd7\x38\xf7\xbb\x26\x32\x98\xa4\x72\xba\x8a\xfa\xdf\xbb\xbc\x32\xf1\x4e\xa9\x76\x48\x3f\x06\x8e\x77\xca\xb5\x53\x49\x81\xca\x46\x92\x41\x71\x0c\x1c\x83\xd5\xb5\x5f\xa4\xc8\xbe\x8a\xf9\x65\xeb\x3f\xf0\x41\x07\x4e\x5e\x86\xf9\x17\x5c\xe4\x70\xee\xad\x8b\x83\x1f\x72\x91\xc3\x39\x6c\xbb\x23\x7f\xdd\x8d\x1c\xfe\xfd\x87\xde\x1f\xfe\x76\x9e\x38\xf9\xce\xa5\xff\x57\x00\x00\x00\xff\xff\x64\xea\x55\x27\x56\x17\x00\x00")

func zh_cnTomlBytes() ([]byte, error) {
	return bindataRead(
		_zh_cnToml,
		"zh_CN.toml",
	)
}

func zh_cnToml() (*asset, error) {
	bytes, err := zh_cnTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "zh_CN.toml", size: 5974, mode: os.FileMode(420), modTime: time.Unix(1611683670, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"de_DE.toml": de_deToml,
	"en_US.toml": en_usToml,
	"eo.toml":    eoToml,
	"tt_TT.toml": tt_ttToml,
	"zh_CN.toml": zh_cnToml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"de_DE.toml": &bintree{de_deToml, map[string]*bintree{}},
	"en_US.toml": &bintree{en_usToml, map[string]*bintree{}},
	"eo.toml":    &bintree{eoToml, map[string]*bintree{}},
	"tt_TT.toml": &bintree{tt_ttToml, map[string]*bintree{}},
	"zh_CN.toml": &bintree{zh_cnToml, map[string]*bintree{}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
