/// <reference types="node" />
import { ChildProcess } from 'child_process';
import { EventEmitter } from 'events';
import { ConfigService } from '../config/config.service';
import { Logger } from '../logger/logger.service';
export declare class HomebridgeIpcService extends EventEmitter {
    private logger;
    private configService;
    private homebridge;
    private permittedEvents;
    constructor(logger: Logger, configService: ConfigService);
    setHomebridgeProcess(process: ChildProcess): void;
    setHomebridgeVersion(version: string): void;
    private sendMessage;
    private requestResponse;
    restartHomebridge(): void;
    restartAndWaitForClose(): Promise<boolean>;
    killHomebridge(): Promise<void>;
    restartChildBridge(username: string): Promise<void>;
    getChildBridgeMetadata(): Promise<unknown>;
}
