#!/usr/bin/env node
export declare class HomebridgeServiceHelper {
    action: 'install' | 'uninstall' | 'start' | 'stop' | 'restart' | 'rebuild' | 'run' | 'add' | 'remove' | 'logs' | 'view' | 'update-node' | 'before-start' | 'status';
    selfPath: string;
    serviceName: string;
    storagePath: any;
    usingCustomStoragePath: boolean;
    allowRunRoot: boolean;
    enableHbServicePluginManagement: boolean;
    asUser: any;
    addGroup: string;
    private log;
    private homebridgeModulePath;
    private homebridgePackage;
    private homebridgeBinary;
    private homebridge;
    private homebridgeStopped;
    private homebridgeOpts;
    private homebridgeCustomEnv;
    private uiBinary;
    private stdout;
    docker: boolean;
    private uid;
    private gid;
    uiPort: number;
    private installer;
    private ipcService;
    get logPath(): string;
    constructor();
    logger(msg: any, type?: 'info' | 'succeed' | 'fail' | 'warn'): void;
    private setEnv;
    private showVersion;
    private startLog;
    private truncateLog;
    private launch;
    private startExitHandler;
    private runHomebridge;
    private handleHomebridgeClose;
    private runUi;
    private getNpmGlobalModulesDirectory;
    private findHomebridgePath;
    private refreshHomebridgePackage;
    private nodeVersionCheck;
    private nvmCheck;
    printPostInstallInstructions(): Promise<void>;
    portCheck(): Promise<void>;
    storagePathCheck(): Promise<void>;
    configCheck(): Promise<void>;
    createDefaultConfig(): Promise<void>;
    private generateBridgeConfig;
    private createDefaultUiConfig;
    private isRaspbianImage;
    private getLastKnownUiPort;
    private generatePin;
    private generateUsername;
    private generatePort;
    private isAvahiDaemonRunning;
    private chownPath;
    private checkForStaleHomebridgeProcess;
    private tailLogs;
    private viewLogs;
    get homebridgeStartupOptionsPath(): string;
    private loadHomebridgeStartupOptions;
    private fixDockerPermissions;
    private checkForNodejsUpdates;
    downloadNodejs(downloadUrl: string): Promise<string>;
    extractNodejs(targetVersion: string, extractConfig: any): Promise<void>;
    removeNpmPackage(npmInstallPath: string): Promise<void>;
    private checkStatus;
    private parseNpmPackageString;
    private npmPluginManagement;
}
