"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CarbonMonoxideSensorHandler = void 0;
const hap_1 = require("../../hap");
const binary_1 = require("./binary");
class CarbonMonoxideSensorHandler extends binary_1.BinarySensorHandler {
    constructor(expose, otherExposes, accessory) {
        super(accessory, expose, otherExposes, CarbonMonoxideSensorHandler.generateIdentifier, 'CarbonMonoxideSensor', (n, t) => new hap_1.hap.Service.CarbonMonoxideSensor(n, t), hap_1.hap.Characteristic.CarbonMonoxideDetected, hap_1.hap.Characteristic.CarbonMonoxideDetected.CO_LEVELS_ABNORMAL, hap_1.hap.Characteristic.CarbonMonoxideDetected.CO_LEVELS_NORMAL);
    }
    static generateIdentifier(endpoint) {
        let identifier = hap_1.hap.Service.CarbonMonoxideSensor.UUID;
        if (endpoint !== undefined) {
            identifier += '_' + endpoint.trim();
        }
        return identifier;
    }
}
exports.CarbonMonoxideSensorHandler = CarbonMonoxideSensorHandler;
CarbonMonoxideSensorHandler.exposesName = 'carbon_monoxide';
//# sourceMappingURL=carbon_monoxide.js.map