import { BasicAccessory } from '../interfaces';
import { ExposesEntryWithBinaryProperty, ExposesEntryWithProperty } from '../../z2mModels';
import { BinarySensorHandler } from './binary';
import { IdentifierGenerator } from './basic';
declare abstract class LeakSensorHandler extends BinarySensorHandler {
    constructor(subType: string, identifierGen: IdentifierGenerator, expose: ExposesEntryWithProperty, otherExposes: ExposesEntryWithBinaryProperty[], accessory: BasicAccessory);
    static generateIdentifier(endpoint: string | undefined, additionalSubType: string): string;
}
export declare class WaterLeakSensorHandler extends LeakSensorHandler {
    static readonly exposesName: string;
    private static readonly SUBTYPE;
    constructor(expose: ExposesEntryWithProperty, otherExposes: ExposesEntryWithBinaryProperty[], accessory: BasicAccessory);
    static generateIdentifier(endpoint: string | undefined): string;
}
export declare class GasLeakSensorHandler extends LeakSensorHandler {
    static readonly exposesName: string;
    private static readonly SUBTYPE;
    constructor(expose: ExposesEntryWithProperty, otherExposes: ExposesEntryWithBinaryProperty[], accessory: BasicAccessory);
    static generateIdentifier(endpoint: string | undefined): string;
}
export {};
//# sourceMappingURL=leak.d.ts.map