export declare type MqttValue = string | boolean | number;
export interface ExposesEntry {
    type: string;
    name?: string;
    endpoint?: string;
    access?: number;
    property?: string;
    unit?: string;
    values?: string[];
    value_off?: MqttValue;
    value_on?: MqttValue;
    value_step?: number;
    value_min?: number;
    value_max?: number;
}
export declare enum ExposesAccessLevel {
    PUBLISHED = 1,
    SET = 2,
    GET = 4
}
export declare enum ExposesKnownTypes {
    NUMERIC = "numeric",
    BINARY = "binary",
    SWITCH = "switch",
    LOCK = "lock",
    ENUM = "enum",
    TEXT = "text",
    COMPOSITE = "composite",
    LIGHT = "light",
    COVER = "cover",
    FAN = "fan",
    CLIMATE = "climate"
}
export declare const isExposesEntry: (x: any) => x is ExposesEntry;
export interface ExposesEntryWithFeatures extends ExposesEntry {
    features: ExposesEntry[];
}
export interface ExposesEntryWithProperty extends ExposesEntry {
    name: string;
    property: string;
    access: number;
}
export interface ExposesEntryWithNumericRangeProperty extends ExposesEntryWithProperty {
    name: string;
    property: string;
    access: number;
    value_min: number;
    value_max: number;
}
export interface ExposesEntryWithBinaryProperty extends ExposesEntryWithProperty {
    name: string;
    property: string;
    access: number;
    value_off: MqttValue;
    value_on: MqttValue;
}
export interface ExposesEntryWithEnumProperty extends ExposesEntryWithProperty {
    name: string;
    property: string;
    access: number;
    values: string[];
}
export declare const exposesHasFeatures: (x: ExposesEntry) => x is ExposesEntryWithFeatures;
export declare const exposesHasProperty: (x: ExposesEntry) => x is ExposesEntryWithProperty;
export declare const exposesHasNumericProperty: (x: ExposesEntry) => x is ExposesEntryWithProperty;
export declare const exposesHasNumericRangeProperty: (x: ExposesEntry) => x is ExposesEntryWithNumericRangeProperty;
export declare const exposesHasBinaryProperty: (x: ExposesEntry) => x is ExposesEntryWithBinaryProperty;
export declare const exposesHasEnumProperty: (x: ExposesEntry) => x is ExposesEntryWithEnumProperty;
export declare function exposesCanBeSet(entry: ExposesEntry): boolean;
export declare function exposesCanBeGet(entry: ExposesEntry): boolean;
export declare function exposesIsPublished(entry: ExposesEntry): boolean;
export interface ExposesPredicate {
    (expose: ExposesEntry): boolean;
}
export declare function exposesHasAllRequiredFeatures(entry: ExposesEntryWithFeatures, features: ExposesPredicate[], isPropertyExcluded?: ((property: string | undefined) => boolean)): boolean;
export declare function exposesGetOverlap(first: ExposesEntry[], second: ExposesEntry[]): ExposesEntry[];
export declare function exposesGetMergedEntry(first: ExposesEntry, second: ExposesEntry): ExposesEntry | undefined;
export declare function exposesAreEqual(first: ExposesEntry, second: ExposesEntry): boolean;
export declare function exposesCollectionsAreEqual(first: ExposesEntry[], second: ExposesEntry[]): boolean;
export interface DeviceDefinition {
    vendor: string;
    model: string;
    exposes: ExposesEntry[];
}
export declare const isDeviceDefinition: (x: any) => x is DeviceDefinition;
export interface DeviceListEntry {
    definition?: DeviceDefinition | null;
    friendly_name: string;
    ieee_address: string;
    supported: boolean;
    software_build_id?: string;
    date_code?: string;
}
export interface DeviceListEntryForGroup extends DeviceListEntry {
    group_id: number;
}
export declare const isDeviceListEntry: (x: any) => x is DeviceListEntry;
export declare const isDeviceListEntryForGroup: (x: any) => x is DeviceListEntryForGroup;
export declare function deviceListEntriesAreEqual(first: DeviceListEntry | undefined, second: DeviceListEntry | undefined): boolean;
export interface GroupMember {
    ieee_address: string;
    endpoint: number;
}
export declare const isGroupMember: (x: any) => x is GroupMember;
export interface GroupListEntry {
    friendly_name: string;
    id: number;
    members: GroupMember[];
}
export declare const isGroupListEntry: (x: any) => x is GroupListEntry;
//# sourceMappingURL=z2mModels.d.ts.map